/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.operator.list;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.Operator;
import de.janno.evaluator.dice.RandomElementsBuilder;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollContext;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.ValidatorUtil;
import de.janno.evaluator.dice.operator.OperatorOrder;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public class EqualFilter
extends Operator {
    public EqualFilter(int maxNumberOfElements, boolean keepChildrenRolls) {
        super("==", Operator.OperatorType.BINARY, Operator.Associativity.LEFT, OperatorOrder.getOderNumberOf(EqualFilter.class), maxNumberOfElements, keepChildrenRolls);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(final @NonNull List<RollBuilder> operands, final @NonNull ExpressionPosition expressionPosition) throws ExpressionException {
        if (operands == null) {
            throw new NullPointerException("operands is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new RollBuilder(){

            @Override
            @NonNull
            public Optional<List<Roll>> extendRoll(@NonNull RollContext rollContext) throws ExpressionException {
                if (rollContext == null) {
                    throw new NullPointerException("rollContext is marked non-null but is null");
                }
                ImmutableList<Roll> rolls = RollBuilder.extendAllBuilder(operands, rollContext);
                ValidatorUtil.checkRollSize(expressionPosition, rolls, 2, 2);
                Roll left = (Roll)rolls.getFirst();
                Roll right = (Roll)rolls.get(1);
                ValidatorUtil.checkContainsSingleElement(expressionPosition, right, "right");
                ImmutableList diceResult = (ImmutableList)left.getElements().stream().filter(re -> ((RollElement)right.getElements().getFirst()).isEqualValueAndTag((RollElement)re)).collect(ImmutableList.toImmutableList());
                return Optional.of(ImmutableList.of((Object)new Roll(this.toExpression(), (ImmutableList<RollElement>)diceResult, RandomElementsBuilder.fromRolls(rolls, rollContext), (ImmutableList<Roll>)ImmutableList.of((Object)left, (Object)right), expressionPosition, EqualFilter.this.maxNumberOfElements, EqualFilter.this.keepChildrenRolls)));
            }

            @Override
            @NonNull
            public String toExpression() {
                return EqualFilter.getBinaryOperatorExpression(expressionPosition, operands);
            }
        };
    }
}

