/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.operator.list;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.Operator;
import de.janno.evaluator.dice.RandomElementsBuilder;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollContext;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.ValidatorUtil;
import de.janno.evaluator.dice.operator.OperatorOrder;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;

public class KeepHighest
extends Operator {
    public KeepHighest(int maxNumberOfElements, boolean keepChildrenRolls) {
        super("k", null, null, Operator.Associativity.LEFT, OperatorOrder.getOderNumberOf(KeepHighest.class), maxNumberOfElements, keepChildrenRolls);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(final @NonNull List<RollBuilder> operands, final @NonNull ExpressionPosition expressionPosition) throws ExpressionException {
        if (operands == null) {
            throw new NullPointerException("operands is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new RollBuilder(){

            @Override
            @NonNull
            public Optional<List<Roll>> extendRoll(@NonNull RollContext rollContext) throws ExpressionException {
                if (rollContext == null) {
                    throw new NullPointerException("rollContext is marked non-null but is null");
                }
                ImmutableList<Roll> rolls = RollBuilder.extendAllBuilder(operands, rollContext);
                ValidatorUtil.checkRollSize(expressionPosition, rolls, 2, 2);
                Roll left = (Roll)rolls.getFirst();
                Roll right = (Roll)rolls.get(1);
                int rightNumber = right.asInteger().orElseThrow(() -> ValidatorUtil.throwNotIntegerExpression(expressionPosition, right, "right"));
                if (rightNumber < 0) {
                    throw new ExpressionException(String.format("The number to keep can not be negativ but was %d", rightNumber), expressionPosition);
                }
                String rightTag = ((RollElement)right.getElements().getFirst()).getTag();
                ImmutableList otherTagElements = (ImmutableList)left.getElements().stream().filter(r -> !r.getTag().equals(rightTag)).collect(ImmutableList.toImmutableList());
                ImmutableList keep = (ImmutableList)left.getElements().stream().filter(r -> r.getTag().equals(rightTag)).collect(Collectors.groupingBy(RollElement::getTag)).values().stream().flatMap(cl -> cl.stream().sorted(Comparator.reverseOrder()).limit(rightNumber)).collect(ImmutableList.toImmutableList());
                return Optional.of(ImmutableList.of((Object)new Roll(this.toExpression(), (ImmutableList<RollElement>)ImmutableList.builder().addAll((Iterable)keep).addAll((Iterable)otherTagElements).build(), RandomElementsBuilder.fromRolls(rolls, rollContext), (ImmutableList<Roll>)ImmutableList.of((Object)left, (Object)right), expressionPosition, KeepHighest.this.maxNumberOfElements, KeepHighest.this.keepChildrenRolls)));
            }

            @Override
            @NonNull
            public String toExpression() {
                return KeepHighest.getBinaryOperatorExpression(expressionPosition, operands);
            }
        };
    }
}

