/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.operator.list;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.Operator;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollContext;
import de.janno.evaluator.dice.ValidatorUtil;
import de.janno.evaluator.dice.operator.OperatorOrder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public class Repeat
extends Operator {
    public Repeat(int maxNumberOfElements, boolean keepChildrenRolls) {
        super("x", null, null, Operator.Associativity.LEFT, OperatorOrder.getOderNumberOf(Repeat.class), maxNumberOfElements, keepChildrenRolls);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(final @NonNull List<RollBuilder> operands, final @NonNull ExpressionPosition expressionPosition) throws ExpressionException {
        if (operands == null) {
            throw new NullPointerException("operands is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new RollBuilder(){

            @Override
            @NonNull
            public Optional<List<Roll>> extendRoll(@NonNull RollContext rollContext) throws ExpressionException {
                if (rollContext == null) {
                    throw new NullPointerException("rollContext is marked non-null but is null");
                }
                List<Roll> leftRolls = ((RollBuilder)operands.getFirst()).extendRoll(rollContext).orElse(Collections.emptyList());
                ValidatorUtil.checkRollSize(expressionPosition, leftRolls, 1, 1);
                int left = leftRolls.getFirst().asInteger().orElseThrow(() -> ValidatorUtil.throwNotIntegerExpression(expressionPosition, (Roll)leftRolls.getFirst(), "left"));
                if (left > 10 || left < 1) {
                    throw new ExpressionException(String.format("The number of repeat must between 1-10 but was %d", left), expressionPosition);
                }
                RollBuilder right = (RollBuilder)operands.get(1);
                ImmutableList.Builder builder = ImmutableList.builder();
                for (int i = 0; i < left; ++i) {
                    List<Roll> rightRoll = right.extendRoll(rollContext).orElse(Collections.emptyList());
                    ValidatorUtil.checkRollSize(expressionPosition, rightRoll, 1, 1);
                    builder.addAll(rightRoll);
                }
                return Optional.of(builder.build());
            }

            @Override
            @NonNull
            public String toExpression() {
                return Repeat.getBinaryOperatorExpression(expressionPosition, operands);
            }
        };
    }
}

