/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.operator.list;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.Operator;
import de.janno.evaluator.dice.RandomElementsBuilder;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollContext;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.ValidatorUtil;
import de.janno.evaluator.dice.operator.OperatorOrder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public class RepeatList
extends Operator {
    public RepeatList(int maxNumberOfElements, boolean keepChildrenRolls) {
        super("r", null, null, Operator.Associativity.LEFT, OperatorOrder.getOderNumberOf(RepeatList.class), maxNumberOfElements, keepChildrenRolls);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(final @NonNull List<RollBuilder> operands, final @NonNull ExpressionPosition expressionPosition) throws ExpressionException {
        if (operands == null) {
            throw new NullPointerException("operands is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new RollBuilder(){

            @Override
            @NonNull
            public Optional<List<Roll>> extendRoll(@NonNull RollContext rollContext) throws ExpressionException {
                if (rollContext == null) {
                    throw new NullPointerException("rollContext is marked non-null but is null");
                }
                List<Roll> leftRolls = ((RollBuilder)operands.getFirst()).extendRoll(rollContext).orElse(Collections.emptyList());
                ValidatorUtil.checkRollSize(expressionPosition, leftRolls, 1, 1);
                int left = leftRolls.getFirst().asInteger().orElseThrow(() -> ValidatorUtil.throwNotIntegerExpression(expressionPosition, (Roll)leftRolls.getFirst(), "left"));
                if (left > 20 || left < 0) {
                    throw new ExpressionException(String.format("The number of list repeat must between 0-20 but was %d", left), expressionPosition);
                }
                if (left == 0) {
                    return Optional.of(List.of());
                }
                RollBuilder right = (RollBuilder)operands.get(1);
                ImmutableList.Builder builder = ImmutableList.builder();
                for (int i = 0; i < left; ++i) {
                    List<Roll> rightRoll = right.extendRoll(rollContext).orElse(Collections.emptyList());
                    ValidatorUtil.checkRollSize(expressionPosition, rightRoll, 1, 1);
                    builder.addAll(rightRoll);
                }
                ImmutableList rolls = builder.build();
                return Optional.of(ImmutableList.of((Object)new Roll(this.toExpression(), (ImmutableList<RollElement>)((ImmutableList)rolls.stream().flatMap(r -> r.getElements().stream()).collect(ImmutableList.toImmutableList())), RandomElementsBuilder.fromRolls((Collection<Roll>)rolls, rollContext), (ImmutableList<Roll>)rolls, expressionPosition, RepeatList.this.maxNumberOfElements, RepeatList.this.keepChildrenRolls)));
            }

            @Override
            @NonNull
            public String toExpression() {
                return RepeatList.getBinaryOperatorExpression(expressionPosition, operands);
            }
        };
    }
}

