/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.operator.math;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.Operator;
import de.janno.evaluator.dice.RandomElementsBuilder;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollContext;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.ValidatorUtil;
import de.janno.evaluator.dice.operator.OperatorOrder;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public final class IntegerDivide
extends Operator {
    public IntegerDivide(int maxNumberOfElements, boolean keepChildrenRolls) {
        super("/", Operator.OperatorType.BINARY, Operator.Associativity.LEFT, OperatorOrder.getOderNumberOf(IntegerDivide.class), maxNumberOfElements, keepChildrenRolls);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(final @NonNull List<RollBuilder> operands, final @NonNull ExpressionPosition expressionPosition) throws ExpressionException {
        if (operands == null) {
            throw new NullPointerException("operands is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new RollBuilder(){

            @Override
            @NonNull
            public Optional<List<Roll>> extendRoll(@NonNull RollContext rollContext) throws ExpressionException {
                int quotient;
                if (rollContext == null) {
                    throw new NullPointerException("rollContext is marked non-null but is null");
                }
                ImmutableList<Roll> rolls = RollBuilder.extendAllBuilder(operands, rollContext);
                ValidatorUtil.checkRollSize(expressionPosition, rolls, 2, 2);
                Roll left = (Roll)rolls.getFirst();
                Roll right = (Roll)rolls.get(1);
                ValidatorUtil.checkAllElementsAreSameTag(expressionPosition, left, right);
                int leftNumber = left.asInteger().orElseThrow(() -> ValidatorUtil.throwNotIntegerExpression(expressionPosition, left, "left"));
                int rightNumber = right.asInteger().orElseThrow(() -> ValidatorUtil.throwNotIntegerExpression(expressionPosition, right, "right"));
                try {
                    quotient = Math.divideExact(leftNumber, rightNumber);
                }
                catch (ArithmeticException e) {
                    throw new ExpressionException(e.getMessage(), expressionPosition);
                }
                ImmutableList res = ImmutableList.of((Object)new RollElement(String.valueOf(quotient), ((RollElement)left.getElements().getFirst()).getTag(), ""));
                return Optional.of(ImmutableList.of((Object)new Roll(this.toExpression(), (ImmutableList<RollElement>)res, RandomElementsBuilder.fromRolls(rolls, rollContext), (ImmutableList<Roll>)ImmutableList.of((Object)left, (Object)right), expressionPosition, IntegerDivide.this.maxNumberOfElements, IntegerDivide.this.keepChildrenRolls)));
            }

            @Override
            @NonNull
            public String toExpression() {
                return IntegerDivide.getBinaryOperatorExpression(expressionPosition, operands);
            }
        };
    }
}

