/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.operator.math;

import com.google.common.collect.ImmutableList;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.ExpressionPosition;
import de.janno.evaluator.dice.Operator;
import de.janno.evaluator.dice.RandomElementsBuilder;
import de.janno.evaluator.dice.Roll;
import de.janno.evaluator.dice.RollBuilder;
import de.janno.evaluator.dice.RollContext;
import de.janno.evaluator.dice.RollElement;
import de.janno.evaluator.dice.ValidatorUtil;
import de.janno.evaluator.dice.operator.OperatorOrder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public final class NegateAddRemove
extends Operator {
    private static final BigDecimal MINUS_ONE = BigDecimal.valueOf(-1L);

    public NegateAddRemove(int maxNumberOfElements, boolean keepChildrenRolls) {
        super("-", Operator.Associativity.RIGHT, OperatorOrder.getOderNumberOf(NegateAddRemove.class), Operator.Associativity.LEFT, OperatorOrder.getOderNumberOf(NegateAddRemove.class), maxNumberOfElements, keepChildrenRolls);
    }

    @Override
    @NonNull
    public RollBuilder evaluate(final @NonNull List<RollBuilder> operands, final @NonNull ExpressionPosition expressionPosition) throws ExpressionException {
        if (operands == null) {
            throw new NullPointerException("operands is marked non-null but is null");
        }
        if (expressionPosition == null) {
            throw new NullPointerException("expressionPosition is marked non-null but is null");
        }
        return new RollBuilder(){

            @Override
            @NonNull
            public Optional<List<Roll>> extendRoll(@NonNull RollContext rollContext) throws ExpressionException {
                if (rollContext == null) {
                    throw new NullPointerException("rollContext is marked non-null but is null");
                }
                ImmutableList<Roll> rolls = RollBuilder.extendAllBuilder(operands, rollContext);
                ValidatorUtil.checkRollSize(expressionPosition, rolls, 1, 2);
                if (rolls.size() == 1) {
                    Roll right = (Roll)rolls.getFirst();
                    ValidatorUtil.checkContainsOnlyDecimal(expressionPosition, right, "right");
                    ImmutableList negated = (ImmutableList)right.getElements().stream().map(e -> new RollElement(e.asDecimal().orElseThrow().multiply(MINUS_ONE).stripTrailingZeros().toPlainString(), e.getTag(), e.getColor())).collect(ImmutableList.toImmutableList());
                    return Optional.of(ImmutableList.of((Object)new Roll(this.toExpression(), (ImmutableList<RollElement>)negated, RandomElementsBuilder.fromRolls(rolls, rollContext), (ImmutableList<Roll>)ImmutableList.of((Object)right), expressionPosition, NegateAddRemove.this.maxNumberOfElements, NegateAddRemove.this.keepChildrenRolls)));
                }
                Roll left = (Roll)rolls.getFirst();
                Roll right = (Roll)rolls.get(1);
                ImmutableList.Builder resultBuilder = ImmutableList.builder();
                ArrayList<RollElement> toRemove = new ArrayList<RollElement>((Collection<RollElement>)right.getElements());
                for (RollElement rollElement : left.getElements()) {
                    Optional<RollElement> matchingElement = toRemove.stream().filter(r -> r.isEqualValueAndTag(rollElement)).findFirst();
                    if (matchingElement.isPresent()) {
                        toRemove.remove(matchingElement.get());
                        continue;
                    }
                    resultBuilder.add((Object)rollElement);
                }
                if (toRemove.stream().anyMatch(r -> r.asDecimal().isEmpty())) {
                    throw new ExpressionException(String.format("'%s' requires as right input only decimals or elements that are on the left side '%s' but was '%s'", expressionPosition.getValue(), left.getElements().stream().map(RollElement::getValue).toList(), right.getElements().stream().map(RollElement::getValue).toList()), expressionPosition);
                }
                resultBuilder.addAll(toRemove.stream().map(e -> new RollElement(e.asDecimal().orElseThrow().multiply(MINUS_ONE).stripTrailingZeros().toPlainString(), e.getTag(), e.getColor())).toList());
                return Optional.of(ImmutableList.of((Object)new Roll(this.toExpression(), (ImmutableList<RollElement>)resultBuilder.build(), RandomElementsBuilder.fromRolls(rolls, rollContext), (ImmutableList<Roll>)ImmutableList.of((Object)left, (Object)right), expressionPosition, NegateAddRemove.this.maxNumberOfElements, NegateAddRemove.this.keepChildrenRolls)));
            }

            @Override
            @NonNull
            public String toExpression() {
                if (operands.size() == 1) {
                    return NegateAddRemove.getRightUnaryExpression(expressionPosition, operands);
                }
                return NegateAddRemove.getBinaryOperatorExpression(expressionPosition, operands);
            }
        };
    }
}

