/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.random;

import de.janno.evaluator.dice.DieId;
import de.janno.evaluator.dice.DieIdAndValue;
import de.janno.evaluator.dice.ExpressionException;
import de.janno.evaluator.dice.random.NumberSupplier;
import de.janno.evaluator.dice.random.RandomNumberSupplier;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;

public class GivenDiceNumberSupplier
implements NumberSupplier {
    private final NumberSupplier numberSupplier;
    private final Map<DieId, Integer> givenDiceNumbers;

    public GivenDiceNumberSupplier(@NonNull List<DieIdAndValue> givenDiceNumbers) {
        this(new RandomNumberSupplier(), givenDiceNumbers);
        if (givenDiceNumbers == null) {
            throw new NullPointerException("givenDiceNumbers is marked non-null but is null");
        }
    }

    public GivenDiceNumberSupplier(@NonNull NumberSupplier numberSupplier, @NonNull List<DieIdAndValue> givenDiceNumbers) {
        if (numberSupplier == null) {
            throw new NullPointerException("numberSupplier is marked non-null but is null");
        }
        if (givenDiceNumbers == null) {
            throw new NullPointerException("givenDiceNumbers is marked non-null but is null");
        }
        this.numberSupplier = numberSupplier;
        HashSet<DieId> allDiceIds = new HashSet<DieId>();
        HashSet<DieId> duplicatedDiceIds = new HashSet<DieId>();
        for (DieIdAndValue dieIdAndValue : givenDiceNumbers) {
            if (allDiceIds.contains(dieIdAndValue.getDieId())) {
                duplicatedDiceIds.add(dieIdAndValue.getDieId());
            }
            allDiceIds.add(dieIdAndValue.getDieId());
        }
        if (!duplicatedDiceIds.isEmpty()) {
            throw new IllegalStateException("Duplicated dice ids: " + String.valueOf(duplicatedDiceIds));
        }
        this.givenDiceNumbers = givenDiceNumbers.stream().collect(Collectors.toMap(DieIdAndValue::getDieId, DieIdAndValue::getNumberSupplierValue));
    }

    @Override
    public int get(int minExcl, int maxIncl, @NonNull DieId dieId) throws ExpressionException {
        if (dieId == null) {
            throw new NullPointerException("dieId is marked non-null but is null");
        }
        if (this.givenDiceNumbers.containsKey(dieId)) {
            return this.givenDiceNumbers.get(dieId);
        }
        return this.numberSupplier.get(minExcl, maxIncl, dieId);
    }
}

