/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.random;

import com.google.common.annotations.VisibleForTesting;
import de.janno.evaluator.dice.DieId;
import de.janno.evaluator.dice.random.NumberSupplier;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import lombok.NonNull;

@VisibleForTesting
public class GivenNumberSupplier
implements NumberSupplier {
    private final Deque<Integer> results;

    public GivenNumberSupplier() {
        this(Collections.emptyList());
    }

    public GivenNumberSupplier(Integer ... results) {
        this(Arrays.asList(results));
    }

    public GivenNumberSupplier(Collection<Integer> results) {
        this.results = results == null ? new ArrayDeque<Integer>() : new ArrayDeque<Integer>(results);
    }

    @Override
    public int get(int minExcl, int maxIncl, @NonNull DieId dieId) {
        if (dieId == null) {
            throw new NullPointerException("dieId is marked non-null but is null");
        }
        if (this.results.isEmpty()) {
            return maxIncl;
        }
        return this.results.pop();
    }
}

