/*
 * Decompiled with CFR 0.152.
 */
package de.janno.evaluator.dice.random;

import java.security.SecureRandom;
import java.util.random.RandomGenerator;

public class Sfc64Random
implements RandomGenerator {
    private long state_a;
    private long state_b;
    private long state_c;
    private long counter;

    public Sfc64Random(long seed, long seed2, long seed3) {
        this.doSeed(seed, seed2, seed3);
    }

    public Sfc64Random(long seed, long seed2) {
        this.doSeed(seed, seed2);
    }

    public Sfc64Random(long seed) {
        this.doSeed(seed);
    }

    public Sfc64Random() {
        SecureRandom seed_source = new SecureRandom();
        this.doSeed(seed_source.nextLong(), seed_source.nextLong(), seed_source.nextLong());
    }

    @Override
    public long nextLong() {
        long result = this.state_a + this.state_b + this.counter++;
        this.state_a = this.state_b ^ this.state_b >>> 11;
        this.state_b = this.state_c + (this.state_c << 3);
        this.state_c = result + Long.rotateLeft(this.state_c, 24);
        return result;
    }

    private void doSeed(long seed_c, long seed_b, long seed_a) {
        this.state_a = seed_a;
        this.state_b = seed_b;
        this.state_c = seed_c;
        this.counter = 1L;
        for (int i = 0; i < 20; ++i) {
            this.nextLong();
        }
    }

    private void doSeed(long seed_c, long seed_b) {
        this.doSeed(seed_c, seed_b, 3141592653589793L);
    }

    private void doSeed(long seed) {
        this.doSeed(seed, 3848217513876480L);
    }
}

