/*
 * Decompiled with CFR 0.152.
 */
package animatefx.animation;

import animatefx.animation.AnimationFX;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class GlowBackground
extends AnimationFX {
    private final Background originalBackground;
    private CornerRadii originalRadii;
    private Insets originalInsets;

    public GlowBackground(Region node, Color colorA, Color colorB, int colorSteps) {
        super((Node)node);
        this.originalBackground = (Background)this.getNode().backgroundProperty().get();
        if (this.originalBackground != null && !this.originalBackground.getFills().isEmpty()) {
            BackgroundFill lastFill = (BackgroundFill)this.originalBackground.getFills().get(this.originalBackground.getFills().size() - 1);
            this.originalRadii = lastFill.getRadii();
            this.originalInsets = lastFill.getInsets();
        } else {
            this.originalRadii = CornerRadii.EMPTY;
            this.originalInsets = Insets.EMPTY;
        }
        int totalFrames = colorSteps * 2;
        double millisPerFrame = 1000 / totalFrames;
        for (int i = 0; i < totalFrames; ++i) {
            double frac = (double)i * 2.0 / (double)totalFrames;
            Duration dur = Duration.millis((double)((double)i * millisPerFrame));
            Color color = i <= colorSteps ? colorA.interpolate(colorB, frac) : colorB.interpolate(colorA, frac - 1.0);
            this.getTimeline().getKeyFrames().add((Object)new KeyFrame(dur, new KeyValue[]{new KeyValue((WritableValue)this.getNode().backgroundProperty(), (Object)new Background(new BackgroundFill[]{new BackgroundFill((Paint)color, this.originalRadii, this.originalInsets)}))}));
        }
    }

    public GlowBackground(Background originalBackground) {
        this.originalBackground = originalBackground;
    }

    public Region getNode() {
        return (Region)super.getNode();
    }

    @Override
    AnimationFX resetNode() {
        this.getNode().setBackground(this.originalBackground);
        return this;
    }

    @Override
    void initTimeline() {
        this.setTimeline(new Timeline());
    }
}

