/*
 * Decompiled with CFR 0.152.
 */
package animatefx.util;

import animatefx.animation.AnimationFX;
import javafx.animation.Animation;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;

public class ParallelAnimationFX {
    private Animation.Status status;
    private ObjectProperty<Node> node;
    private boolean reset;
    private ObservableList<AnimationFX> animations = FXCollections.observableArrayList();

    public final ObjectProperty<Node> nodeProperty() {
        if (this.node == null) {
            this.node = new SimpleObjectProperty((Object)this, "node", null);
        }
        return this.node;
    }

    public ParallelAnimationFX(Node node) {
        this.nodeProperty().set((Object)node);
        this.reset = false;
    }

    public ParallelAnimationFX(Node node, AnimationFX ... animations) {
        this.nodeProperty().set((Object)node);
        this.getAnimation().setAll((Object[])animations);
        this.reset = false;
    }

    public ParallelAnimationFX(AnimationFX ... animations) {
        this.getAnimation().setAll((Object[])animations);
        this.reset = false;
    }

    public ParallelAnimationFX() {
    }

    public final ObservableList<AnimationFX> getAnimation() {
        return this.animations;
    }

    public void setNode(Node value) {
        if (this.node != null || value != null) {
            this.nodeProperty().set((Object)value);
        }
    }

    public void play() {
        this.initAnimations();
        ((AnimationFX)this.getAnimation().get(0)).play();
        this.status = Animation.Status.RUNNING;
    }

    private void initAnimations() {
        for (AnimationFX animation : this.animations) {
            if (this.nodeProperty().get() != null && animation.getNode() == null) {
                animation.setNode((Node)this.nodeProperty().get());
            }
            animation.play();
        }
    }

    public void stop() {
        this.status = Animation.Status.STOPPED;
        for (AnimationFX animationFX : this.animations) {
            animationFX.stop();
        }
    }

    public Animation.Status getStatus() {
        return this.status;
    }

    public void setResetOnFinished(boolean value) {
        this.reset = value;
    }
}

