/*
 * Decompiled with CFR 0.152.
 */
package animatefx.util;

import animatefx.animation.AnimationFX;
import javafx.animation.Animation;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;

public class SequentialAnimationFX {
    private Animation.Status status;
    private ObjectProperty<Node> node;
    private boolean reset;
    private ObservableList<AnimationFX> animations = FXCollections.observableArrayList();

    public final ObjectProperty<Node> nodeProperty() {
        if (this.node == null) {
            this.node = new SimpleObjectProperty((Object)this, "node", null);
        }
        return this.node;
    }

    public SequentialAnimationFX(Node node) {
        this.nodeProperty().set((Object)node);
        this.reset = false;
    }

    public SequentialAnimationFX(Node node, AnimationFX ... animations) {
        this.nodeProperty().set((Object)node);
        this.getAnimation().setAll((Object[])animations);
        this.reset = false;
    }

    public SequentialAnimationFX(AnimationFX ... animations) {
        this.getAnimation().setAll((Object[])animations);
        this.reset = false;
    }

    public SequentialAnimationFX() {
    }

    public final ObservableList<AnimationFX> getAnimation() {
        return this.animations;
    }

    public void setNode(Node value) {
        if (this.node != null || value != null) {
            this.nodeProperty().set((Object)value);
        }
    }

    public void play() {
        this.initAnimations();
        ((AnimationFX)this.getAnimation().get(0)).play();
        this.status = Animation.Status.RUNNING;
    }

    private void initAnimations() {
        for (int i = 0; i < this.getAnimation().size() - 1; ++i) {
            if (this.nodeProperty().get() != null && ((AnimationFX)this.getAnimation().get(i)).getNode() == null) {
                ((AnimationFX)this.getAnimation().get(i)).setNode((Node)this.nodeProperty().get());
            }
            if (this.getAnimation().get(i + 1) == null) continue;
            ((AnimationFX)this.getAnimation().get(i)).playOnFinished((AnimationFX)this.getAnimation().get(i + 1));
        }
        if (this.nodeProperty().get() != null && ((AnimationFX)this.getAnimation().get(this.getAnimation().size() - 1)).getNode() == null) {
            ((AnimationFX)this.getAnimation().get(this.getAnimation().size() - 1)).setNode((Node)this.nodeProperty().get());
        }
        if (this.reset) {
            ((AnimationFX)this.getAnimation().get(this.getAnimation().size() - 1)).setResetOnFinished(true);
        }
    }

    public void stop() {
        this.status = Animation.Status.STOPPED;
        for (AnimationFX animationFX : this.animations) {
            animationFX.stop();
        }
    }

    public Animation.Status getStatus() {
        return this.status;
    }

    public void setResetOnFinished(boolean value) {
        this.reset = value;
    }
}

