/*
 * Decompiled with CFR 0.152.
 */
package io.github.uchagani.allure.playwright;

import com.microsoft.playwright.impl.APIResponseAssertionsImpl;
import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.util.ResultsUtils;
import java.lang.reflect.Field;
import java.util.UUID;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class APIResponseAssertionsImplAspect {
    private static final InheritableThreadLocal<AllureLifecycle> lifecycle = new InheritableThreadLocal<AllureLifecycle>(){

        @Override
        protected AllureLifecycle initialValue() {
            return Allure.getLifecycle();
        }
    };

    public static AllureLifecycle getLifecycle() {
        return (AllureLifecycle)lifecycle.get();
    }

    public static void setLifecycle(AllureLifecycle allure) {
        lifecycle.set(allure);
    }

    private static boolean getIsNot(APIResponseAssertionsImpl apiResponseAssertionsImpl) throws NoSuchFieldException, IllegalAccessException {
        Field isNotField = apiResponseAssertionsImpl.getClass().getDeclaredField("isNot");
        isNotField.setAccessible(true);
        return (Boolean)isNotField.get(apiResponseAssertionsImpl);
    }

    @Pointcut(value="execution(* com.microsoft.playwright.impl.APIResponseAssertionsImpl.isOK())")
    public void apiResponseIsOk() {
    }

    @Before(value="apiResponseIsOk()")
    public void stepStartApiResponse(JoinPoint joinPoint) throws NoSuchFieldException, IllegalAccessException {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        APIResponseAssertionsImpl apiResponseAssertionsImpl = (APIResponseAssertionsImpl)joinPoint.getTarget();
        String stepName = "Expect APIResponse to ";
        if (APIResponseAssertionsImplAspect.getIsNot(apiResponseAssertionsImpl)) {
            stepName = stepName + "not ";
        }
        stepName = stepName + "be OK";
        String uuid = UUID.randomUUID().toString();
        StepResult result = new StepResult().setName(stepName);
        APIResponseAssertionsImplAspect.getLifecycle().startStep(uuid, result);
    }

    @AfterThrowing(pointcut="apiResponseIsOk()", throwing="e")
    public void stepFailed(Throwable e) {
        APIResponseAssertionsImplAspect.getLifecycle().updateStep(s -> s.setStatus(ResultsUtils.getStatus((Throwable)e).orElse(Status.BROKEN)).setStatusDetails((StatusDetails)ResultsUtils.getStatusDetails((Throwable)e).orElse(null)));
        APIResponseAssertionsImplAspect.getLifecycle().stopStep();
    }

    @AfterReturning(pointcut="apiResponseIsOk()")
    public void stepStop() {
        APIResponseAssertionsImplAspect.getLifecycle().updateStep(s -> s.setStatus(Status.PASSED));
        APIResponseAssertionsImplAspect.getLifecycle().stopStep();
    }
}

