/*
 * Decompiled with CFR 0.152.
 */
package io.github.uchagani.allure.playwright;

import com.google.gson.JsonObject;
import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.util.AspectUtils;
import io.qameta.allure.util.ResultsUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class ChannelOwnerAspect {
    static final Map<String, String> actionMethodNamesMap = new HashMap<String, String>();
    private static final InheritableThreadLocal<AllureLifecycle> lifecycle = new InheritableThreadLocal<AllureLifecycle>(){

        @Override
        protected AllureLifecycle initialValue() {
            return Allure.getLifecycle();
        }
    };

    public static AllureLifecycle getLifecycle() {
        return (AllureLifecycle)lifecycle.get();
    }

    public static void setLifecycle(AllureLifecycle allure) {
        lifecycle.set(allure);
    }

    @Pointcut(value="execution(* com.microsoft.playwright.impl.ChannelOwner.sendMessage(String, com.google.gson.JsonObject))")
    public void actionMethods() {
    }

    @Before(value="actionMethods()")
    public void beforeActionMethods(JoinPoint joinPoint) {
        String method = (String)joinPoint.getArgs()[0];
        String actionName = actionMethodNamesMap.get(method);
        if (actionName == null) {
            return;
        }
        String uuid = UUID.randomUUID().toString();
        JsonObject params = (JsonObject)joinPoint.getArgs()[1];
        String stepName = this.getStepName(method, params);
        List parameters = AspectUtils.getParameters((MethodSignature)((MethodSignature)joinPoint.getSignature()), (Object[])joinPoint.getArgs());
        StepResult result = new StepResult().setName(stepName).setParameters(parameters);
        ChannelOwnerAspect.getLifecycle().startStep(uuid, result);
    }

    @AfterThrowing(pointcut="actionMethods()", throwing="e")
    public void stepFailed(Throwable e) {
        ChannelOwnerAspect.getLifecycle().updateStep(s -> s.setStatus(ResultsUtils.getStatus((Throwable)e).orElse(Status.BROKEN)).setStatusDetails((StatusDetails)ResultsUtils.getStatusDetails((Throwable)e).orElse(null)));
        ChannelOwnerAspect.getLifecycle().stopStep();
    }

    @AfterReturning(pointcut="actionMethods()")
    public void stepStop() {
        ChannelOwnerAspect.getLifecycle().updateStep(s -> s.setStatus(Status.PASSED));
        ChannelOwnerAspect.getLifecycle().stopStep();
    }

    private String getStepNameForAssertion(JsonObject params) {
        String expression = params.get("expression").getAsString().replace(".", " ");
        String expectedText = "";
        try {
            expectedText = ": " + params.get("expectedText").getAsJsonArray().get(0).getAsJsonObject().get("string").getAsString();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return "Expect " + params.get("selector").getAsString() + " " + expression + expectedText;
    }

    private String getStepNameForAPIRequest(JsonObject params) {
        return params.get("method").getAsString() + " " + params.get("url").getAsString();
    }

    private String getStepNameForNavigation(JsonObject params) {
        return "Navigate to " + params.get("url").getAsString();
    }

    private String getStepNameForLocator(String method, JsonObject params) {
        String selector = params.get("selector").getAsString();
        if (selector.equals(":root")) {
            selector = "page";
        }
        return actionMethodNamesMap.get(method) + selector;
    }

    private String getStepNameForDragAndDrop(JsonObject params) {
        return "Drag " + params.get("source").getAsString() + " to " + params.get("target").getAsString();
    }

    private String getStepNameForFill(JsonObject params) {
        return "Fill " + params.get("selector").getAsString() + " with " + params.get("value").getAsString();
    }

    private String getStepNameForPress(JsonObject params) {
        return "Press key(s) " + params.get("key").getAsString() + " on " + params.get("selector").getAsString();
    }

    private String getStepNameForSetInputFiles(JsonObject params) {
        String filename = params.get("files").getAsJsonArray().get(0).getAsJsonObject().get("name").getAsString();
        return "Set input file(s) to " + filename;
    }

    private String getStepNameForType(JsonObject params) {
        return "Type " + params.get("text").getAsString() + " on " + params.get("selector").getAsString();
    }

    private String getStepName(String method, JsonObject params) {
        if (method.equals("fetch")) {
            return this.getStepNameForAPIRequest(params);
        }
        if (method.equals("goto")) {
            return this.getStepNameForNavigation(params);
        }
        if (method.equals("expect")) {
            return this.getStepNameForAssertion(params);
        }
        if (method.equals("dragAndDrop")) {
            return this.getStepNameForDragAndDrop(params);
        }
        if (method.equals("fill")) {
            return this.getStepNameForFill(params);
        }
        if (method.equals("press")) {
            return this.getStepNameForPress(params);
        }
        if (method.equals("setInputFiles")) {
            return this.getStepNameForSetInputFiles(params);
        }
        if (method.equals("type")) {
            return this.getStepNameForType(params);
        }
        if (method.equals("goBack")) {
            return "Go back ";
        }
        if (method.equals("goForward")) {
            return "Go forward ";
        }
        if (method.equals("close")) {
            return "Close page";
        }
        return this.getStepNameForLocator(method, params);
    }

    static {
        actionMethodNamesMap.put("check", "Check ");
        actionMethodNamesMap.put("click", "Click ");
        actionMethodNamesMap.put("dblclick", "Double click ");
        actionMethodNamesMap.put("dragAndDrop", "");
        actionMethodNamesMap.put("fill", "");
        actionMethodNamesMap.put("focus", "Focus on ");
        actionMethodNamesMap.put("hover", "Hover over ");
        actionMethodNamesMap.put("press", "");
        actionMethodNamesMap.put("selectOption", "Select option from ");
        actionMethodNamesMap.put("setInputFiles", "Set input file(s) to ");
        actionMethodNamesMap.put("tap", "Tap ");
        actionMethodNamesMap.put("type", "");
        actionMethodNamesMap.put("uncheck", "Uncheck ");
        actionMethodNamesMap.put("goBack", "Go back ");
        actionMethodNamesMap.put("goForward", "Go forward ");
        actionMethodNamesMap.put("close", "Close page");
        actionMethodNamesMap.put("goto", "Navigate to ");
        actionMethodNamesMap.put("expect", "");
        actionMethodNamesMap.put("fetch", "");
    }
}

