/*
 * Decompiled with CFR 0.152.
 */
package org.javagrader;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;

public class RestrictedClassLoader
extends URLClassLoader {
    Set<String> blacklist = new HashSet<String>();
    Set<String> whitelist;
    static Set<String> defaultBlackList = new HashSet<String>();
    static Set<String> defaultWhitelist;

    public RestrictedClassLoader(URL[] urls, ClassLoader parent) {
        this(urls, parent, defaultBlackList, defaultWhitelist);
    }

    public RestrictedClassLoader(URL[] urls, ClassLoader parent, Set<String> blacklists) {
        this(urls, parent, blacklists, defaultWhitelist);
    }

    public RestrictedClassLoader(URL[] urls, ClassLoader parent, Set<String> blacklists, Set<String> whitelist) {
        super(urls, parent);
        this.blacklist.addAll(blacklists);
        this.blacklist.addAll(defaultBlackList);
        this.whitelist = whitelist;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.isForbidden(name)) {
            throw new ClassNotFoundException(String.format("%s is forbidden and cannot be imported", name));
        }
        return super.loadClass(name);
    }

    public boolean isForbidden(String name) {
        return (this.whitelist == null || !this.whitelist.contains(name)) && this.blacklist != null && this.blacklist.contains(name);
    }

    public Object convertInstance(String name, byte[] toConvert) {
        System.out.println(name);
        Class<?> c = this.defineClass(name, toConvert, 0, toConvert.length);
        return c;
    }

    static {
        defaultBlackList.add("java.lang.Thread");
        defaultBlackList.add("java.lang.ClassLoader");
        defaultWhitelist = null;
    }
}

