/*
 * Decompiled with CFR 0.152.
 */
package org.javagrader;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.javagrader.Grade;
import org.javagrader.PrintConstants;
import org.javagrader.TestMethodResult;
import org.javagrader.TestResultStatus;

public class TestClassResult {
    private final List<TestMethodResult> resultList = new ArrayList<TestMethodResult>();
    private final Class<?> testClass;
    private double sumMaxGradesInTestWithoutIgnored = 0.0;
    private double sumGradesInTest = 0.0;
    private double sumMaxGradeInTest = 0.0;
    private double maxGrade = 0.0;
    private final String displayName;
    private final boolean isGradeAnnotated;
    private boolean isOneFailure = false;

    public TestClassResult(String displayName, Class<?> testClass) {
        this.testClass = testClass;
        this.displayName = displayName;
        this.isGradeAnnotated = testClass.isAnnotationPresent(Grade.class);
        if (this.isGradeAnnotated) {
            Grade g = testClass.getAnnotation(Grade.class);
            this.maxGrade = g.value();
        }
    }

    public void addTestMethodResult(TestMethodResult result) {
        this.resultList.add(result);
        if (this.isGradeAnnotated || result.isGraded()) {
            this.sumGradesInTest += result.grade();
            this.sumMaxGradeInTest += result.maxGrade();
            this.sumMaxGradesInTestWithoutIgnored += result.isAborted() || result.isDisabled() ? 0.0 : result.maxGrade();
            this.isOneFailure = this.isOneFailure || result.status() != TestResultStatus.SUCCESS;
        }
    }

    public String format(PrintConstants.PrintMode mode) {
        if (mode.equals((Object)PrintConstants.PrintMode.NONE)) {
            return "";
        }
        StringJoiner stringJoiner = new StringJoiner("\n");
        stringJoiner.add(this.myFormat(mode));
        this.resultList.forEach(t -> stringJoiner.add(t.format(mode, this.maxGrade(), this.sumMaxGradeInTest)));
        return stringJoiner.toString();
    }

    private String myFormat(PrintConstants.PrintMode mode) {
        if (mode.equals((Object)PrintConstants.PrintMode.NONE)) {
            return "";
        }
        return String.format("%s%s%s%s%s%s%s%s", PrintConstants.globalPrefix(mode), PrintConstants.separator(mode, PrintConstants.SeparatorsType.CLASS_PREFIX), this.displayName, PrintConstants.separator(mode, PrintConstants.SeparatorsType.CLASS_SUFFIX), PrintConstants.separator(mode, PrintConstants.SeparatorsType.CONTENT), this.status(), PrintConstants.separator(mode, PrintConstants.SeparatorsType.CONTENT), PrintConstants.formatGrade(this.grade(), this.maxGrade()));
    }

    private String status() {
        if (this.isOneFailure) {
            return PrintConstants.statusToIcon(TestResultStatus.FAIL);
        }
        return PrintConstants.statusToIcon(TestResultStatus.SUCCESS);
    }

    public double grade() {
        if (this.isGradeAnnotated) {
            return this.sumGradesInTest / this.sumMaxGradeInTest * this.maxGrade;
        }
        return this.sumGradesInTest;
    }

    public double maxGrade() {
        if (this.isGradeAnnotated) {
            return this.maxGrade;
        }
        return this.sumMaxGradeInTest;
    }

    public double maxGradeWithoutAborted() {
        if (this.isGradeAnnotated) {
            return this.sumMaxGradesInTestWithoutIgnored / this.sumMaxGradeInTest * this.maxGrade;
        }
        return this.sumMaxGradesInTestWithoutIgnored;
    }

    public int hashCode() {
        return this.displayName.hashCode();
    }
}

