/*
 * Decompiled with CFR 0.152.
 */
package io.github.ulfs.assertj.jsoup;

import io.github.ulfs.assertj.jsoup.DocumentAssert;
import io.github.ulfs.assertj.jsoup.DocumentAssertionsSpec;
import io.github.ulfs.assertj.jsoup.DocumentSoftAssertions;
import io.github.ulfs.assertj.jsoup.JsoupUtils;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.SoftAssertionsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Document;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007J3\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\b\u0010H\u0007J\u0012\u0010\b\u001a\u00020\u000f2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010\u0011\u001a\u00020\u000f2\b\u0010\t\u001a\u0004\u0018\u00010\u0012H\u0007J5\u0010\u0011\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u000b\u001a\u00020\f2\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\b\u0010H\u0007J3\u0010\u0013\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u000b\u001a\u00020\f2\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u000e\u00a2\u0006\u0002\b\u0010J1\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u000e\u00a2\u0006\u0002\b\u0010J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0012H\u0007\u00a8\u0006\u0019"}, d2={"Lio/github/ulfs/assertj/jsoup/Assertions;", "", "()V", "assertSoftly", "", "assertions", "Ljava/util/function/Consumer;", "Lio/github/ulfs/assertj/jsoup/DocumentSoftAssertions;", "assertThat", "actual", "Lorg/jsoup/nodes/Document;", "softly", "", "assert", "Lkotlin/Function1;", "Lio/github/ulfs/assertj/jsoup/DocumentAssert;", "Lkotlin/ExtensionFunctionType;", "assertThatDocument", "", "assertThatDocumentSpec", "Lio/github/ulfs/assertj/jsoup/DocumentAssertionsSpec;", "assertThatSpec", "document", "qa", "value", "assertj-jsoup"})
public final class Assertions {
    @NotNull
    public static final Assertions INSTANCE = new Assertions();

    private Assertions() {
    }

    @JvmStatic
    @NotNull
    public static final DocumentAssert assertThat(@Nullable Document actual) {
        return new DocumentAssert(actual);
    }

    @JvmStatic
    @NotNull
    public static final DocumentAssert assertThatDocument(@Nullable String actual) {
        ((AbstractStringAssert)org.assertj.core.api.Assertions.assertThat((String)actual).withFailMessage("%nExpecting document but found null", new Object[0])).isNotNull();
        String string = actual;
        Intrinsics.checkNotNull((Object)string);
        return new DocumentAssert(JsoupUtils.INSTANCE.parse$assertj_jsoup(string));
    }

    @JvmStatic
    public static final void assertSoftly(@NotNull Consumer<DocumentSoftAssertions> assertions) {
        Intrinsics.checkNotNullParameter(assertions, (String)"assertions");
        SoftAssertionsProvider.assertSoftly(DocumentSoftAssertions.class, assertions);
    }

    @JvmStatic
    @JvmOverloads
    public static final void assertThatDocument(@Nullable String actual, boolean softly, @NotNull Function1<? super DocumentAssert, ? extends DocumentAssert> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"assert");
        DocumentSoftAssertions softAssertions = new DocumentSoftAssertions(softly);
        DocumentAssert assertions = softAssertions.assertThatDocument(actual);
        function1.invoke((Object)assertions);
        softAssertions.assertAll();
    }

    public static /* synthetic */ void assertThatDocument$default(String string, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        Assertions.assertThatDocument(string, bl, (Function1<? super DocumentAssert, ? extends DocumentAssert>)function1);
    }

    @JvmStatic
    @JvmOverloads
    public static final void assertThat(@NotNull Document actual, boolean softly, @NotNull Function1<? super DocumentAssert, ? extends DocumentAssert> function1) {
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter(function1, (String)"assert");
        DocumentSoftAssertions softAssertions = new DocumentSoftAssertions(softly);
        DocumentAssert assertions = softAssertions.assertThat(actual);
        function1.invoke((Object)assertions);
        softAssertions.assertAll();
    }

    public static /* synthetic */ void assertThat$default(Document document, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        Assertions.assertThat(document, bl, (Function1<? super DocumentAssert, ? extends DocumentAssert>)function1);
    }

    public final /* synthetic */ void assertThatDocumentSpec(String actual, boolean softly, Function1 function1) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)function1, (String)"assert");
            ((AbstractStringAssert)org.assertj.core.api.Assertions.assertThat((String)actual).withFailMessage("%nExpecting document but found null", new Object[0])).isNotNull();
            String string = actual;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            Document document = JsoupUtils.INSTANCE.parse$assertj_jsoup(it);
            INSTANCE.assertThatSpec(document, softly, function1);
        }
    }

    public static /* synthetic */ void assertThatDocumentSpec$default(Assertions assertions, String string, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        assertions.assertThatDocumentSpec(string, bl, function1);
    }

    public final /* synthetic */ void assertThatSpec(Document document, boolean softly, Function1 function1) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)function1, (String)"assert");
        DocumentSoftAssertions softAssertions = new DocumentSoftAssertions(softly);
        DocumentAssertionsSpec spec = new DocumentAssertionsSpec(softAssertions, document);
        function1.invoke((Object)spec);
        softAssertions.assertAll();
    }

    public static /* synthetic */ void assertThatSpec$default(Assertions assertions, Document document, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        assertions.assertThatSpec(document, bl, function1);
    }

    @JvmStatic
    @NotNull
    public static final String qa(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return "*[data-qa=" + value + ']';
    }

    @JvmStatic
    @JvmOverloads
    public static final void assertThatDocument(@Nullable String actual, @NotNull Function1<? super DocumentAssert, ? extends DocumentAssert> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"assert");
        Assertions.assertThatDocument$default(actual, false, function1, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void assertThat(@NotNull Document actual, @NotNull Function1<? super DocumentAssert, ? extends DocumentAssert> function1) {
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter(function1, (String)"assert");
        Assertions.assertThat$default(actual, false, function1, 2, null);
    }
}

