/*
 * Decompiled with CFR 0.152.
 */
package io.github.ulfs.assertj.jsoup;

import io.github.ulfs.test.coverage.Generated;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.assertj.core.api.AbstractAssert;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u0000 32\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001:\u00013B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u0016\u0010\n\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J/\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\r\"\u00020\u0007\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007J\u001e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007J\u0016\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0016\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u0016\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007J'\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\r\"\u00020\u0007\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007J'\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\r\"\u00020\u0007\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007J\u0016\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007J\u0016\u0010 \u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\"\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007J!\u0010#\u001a\u00020$2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010%\u001a\u00020&H\u0083\bJ!\u0010#\u001a\u00020$2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010'\u001a\u00020(H\u0083\bJ1\u0010)\u001a\u00020$2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010+\u001a\u00020&2\u0006\u0010%\u001a\u00020(H\u0083\bJ1\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010%\u001a\u00020(H\u0083\bJ\u0011\u0010/\u001a\u00020$2\u0006\u0010\u0006\u001a\u00020\u0007H\u0083\bJ'\u00100\u001a\u00020$2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u0007022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010%\u001a\u00020(H\u0083\b\u00a8\u00064"}, d2={"Lio/github/ulfs/assertj/jsoup/DocumentAssert;", "Lorg/assertj/core/api/AbstractAssert;", "Lorg/jsoup/nodes/Document;", "actual", "(Lorg/jsoup/nodes/Document;)V", "elementAttributeContainsText", "cssSelector", "", "attribute", "substring", "elementAttributeExists", "elementAttributeHasText", "attrValues", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lio/github/ulfs/assertj/jsoup/DocumentAssert;", "text", "elementAttributeMatchesText", "regex", "elementAttributeNotExists", "elementContainsHtml", "elementContainsText", "elementExists", "count", "", "elementHasClass", "className", "elementHasHtml", "strings", "(Ljava/lang/String;[Ljava/lang/String;)Lio/github/ulfs/assertj/jsoup/DocumentAssert;", "string", "elementHasText", "elementMatchesHtml", "elementMatchesText", "elementNotExists", "elementNotHasClass", "failWithAttributeNotFound", "", "selection", "Lorg/jsoup/nodes/Element;", "selections", "Lorg/jsoup/select/Elements;", "failWithAttributeNotFoundAtPosition", "index", "element", "failWithAttributeValueAtPositionNotFound", "attrValue", "expectedAttrValue", "failWithElementNotFound", "failWithRemainingElementsNotFound", "rest", "", "Companion", "assertj-jsoup"})
public class DocumentAssert
extends AbstractAssert<DocumentAssert, Document> {
    @NotNull
    private static final Companion Companion = new Companion(null);

    public DocumentAssert(@Nullable Document actual) {
        super((Object)actual, DocumentAssert.class);
    }

    @NotNull
    public final DocumentAssert elementExists(@NotNull String cssSelector) {
        DocumentAssert documentAssert;
        Intrinsics.checkNotNullParameter((Object)cssSelector, (String)"cssSelector");
        DocumentAssert $this$elementExists_u24lambda_u2d0 = documentAssert = this;
        boolean bl = false;
        $this$elementExists_u24lambda_u2d0.isNotNull();
        Element selection = ((Document)$this$elementExists_u24lambda_u2d0.actual).selectFirst(cssSelector);
        if (selection == null) {
            DocumentAssert this_$iv = $this$elementExists_u24lambda_u2d0;
            boolean $i$f$failWithElementNotFound = false;
            Object[] objectArray = new Object[]{cssSelector};
            this_$iv.failWithMessage("%nExpecting element for%n  <%s>%nbut found nothing", objectArray);
        }
        return documentAssert;
    }

    @NotNull
    public final DocumentAssert elementExists(@NotNull String cssSelector, int count) {
        DocumentAssert documentAssert;
        Intrinsics.checkNotNullParameter((Object)cssSelector, (String)"cssSelector");
        DocumentAssert $this$elementExists_u24lambda_u2d1 = documentAssert = this;
        boolean bl = false;
        $this$elementExists_u24lambda_u2d1.isNotNull();
        Elements elements = ((Document)$this$elementExists_u24lambda_u2d1.actual).select(cssSelector);
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"actual.select(cssSelector)");
        Elements selection = elements;
        if (selection.size() != count) {
            Object[] objectArray = new Object[]{cssSelector, count, selection.size(), DocumentAssert.Companion.maskSelection(selection)};
            $this$elementExists_u24lambda_u2d1.failWithMessage("%nExpecting elements for%n  <%s>%nto have size of%n  <%s>%nbut had%n  <%s>%nwith elements:%n%s", objectArray);
        }
        return documentAssert;
    }

    @NotNull
    public final DocumentAssert elementNotExists(@NotNull String cssSelector) {
        DocumentAssert documentAssert;
        Intrinsics.checkNotNullParameter((Object)cssSelector, (String)"cssSelector");
        DocumentAssert it = documentAssert = this;
        boolean bl = false;
        this.isNotNull();
        Element selection = ((Document)this.actual).selectFirst(cssSelector);
        if (selection != null) {
            Object[] objectArray = new Object[]{cssSelector, DocumentAssert.Companion.maskSelection(selection)};
            this.failWithActualExpectedAndMessage(selection, null, "%nExpecting element for%n  <%s>%nto be absent, but was%n%s", objectArray);
        }
        return documentAssert;
    }

    @NotNull
    public final DocumentAssert elementAttributeExists(@NotNull String cssSelector, @NotNull String attribute2) {
        DocumentAssert documentAssert;
        Intrinsics.checkNotNullParameter((Object)cssSelector, (String)"cssSelector");
        Intrinsics.checkNotNullParameter((Object)attribute2, (String)"attribute");
        DocumentAssert $this$elementAttributeExists_u24lambda_u2d3 = documentAssert = this;
        boolean bl = false;
        $this$elementAttributeExists_u24lambda_u2d3.isNotNull();
        Elements elements = ((Document)$this$elementAttributeExists_u24lambda_u2d3.actual).select(cssSelector);
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"actual.select(cssSelector)");
        Elements selection = elements;
        if (selection.isEmpty()) {
            DocumentAssert this_$iv = $this$elementAttributeExists_u24lambda_u2d3;
            boolean $i$f$failWithElementNotFound = false;
            Object[] objectArray = new Object[]{cssSelector};
            this_$iv.failWithMessage("%nExpecting element for%n  <%s>%nbut found nothing", objectArray);
            return $this$elementAttributeExists_u24lambda_u2d3;
        }
        if (!selection.hasAttr(attribute2)) {
            DocumentAssert this_$iv = $this$elementAttributeExists_u24lambda_u2d3;
            boolean $i$f$failWithAttributeNotFound = false;
            Object[] objectArray = new Object[]{attribute2, cssSelector, DocumentAssert.Companion.maskSelection(selection)};
            this_$iv.failWithMessage("%nExpecting attribute%n  <%s>%non elements for%n  <%s>%nbut found%n%s", objectArray);
        }
        return documentAssert;
    }

    @NotNull
    public final DocumentAssert elementAttributeNotExists(@NotNull String cssSelector, @NotNull String attribute2) {
        DocumentAssert documentAssert;
        Intrinsics.checkNotNullParameter((Object)cssSelector, (String)"cssSelector");
        Intrinsics.checkNotNullParameter((Object)attribute2, (String)"attribute");
        DocumentAssert $this$elementAttributeNotExists_u24lambda_u2d4 = documentAssert = this;
        boolean bl = false;
        $this$elementAttributeNotExists_u24lambda_u2d4.isNotNull();
        $this$elementAttributeNotExists_u24lambda_u2d4.elementExists(cssSelector);
        Elements elements = ((Document)$this$elementAttributeNotExists_u24lambda_u2d4.actual).select(cssSelector);
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"actual.select(cssSelector)");
        Elements selection = elements;
        if (selection.hasAttr(attribute2)) {
            Object[] objectArray = new Object[]{attribute2, cssSelector, selection};
            $this$elementAttributeNotExists_u24lambda_u2d4.failWithActualExpectedAndMessage(selection, null, "%nExpecting attribute%n  <%s>%non element for%n  <%s>%nto be absent, but was%n  <%s>", objectArray);
        }
        return documentAssert;
    }

    @NotNull
    public final DocumentAssert elementHasHtml(@NotNull String cssSelector, @NotNull String string) {
        DocumentAssert documentAssert;
        Intrinsics.checkNotNullParameter((Object)cssSelector, (String)"cssSelector");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        DocumentAssert $this$elementHasHtml_u24lambda_u2d5 = documentAssert = this;
        boolean bl = false;
        $this$elementHasHtml_u24lambda_u2d5.isNotNull();
        Element selection = ((Document)$this$elementHasHtml_u24lambda_u2d5.actual).selectFirst(cssSelector);
        if (selection == null) {
            DocumentAssert this_$iv = $this$elementHasHtml_u24lambda_u2d5;
            boolean $i$f$failWithElementNotFound = false;
            Object[] objectArray = new Object[]{cssSelector};
            this_$iv.failWithMessage("%nExpecting element for%n  <%s>%nbut found nothing", objectArray);
            return $this$elementHasHtml_u24lambda_u2d5;
        }
        String string2 = selection.html();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"selection.html()");
        String html = string2;
        if (!Intrinsics.areEqual((Object)html, (Object)string)) {
            Object[] objectArray = new Object[]{cssSelector, string, html};
            $this$elementHasHtml_u24lambda_u2d5.failWithActualExpectedAndMessage(html, string, "%nExpecting element for%n  <%s>%nto have html%n  <%s>%nbut was%n  <%s>", objectArray);
        }
        return documentAssert;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DocumentAssert elementHasHtml(@NotNull String cssSelector, String ... strings) {
        Iterable iterable;
        DocumentAssert documentAssert;
        Intrinsics.checkNotNullParameter((Object)cssSelector, (String)"cssSelector");
        Intrinsics.checkNotNullParameter((Object)strings, (String)"strings");
        DocumentAssert $this$elementHasHtml_u24lambda_u2d7 = documentAssert = this;
        boolean bl = false;
        $this$elementHasHtml_u24lambda_u2d7.isNotNull();
        if (strings.length == 0) {
            throw new IllegalArgumentException("elementHasHtml expects at least two arguments");
        }
        Elements elements = ((Document)$this$elementHasHtml_u24lambda_u2d7.actual).select(cssSelector);
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"actual.select(cssSelector)");
        Elements selection = elements;
        if (selection.isEmpty()) {
            DocumentAssert this_$iv = $this$elementHasHtml_u24lambda_u2d7;
            boolean $i$f$failWithElementNotFound = false;
            Object[] objectArray = new Object[]{cssSelector};
            this_$iv.failWithMessage("%nExpecting element for%n  <%s>%nbut found nothing", objectArray);
            return $this$elementHasHtml_u24lambda_u2d7;
        }
        Iterable $this$onEachIndexed$iv = ArraysKt.zip((Object[])strings, (Iterable)((Iterable)selection));
        boolean $i$f$onEachIndexed = false;
        Iterable $this$onEachIndexed_u24lambda_u2d17$iv = iterable = $this$onEachIndexed$iv;
        boolean bl2 = false;
        Iterable $this$forEachIndexed$iv$iv = $this$onEachIndexed_u24lambda_u2d17$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
            String elementHtml;
            void matchPair;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair pair = (Pair)item$iv$iv;
            int index = n;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((Element)matchPair.getSecond()).html(), (String)"matchPair.second.html()");
            String expectedHtml = (String)matchPair.getFirst();
            if (Intrinsics.areEqual((Object)elementHtml, (Object)expectedHtml)) continue;
            Object[] objectArray = new Object[]{index, cssSelector, expectedHtml, elementHtml};
            $this$elementHasHtml_u24lambda_u2d7.failWithActualExpectedAndMessage(elementHtml, expectedHtml, "%nExpecting element at position %s in list for%n  <%s>%nto have html%n  <%s>%nbut was%n  <%s>", objectArray);
            return $this$elementHasHtml_u24lambda_u2d7;
        }
        if (selection.size() < strings.length) {
            List rest = ArraysKt.drop((Object[])strings, (int)selection.size());
            Object[] objectArray = new Object[]{rest.size(), cssSelector, DocumentAssert.Companion.maskSelection(rest), DocumentAssert.Companion.maskSelection(selection)};
            $this$elementHasHtml_u24lambda_u2d7.failWithMessage("%nExpecting %s more element(s) for%n  %s%nto be html%n%s%nin list%n%s", objectArray);
        }
        return documentAssert;
    }

    @NotNull
    public final DocumentAssert elementContainsHtml(@NotNull String cssSelector, @NotNull String substring) {
        DocumentAssert documentAssert;
        Intrinsics.checkNotNullParameter((Object)cssSelector, (String)"cssSelector");
        Intrinsics.checkNotNullParameter((Object)substring, (String)"substring");
        DocumentAssert $this$elementContainsHtml_u24lambda_u2d8 = documentAssert = this;
        boolean bl = false;
        $this$elementContainsHtml_u24lambda_u2d8.isNotNull();
        Element selection = ((Document)$this$elementContainsHtml_u24lambda_u2d8.actual).selectFirst(cssSelector);
        if (selection == null) {
            DocumentAssert this_$iv = $this$elementContainsHtml_u24lambda_u2d8;
            boolean $i$f$failWithElementNotFound = false;
            Object[] objectArray = new Object[]{cssSelector};
            this_$iv.failWithMessage("%nExpecting element for%n  <%s>%nbut found nothing", objectArray);
            return $this$elementContainsHtml_u24lambda_u2d8;
        }
        String string = selection.html();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"selection.html()");
        String html = string;
        if (!StringsKt.contains$default((CharSequence)html, (CharSequence)substring, (boolean)false, (int)2, null)) {
            Object[] objectArray = new Object[]{cssSelector, substring, html};
            $this$elementContainsHtml_u24lambda_u2d8.failWithActualExpectedAndMessage(html, substring, "%nExpecting element for%n  <%s>%nto contain html%n  <%s>%nbut was%n  <%s>", objectArray);
        }
        return documentAssert;
    }

    @NotNull
    public final DocumentAssert elementMatchesHtml(@NotNull String cssSelector, @NotNull String regex) {
        DocumentAssert documentAssert;
        Intrinsics.checkNotNullParameter((Object)cssSelector, (String)"cssSelector");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        DocumentAssert $this$elementMatchesHtml_u24lambda_u2d9 = documentAssert = this;
        boolean bl = false;
        $this$elementMatchesHtml_u24lambda_u2d9.isNotNull();
        Element selection = ((Document)$this$elementMatchesHtml_u24lambda_u2d9.actual).selectFirst(cssSelector);
        if (selection == null) {
            DocumentAssert this_$iv = $this$elementMatchesHtml_u24lambda_u2d9;
            boolean $i$f$failWithElementNotFound = false;
            Object[] objectArray = new Object[]{cssSelector};
            this_$iv.failWithMessage("%nExpecting element for%n  <%s>%nbut found nothing", objectArray);
            return $this$elementMatchesHtml_u24lambda_u2d9;
        }
        String string = selection.html();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"selection.html()");
        String html = string;
        Object[] objectArray = (Object[])html;
        if (!new Regex(regex).containsMatchIn((CharSequence)objectArray)) {
            objectArray = new Object[]{cssSelector, regex, html};
            $this$elementMatchesHtml_u24lambda_u2d9.failWithActualExpectedAndMessage(html, regex, "%nExpecting element for%n  <%s>%nto match regex for html%n  <%s>%nbut was%n  <%s>", objectArray);
        }
        return documentAssert;
    }

    @NotNull
    public final DocumentAssert elementHasText(@NotNull String cssSelector, @NotNull String string) {
        DocumentAssert documentAssert;
        Intrinsics.checkNotNullParameter((Object)cssSelector, (String)"cssSelector");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        DocumentAssert $this$elementHasText_u24lambda_u2d10 = documentAssert = this;
        boolean bl = false;
        $this$elementHasText_u24lambda_u2d10.isNotNull();
        Element selection = ((Document)$this$elementHasText_u24lambda_u2d10.actual).selectFirst(cssSelector);
        if (selection == null) {
            DocumentAssert this_$iv = $this$elementHasText_u24lambda_u2d10;
            boolean $i$f$failWithElementNotFound = false;
            Object[] objectArray = new Object[]{cssSelector};
            this_$iv.failWithMessage("%nExpecting element for%n  <%s>%nbut found nothing", objectArray);
            return $this$elementHasText_u24lambda_u2d10;
        }
        String string2 = selection.text();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"selection.text()");
        String text = string2;
        if (!Intrinsics.areEqual((Object)text, (Object)string)) {
            Object[] objectArray = new Object[]{cssSelector, string, text};
            $this$elementHasText_u24lambda_u2d10.failWithActualExpectedAndMessage(text, string, "%nExpecting element for%n  <%s>%nto have text%n  <%s>%nbut was%n  <%s>", objectArray);
        }
        return documentAssert;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DocumentAssert elementHasText(@NotNull String cssSelector, String ... strings) {
        Iterable iterable;
        DocumentAssert documentAssert;
        Intrinsics.checkNotNullParameter((Object)cssSelector, (String)"cssSelector");
        Intrinsics.checkNotNullParameter((Object)strings, (String)"strings");
        DocumentAssert $this$elementHasText_u24lambda_u2d12 = documentAssert = this;
        boolean bl = false;
        $this$elementHasText_u24lambda_u2d12.isNotNull();
        if (strings.length == 0) {
            throw new IllegalArgumentException("elementHasText expects at least two arguments");
        }
        Elements elements = ((Document)$this$elementHasText_u24lambda_u2d12.actual).select(cssSelector);
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"actual.select(cssSelector)");
        Elements selection = elements;
        if (selection.isEmpty()) {
            DocumentAssert this_$iv = $this$elementHasText_u24lambda_u2d12;
            boolean $i$f$failWithElementNotFound = false;
            Object[] objectArray = new Object[]{cssSelector};
            this_$iv.failWithMessage("%nExpecting element for%n  <%s>%nbut found nothing", objectArray);
            return $this$elementHasText_u24lambda_u2d12;
        }
        Iterable $this$onEachIndexed$iv = ArraysKt.zip((Object[])strings, (Iterable)((Iterable)selection));
        boolean $i$f$onEachIndexed = false;
        Iterable $this$onEachIndexed_u24lambda_u2d17$iv = iterable = $this$onEachIndexed$iv;
        boolean bl2 = false;
        Iterable $this$forEachIndexed$iv$iv = $this$onEachIndexed_u24lambda_u2d17$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
            String elementText;
            void matchPair;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair pair = (Pair)item$iv$iv;
            int index = n;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((Element)matchPair.getSecond()).text(), (String)"matchPair.second.text()");
            String expectedText = (String)matchPair.getFirst();
            if (Intrinsics.areEqual((Object)elementText, (Object)expectedText)) continue;
            Object[] objectArray = new Object[]{index, cssSelector, expectedText, elementText};
            $this$elementHasText_u24lambda_u2d12.failWithActualExpectedAndMessage(elementText, expectedText, "%nExpecting element at position %s in list for%n  <%s>%nto have text%n  <%s>%nbut was%n  <%s>", objectArray);
            return $this$elementHasText_u24lambda_u2d12;
        }
        if (selection.size() < strings.length) {
            List rest = ArraysKt.drop((Object[])strings, (int)selection.size());
            Object[] objectArray = new Object[]{rest.size(), cssSelector, DocumentAssert.Companion.maskSelection(rest), DocumentAssert.Companion.maskSelection(selection)};
            $this$elementHasText_u24lambda_u2d12.failWithMessage("%nExpecting %s more element(s) for%n  %s%nto be%n%s%nin list%n%s", objectArray);
        }
        return documentAssert;
    }

    @NotNull
    public final DocumentAssert elementContainsText(@NotNull String cssSelector, @NotNull String substring) {
        DocumentAssert documentAssert;
        Intrinsics.checkNotNullParameter((Object)cssSelector, (String)"cssSelector");
        Intrinsics.checkNotNullParameter((Object)substring, (String)"substring");
        DocumentAssert $this$elementContainsText_u24lambda_u2d13 = documentAssert = this;
        boolean bl = false;
        $this$elementContainsText_u24lambda_u2d13.isNotNull();
        Element selection = ((Document)$this$elementContainsText_u24lambda_u2d13.actual).selectFirst(cssSelector);
        if (selection == null) {
            DocumentAssert this_$iv = $this$elementContainsText_u24lambda_u2d13;
            boolean $i$f$failWithElementNotFound = false;
            Object[] objectArray = new Object[]{cssSelector};
            this_$iv.failWithMessage("%nExpecting element for%n  <%s>%nbut found nothing", objectArray);
            return $this$elementContainsText_u24lambda_u2d13;
        }
        String string = selection.text();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"selection.text()");
        String text = string;
        if (!StringsKt.contains$default((CharSequence)text, (CharSequence)substring, (boolean)false, (int)2, null)) {
            Object[] objectArray = new Object[]{cssSelector, substring, text};
            $this$elementContainsText_u24lambda_u2d13.failWithActualExpectedAndMessage(text, substring, "%nExpecting element for%n  <%s>%nto contain text%n  <%s>%nbut was%n  <%s>", objectArray);
        }
        return documentAssert;
    }

    @NotNull
    public final DocumentAssert elementMatchesText(@NotNull String cssSelector, @NotNull String regex) {
        DocumentAssert documentAssert;
        Intrinsics.checkNotNullParameter((Object)cssSelector, (String)"cssSelector");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        DocumentAssert $this$elementMatchesText_u24lambda_u2d14 = documentAssert = this;
        boolean bl = false;
        $this$elementMatchesText_u24lambda_u2d14.isNotNull();
        Element selection = ((Document)$this$elementMatchesText_u24lambda_u2d14.actual).selectFirst(cssSelector);
        if (selection == null) {
            DocumentAssert this_$iv = $this$elementMatchesText_u24lambda_u2d14;
            boolean $i$f$failWithElementNotFound = false;
            Object[] objectArray = new Object[]{cssSelector};
            this_$iv.failWithMessage("%nExpecting element for%n  <%s>%nbut found nothing", objectArray);
            return $this$elementMatchesText_u24lambda_u2d14;
        }
        String string = selection.text();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"selection.text()");
        String text = string;
        Object[] objectArray = (Object[])text;
        if (!new Regex(regex).containsMatchIn((CharSequence)objectArray)) {
            objectArray = new Object[]{cssSelector, regex, text};
            $this$elementMatchesText_u24lambda_u2d14.failWithActualExpectedAndMessage(text, regex, "%nExpecting element for%n  <%s>%nto match regex%n  <%s>%nbut was%n  <%s>", objectArray);
        }
        return documentAssert;
    }

    @NotNull
    public final DocumentAssert elementAttributeHasText(@NotNull String cssSelector, @NotNull String attribute2, @NotNull String text) {
        DocumentAssert documentAssert;
        Intrinsics.checkNotNullParameter((Object)cssSelector, (String)"cssSelector");
        Intrinsics.checkNotNullParameter((Object)attribute2, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        DocumentAssert $this$elementAttributeHasText_u24lambda_u2d15 = documentAssert = this;
        boolean bl = false;
        $this$elementAttributeHasText_u24lambda_u2d15.isNotNull();
        Elements elements = ((Document)$this$elementAttributeHasText_u24lambda_u2d15.actual).select(cssSelector);
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"actual.select(cssSelector)");
        Elements selection = elements;
        if (selection.isEmpty()) {
            DocumentAssert this_$iv = $this$elementAttributeHasText_u24lambda_u2d15;
            boolean $i$f$failWithElementNotFound = false;
            Object[] objectArray = new Object[]{cssSelector};
            this_$iv.failWithMessage("%nExpecting element for%n  <%s>%nbut found nothing", objectArray);
            return $this$elementAttributeHasText_u24lambda_u2d15;
        }
        if (!selection.hasAttr(attribute2)) {
            DocumentAssert this_$iv = $this$elementAttributeHasText_u24lambda_u2d15;
            boolean $i$f$failWithAttributeNotFound = false;
            Object[] objectArray = new Object[]{attribute2, cssSelector, DocumentAssert.Companion.maskSelection(selection)};
            this_$iv.failWithMessage("%nExpecting attribute%n  <%s>%non elements for%n  <%s>%nbut found%n%s", objectArray);
            return $this$elementAttributeHasText_u24lambda_u2d15;
        }
        String string = selection.attr(attribute2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"selection.attr(attribute)");
        String attrValue = string;
        if (!Intrinsics.areEqual((Object)attrValue, (Object)text)) {
            Object[] objectArray = new Object[]{attribute2, cssSelector, text, attrValue};
            $this$elementAttributeHasText_u24lambda_u2d15.failWithActualExpectedAndMessage(attrValue, text, "%nExpecting attribute%n  <%s>%non element for%n  <%s>%nto be%n  <%s>%nbut was%n  <%s>", objectArray);
        }
        return documentAssert;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DocumentAssert elementAttributeHasText(@NotNull String cssSelector, @NotNull String attribute2, String ... attrValues) {
        Iterable iterable;
        DocumentAssert documentAssert;
        Intrinsics.checkNotNullParameter((Object)cssSelector, (String)"cssSelector");
        Intrinsics.checkNotNullParameter((Object)attribute2, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)attrValues, (String)"attrValues");
        DocumentAssert $this$elementAttributeHasText_u24lambda_u2d17 = documentAssert = this;
        boolean bl = false;
        $this$elementAttributeHasText_u24lambda_u2d17.isNotNull();
        if (attrValues.length == 0) {
            throw new IllegalArgumentException("elementAttributeHasText expects at least two arguments");
        }
        Elements elements = ((Document)$this$elementAttributeHasText_u24lambda_u2d17.actual).select(cssSelector);
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"actual.select(cssSelector)");
        Elements selection = elements;
        if (selection.isEmpty()) {
            DocumentAssert this_$iv = $this$elementAttributeHasText_u24lambda_u2d17;
            boolean $i$f$failWithElementNotFound = false;
            Object[] objectArray = new Object[]{cssSelector};
            this_$iv.failWithMessage("%nExpecting element for%n  <%s>%nbut found nothing", objectArray);
            return $this$elementAttributeHasText_u24lambda_u2d17;
        }
        Iterable $this$onEachIndexed$iv = ArraysKt.zip((Object[])attrValues, (Iterable)((Iterable)selection));
        boolean $i$f$onEachIndexed = false;
        Iterable $this$onEachIndexed_u24lambda_u2d17$iv = iterable = $this$onEachIndexed$iv;
        boolean bl2 = false;
        Iterable $this$forEachIndexed$iv$iv = $this$onEachIndexed_u24lambda_u2d17$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
            String attrValue;
            void matchPair;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair pair = (Pair)item$iv$iv;
            int index = n;
            boolean bl3 = false;
            Element element = (Element)matchPair.getSecond();
            if (!element.hasAttr(attribute2)) {
                void this_$iv;
                DocumentAssert documentAssert2 = $this$elementAttributeHasText_u24lambda_u2d17;
                Intrinsics.checkNotNullExpressionValue((Object)element, (String)"element");
                Element element$iv = element;
                boolean $i$f$failWithAttributeNotFoundAtPosition = false;
                Object[] objectArray = new Object[]{index, cssSelector, attribute2, element$iv, DocumentAssert.Companion.maskSelection(selection)};
                this_$iv.failWithActualExpectedAndMessage(null, (Object)attribute2, "%nExpecting element at position %s in list for%n  <%s>%nto have attribute%n  <%s>%nbut was%n  <%s>%nin list%n%s", objectArray);
                return $this$elementAttributeHasText_u24lambda_u2d17;
            }
            Intrinsics.checkNotNullExpressionValue((Object)element.attr(attribute2), (String)"element.attr(attribute)");
            String expectedAttrValue = (String)matchPair.getFirst();
            if (Intrinsics.areEqual((Object)attrValue, (Object)expectedAttrValue)) continue;
            DocumentAssert this_$iv = $this$elementAttributeHasText_u24lambda_u2d17;
            boolean $i$f$failWithAttributeValueAtPositionNotFound = false;
            Object[] objectArray = new Object[]{index, cssSelector, expectedAttrValue, attrValue, DocumentAssert.Companion.maskSelection(selection)};
            this_$iv.failWithActualExpectedAndMessage(attrValue, expectedAttrValue, "%nExpecting element at position %s in list for%n  <%s>%nto have attribute value%n  <%s>%nbut was%n  <%s>%nin list%n%s", objectArray);
            return $this$elementAttributeHasText_u24lambda_u2d17;
        }
        if (selection.size() < attrValues.length) {
            List rest = ArraysKt.drop((Object[])attrValues, (int)selection.size());
            DocumentAssert this_$iv = $this$elementAttributeHasText_u24lambda_u2d17;
            boolean $i$f$failWithRemainingElementsNotFound = false;
            Object[] objectArray = new Object[]{rest.size(), cssSelector, rest, DocumentAssert.Companion.maskSelection(selection)};
            this_$iv.failWithMessage("%nExpecting %s remaining elements:%n  <%s>%nin list for%n  <%s>%nbut was%n  <%s>", objectArray);
        }
        return documentAssert;
    }

    @NotNull
    public final DocumentAssert elementAttributeContainsText(@NotNull String cssSelector, @NotNull String attribute2, @NotNull String substring) {
        DocumentAssert documentAssert;
        Intrinsics.checkNotNullParameter((Object)cssSelector, (String)"cssSelector");
        Intrinsics.checkNotNullParameter((Object)attribute2, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)substring, (String)"substring");
        DocumentAssert $this$elementAttributeContainsText_u24lambda_u2d18 = documentAssert = this;
        boolean bl = false;
        $this$elementAttributeContainsText_u24lambda_u2d18.isNotNull();
        Elements elements = ((Document)$this$elementAttributeContainsText_u24lambda_u2d18.actual).select(cssSelector);
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"actual.select(cssSelector)");
        Elements selection = elements;
        if (selection.isEmpty()) {
            DocumentAssert this_$iv = $this$elementAttributeContainsText_u24lambda_u2d18;
            boolean $i$f$failWithElementNotFound = false;
            Object[] objectArray = new Object[]{cssSelector};
            this_$iv.failWithMessage("%nExpecting element for%n  <%s>%nbut found nothing", objectArray);
            return $this$elementAttributeContainsText_u24lambda_u2d18;
        }
        if (!selection.hasAttr(attribute2)) {
            DocumentAssert this_$iv = $this$elementAttributeContainsText_u24lambda_u2d18;
            boolean $i$f$failWithAttributeNotFound = false;
            Object[] objectArray = new Object[]{attribute2, cssSelector, DocumentAssert.Companion.maskSelection(selection)};
            this_$iv.failWithMessage("%nExpecting attribute%n  <%s>%non elements for%n  <%s>%nbut found%n%s", objectArray);
            return $this$elementAttributeContainsText_u24lambda_u2d18;
        }
        String string = selection.attr(attribute2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"selection.attr(attribute)");
        String attrValue = string;
        if (!StringsKt.contains$default((CharSequence)attrValue, (CharSequence)substring, (boolean)false, (int)2, null)) {
            Object[] objectArray = new Object[]{attribute2, cssSelector, substring, attrValue};
            $this$elementAttributeContainsText_u24lambda_u2d18.failWithActualExpectedAndMessage(attrValue, substring, "%nExpecting attribute%n  <%s>%non element for%n  <%s>%nto contain%n  <%s>%nbut was%n  <%s>", objectArray);
        }
        return documentAssert;
    }

    @NotNull
    public final DocumentAssert elementAttributeMatchesText(@NotNull String cssSelector, @NotNull String attribute2, @NotNull String regex) {
        DocumentAssert documentAssert;
        Intrinsics.checkNotNullParameter((Object)cssSelector, (String)"cssSelector");
        Intrinsics.checkNotNullParameter((Object)attribute2, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        DocumentAssert $this$elementAttributeMatchesText_u24lambda_u2d19 = documentAssert = this;
        boolean bl = false;
        $this$elementAttributeMatchesText_u24lambda_u2d19.isNotNull();
        Elements elements = ((Document)$this$elementAttributeMatchesText_u24lambda_u2d19.actual).select(cssSelector);
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"actual.select(cssSelector)");
        Elements selection = elements;
        if (selection.isEmpty()) {
            DocumentAssert this_$iv = $this$elementAttributeMatchesText_u24lambda_u2d19;
            boolean $i$f$failWithElementNotFound = false;
            Object[] objectArray = new Object[]{cssSelector};
            this_$iv.failWithMessage("%nExpecting element for%n  <%s>%nbut found nothing", objectArray);
            return $this$elementAttributeMatchesText_u24lambda_u2d19;
        }
        if (!selection.hasAttr(attribute2)) {
            DocumentAssert this_$iv = $this$elementAttributeMatchesText_u24lambda_u2d19;
            boolean $i$f$failWithAttributeNotFound = false;
            Object[] objectArray = new Object[]{attribute2, cssSelector, DocumentAssert.Companion.maskSelection(selection)};
            this_$iv.failWithMessage("%nExpecting attribute%n  <%s>%non elements for%n  <%s>%nbut found%n%s", objectArray);
            return $this$elementAttributeMatchesText_u24lambda_u2d19;
        }
        String string = selection.attr(attribute2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"selection.attr(attribute)");
        String attrValue = string;
        Object[] objectArray = (Object[])attrValue;
        if (!new Regex(regex).matches((CharSequence)objectArray)) {
            objectArray = new Object[]{attribute2, cssSelector, regex, attrValue};
            $this$elementAttributeMatchesText_u24lambda_u2d19.failWithActualExpectedAndMessage(attrValue, regex, "%nExpecting attribute%n  <%s>%non element for%n  <%s>%nto match regex%n  <%s>%nbut was%n  <%s>", objectArray);
        }
        return documentAssert;
    }

    @NotNull
    public final DocumentAssert elementHasClass(@NotNull String cssSelector, @NotNull String className) {
        DocumentAssert documentAssert;
        Intrinsics.checkNotNullParameter((Object)cssSelector, (String)"cssSelector");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        DocumentAssert $this$elementHasClass_u24lambda_u2d20 = documentAssert = this;
        boolean bl = false;
        $this$elementHasClass_u24lambda_u2d20.isNotNull();
        Element selection = ((Document)$this$elementHasClass_u24lambda_u2d20.actual).selectFirst(cssSelector);
        if (selection == null) {
            DocumentAssert this_$iv = $this$elementHasClass_u24lambda_u2d20;
            boolean $i$f$failWithElementNotFound = false;
            Object[] objectArray = new Object[]{cssSelector};
            this_$iv.failWithMessage("%nExpecting element for%n  <%s>%nbut found nothing", objectArray);
            return $this$elementHasClass_u24lambda_u2d20;
        }
        if (!selection.hasAttr("class")) {
            DocumentAssert this_$iv = $this$elementHasClass_u24lambda_u2d20;
            String attribute$iv = "class";
            boolean $i$f$failWithAttributeNotFound = false;
            Object[] objectArray = new Object[]{attribute$iv, cssSelector, selection};
            this_$iv.failWithMessage("%nExpecting attribute%n  <%s>%non element for%n  <%s>%nbut found%n  <%s>", objectArray);
            return $this$elementHasClass_u24lambda_u2d20;
        }
        if (!selection.hasClass(className)) {
            Object[] objectArray = new Object[]{cssSelector, className, DocumentAssert.Companion.maskSelection(selection)};
            $this$elementHasClass_u24lambda_u2d20.failWithMessage("%nExpecting element for%n  <%s>%nto include class%n  <%s>%nbut found%n%s", objectArray);
        }
        return documentAssert;
    }

    @NotNull
    public final DocumentAssert elementNotHasClass(@NotNull String cssSelector, @NotNull String className) {
        DocumentAssert documentAssert;
        Intrinsics.checkNotNullParameter((Object)cssSelector, (String)"cssSelector");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        DocumentAssert $this$elementNotHasClass_u24lambda_u2d21 = documentAssert = this;
        boolean bl = false;
        $this$elementNotHasClass_u24lambda_u2d21.isNotNull();
        Element selection = ((Document)$this$elementNotHasClass_u24lambda_u2d21.actual).selectFirst(cssSelector);
        if (selection == null) {
            DocumentAssert this_$iv = $this$elementNotHasClass_u24lambda_u2d21;
            boolean $i$f$failWithElementNotFound = false;
            Object[] objectArray = new Object[]{cssSelector};
            this_$iv.failWithMessage("%nExpecting element for%n  <%s>%nbut found nothing", objectArray);
            return $this$elementNotHasClass_u24lambda_u2d21;
        }
        if (!selection.hasAttr("class")) {
            return $this$elementNotHasClass_u24lambda_u2d21;
        }
        if (selection.hasClass(className)) {
            Object[] objectArray = new Object[]{cssSelector, className, selection};
            $this$elementNotHasClass_u24lambda_u2d21.failWithMessage("%nExpecting element for%n  <%s>%nto not include class%n  <%s>%nbut was%n  <%s>", objectArray);
        }
        return documentAssert;
    }

    @Generated
    private final void failWithElementNotFound(String cssSelector) {
        boolean $i$f$failWithElementNotFound = false;
        Object[] objectArray = new Object[]{cssSelector};
        this.failWithMessage("%nExpecting element for%n  <%s>%nbut found nothing", objectArray);
    }

    @Generated
    private final void failWithAttributeNotFound(String attribute2, String cssSelector, Elements selections) {
        boolean $i$f$failWithAttributeNotFound = false;
        Object[] objectArray = new Object[]{attribute2, cssSelector, DocumentAssert.Companion.maskSelection(selections)};
        this.failWithMessage("%nExpecting attribute%n  <%s>%non elements for%n  <%s>%nbut found%n%s", objectArray);
    }

    @Generated
    private final void failWithAttributeNotFound(String attribute2, String cssSelector, Element selection) {
        boolean $i$f$failWithAttributeNotFound = false;
        Object[] objectArray = new Object[]{attribute2, cssSelector, selection};
        this.failWithMessage("%nExpecting attribute%n  <%s>%non element for%n  <%s>%nbut found%n  <%s>", objectArray);
    }

    @Generated
    private final void failWithAttributeNotFoundAtPosition(String attribute2, int index, String cssSelector, Element element, Elements selection) {
        boolean $i$f$failWithAttributeNotFoundAtPosition = false;
        Object[] objectArray = new Object[]{index, cssSelector, attribute2, element, DocumentAssert.Companion.maskSelection(selection)};
        this.failWithActualExpectedAndMessage(null, attribute2, "%nExpecting element at position %s in list for%n  <%s>%nto have attribute%n  <%s>%nbut was%n  <%s>%nin list%n%s", objectArray);
    }

    @Generated
    private final void failWithAttributeValueAtPositionNotFound(String attrValue, String expectedAttrValue, int index, String cssSelector, Elements selection) {
        boolean $i$f$failWithAttributeValueAtPositionNotFound = false;
        Object[] objectArray = new Object[]{index, cssSelector, expectedAttrValue, attrValue, DocumentAssert.Companion.maskSelection(selection)};
        this.failWithActualExpectedAndMessage(attrValue, expectedAttrValue, "%nExpecting element at position %s in list for%n  <%s>%nto have attribute value%n  <%s>%nbut was%n  <%s>%nin list%n%s", objectArray);
    }

    @Generated
    private final void failWithRemainingElementsNotFound(List<String> rest, String cssSelector, Elements selection) {
        boolean $i$f$failWithRemainingElementsNotFound = false;
        Object[] objectArray = new Object[]{rest.size(), cssSelector, rest, DocumentAssert.Companion.maskSelection(selection)};
        this.failWithMessage("%nExpecting %s remaining elements:%n  <%s>%nin list for%n  <%s>%nbut was%n  <%s>", objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0007H\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lio/github/ulfs/assertj/jsoup/DocumentAssert$Companion;", "", "()V", "maskSelection", "", "selection", "", "Lorg/jsoup/nodes/Element;", "Lorg/jsoup/select/Elements;", "assertj-jsoup"})
    private static final class Companion {
        private Companion() {
        }

        private final String maskSelection(Elements selection) {
            String string = selection.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"selection.toString()");
            return StringsKt.prependIndent((String)string, (String)"  ");
        }

        private final String maskSelection(Element selection) {
            String string = selection.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"selection.toString()");
            return StringsKt.prependIndent((String)string, (String)"  ");
        }

        private final String maskSelection(List<String> selection) {
            return StringsKt.prependIndent((String)selection.toString(), (String)"  ");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

