/*
 * Decompiled with CFR 0.152.
 */
package io.github.ulfs.assertj.jsoup;

import io.github.ulfs.assertj.jsoup.AttributeAssertionsSpec;
import io.github.ulfs.assertj.jsoup.DocumentAssert;
import io.github.ulfs.assertj.jsoup.DocumentAssertionsMarker;
import io.github.ulfs.assertj.jsoup.DocumentSoftAssertions;
import io.github.ulfs.assertj.jsoup.NodeAssertionsSpec;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Document;

@DocumentAssertionsMarker
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\t\b\u0087\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0007J'\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u00072\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\b\u000eJ\t\u0010\u000f\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c2\u0003J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0007J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0007J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u0019\u001a\u00020\u0000J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0007J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0007J\u0010\u0010\u001f\u001a\u00020\u00002\b\u0010 \u001a\u0004\u0018\u00010\u0001J\u001f\u0010\u001f\u001a\u00020\u00002\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\"\"\u00020\u0007\u00a2\u0006\u0002\u0010#J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0007J\u0010\u0010%\u001a\u00020\u00002\b\u0010 \u001a\u0004\u0018\u00010\u0001J\u001f\u0010%\u001a\u00020\u00002\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\"\"\u00020\u0007\u00a2\u0006\u0002\u0010#J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0007J\t\u0010&\u001a\u00020\u001bH\u00d6\u0001J\u0006\u0010'\u001a\u00020\u0000J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0007J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0007J\t\u0010*\u001a\u00020\u0007H\u00d6\u0001R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lio/github/ulfs/assertj/jsoup/NodeAssertionsSpec;", "", "softAssertions", "Lio/github/ulfs/assertj/jsoup/DocumentSoftAssertions;", "document", "Lorg/jsoup/nodes/Document;", "cssSelector", "", "(Lio/github/ulfs/assertj/jsoup/DocumentSoftAssertions;Lorg/jsoup/nodes/Document;Ljava/lang/String;)V", "attribute", "attributeName", "assert", "Lkotlin/Function1;", "Lio/github/ulfs/assertj/jsoup/AttributeAssertionsSpec;", "Lkotlin/ExtensionFunctionType;", "component1", "component2", "component3", "containsHtml", "substring", "containsText", "copy", "equals", "", "other", "exists", "count", "", "hasAttribute", "name", "hasClass", "hasHtml", "obj", "texts", "", "([Ljava/lang/String;)Lio/github/ulfs/assertj/jsoup/NodeAssertionsSpec;", "text", "hasText", "hashCode", "notExists", "notHasAttribute", "notHasClass", "toString", "assertj-jsoup"})
public final class NodeAssertionsSpec {
    @NotNull
    private final DocumentSoftAssertions softAssertions;
    @NotNull
    private final Document document;
    @NotNull
    private final String cssSelector;

    public NodeAssertionsSpec(@NotNull DocumentSoftAssertions softAssertions, @NotNull Document document, @NotNull String cssSelector) {
        Intrinsics.checkNotNullParameter((Object)((Object)softAssertions), (String)"softAssertions");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)cssSelector, (String)"cssSelector");
        this.softAssertions = softAssertions;
        this.document = document;
        this.cssSelector = cssSelector;
    }

    @NotNull
    public final NodeAssertionsSpec exists() {
        NodeAssertionsSpec nodeAssertionsSpec;
        NodeAssertionsSpec $this$exists_u24lambda_u2d0 = nodeAssertionsSpec = this;
        boolean bl = false;
        $this$exists_u24lambda_u2d0.softAssertions.assertThat($this$exists_u24lambda_u2d0.document).elementExists($this$exists_u24lambda_u2d0.cssSelector);
        return nodeAssertionsSpec;
    }

    @NotNull
    public final NodeAssertionsSpec exists(int count) {
        NodeAssertionsSpec nodeAssertionsSpec;
        NodeAssertionsSpec $this$exists_u24lambda_u2d1 = nodeAssertionsSpec = this;
        boolean bl = false;
        $this$exists_u24lambda_u2d1.softAssertions.assertThat($this$exists_u24lambda_u2d1.document).elementExists($this$exists_u24lambda_u2d1.cssSelector, count);
        return nodeAssertionsSpec;
    }

    @NotNull
    public final NodeAssertionsSpec notExists() {
        NodeAssertionsSpec nodeAssertionsSpec;
        NodeAssertionsSpec $this$notExists_u24lambda_u2d2 = nodeAssertionsSpec = this;
        boolean bl = false;
        $this$notExists_u24lambda_u2d2.softAssertions.assertThat($this$notExists_u24lambda_u2d2.document).elementNotExists($this$notExists_u24lambda_u2d2.cssSelector);
        return nodeAssertionsSpec;
    }

    @NotNull
    public final NodeAssertionsSpec containsHtml(@NotNull String substring) {
        NodeAssertionsSpec nodeAssertionsSpec;
        Intrinsics.checkNotNullParameter((Object)substring, (String)"substring");
        NodeAssertionsSpec $this$containsHtml_u24lambda_u2d3 = nodeAssertionsSpec = this;
        boolean bl = false;
        $this$containsHtml_u24lambda_u2d3.softAssertions.assertThat($this$containsHtml_u24lambda_u2d3.document).elementContainsHtml($this$containsHtml_u24lambda_u2d3.cssSelector, substring);
        return nodeAssertionsSpec;
    }

    @NotNull
    public final NodeAssertionsSpec hasHtml(@NotNull String text) {
        NodeAssertionsSpec nodeAssertionsSpec;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        NodeAssertionsSpec $this$hasHtml_u24lambda_u2d4 = nodeAssertionsSpec = this;
        boolean bl = false;
        $this$hasHtml_u24lambda_u2d4.softAssertions.assertThat($this$hasHtml_u24lambda_u2d4.document).elementHasHtml($this$hasHtml_u24lambda_u2d4.cssSelector, text);
        return nodeAssertionsSpec;
    }

    @NotNull
    public final NodeAssertionsSpec hasHtml(String ... texts) {
        NodeAssertionsSpec nodeAssertionsSpec;
        Intrinsics.checkNotNullParameter((Object)texts, (String)"texts");
        NodeAssertionsSpec $this$hasHtml_u24lambda_u2d5 = nodeAssertionsSpec = this;
        boolean bl = false;
        $this$hasHtml_u24lambda_u2d5.softAssertions.assertThat($this$hasHtml_u24lambda_u2d5.document).elementHasHtml($this$hasHtml_u24lambda_u2d5.cssSelector, Arrays.copyOf(texts, texts.length));
        return nodeAssertionsSpec;
    }

    @NotNull
    public final NodeAssertionsSpec hasHtml(@Nullable Object obj) {
        NodeAssertionsSpec nodeAssertionsSpec;
        NodeAssertionsSpec $this$hasHtml_u24lambda_u2d6 = nodeAssertionsSpec = this;
        boolean bl = false;
        DocumentAssert documentAssert = $this$hasHtml_u24lambda_u2d6.softAssertions.assertThat($this$hasHtml_u24lambda_u2d6.document);
        String string = $this$hasHtml_u24lambda_u2d6.cssSelector;
        Object object = obj;
        if (object == null || (object = object.toString()) == null) {
            object = "";
        }
        documentAssert.elementHasHtml(string, (String)object);
        return nodeAssertionsSpec;
    }

    @NotNull
    public final NodeAssertionsSpec containsText(@NotNull String substring) {
        NodeAssertionsSpec nodeAssertionsSpec;
        Intrinsics.checkNotNullParameter((Object)substring, (String)"substring");
        NodeAssertionsSpec $this$containsText_u24lambda_u2d7 = nodeAssertionsSpec = this;
        boolean bl = false;
        $this$containsText_u24lambda_u2d7.softAssertions.assertThat($this$containsText_u24lambda_u2d7.document).elementContainsText($this$containsText_u24lambda_u2d7.cssSelector, substring);
        return nodeAssertionsSpec;
    }

    @NotNull
    public final NodeAssertionsSpec hasText(@NotNull String text) {
        NodeAssertionsSpec nodeAssertionsSpec;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        NodeAssertionsSpec $this$hasText_u24lambda_u2d8 = nodeAssertionsSpec = this;
        boolean bl = false;
        $this$hasText_u24lambda_u2d8.softAssertions.assertThat($this$hasText_u24lambda_u2d8.document).elementHasText($this$hasText_u24lambda_u2d8.cssSelector, text);
        return nodeAssertionsSpec;
    }

    @NotNull
    public final NodeAssertionsSpec hasText(String ... texts) {
        NodeAssertionsSpec nodeAssertionsSpec;
        Intrinsics.checkNotNullParameter((Object)texts, (String)"texts");
        NodeAssertionsSpec $this$hasText_u24lambda_u2d9 = nodeAssertionsSpec = this;
        boolean bl = false;
        $this$hasText_u24lambda_u2d9.softAssertions.assertThat($this$hasText_u24lambda_u2d9.document).elementHasText($this$hasText_u24lambda_u2d9.cssSelector, Arrays.copyOf(texts, texts.length));
        return nodeAssertionsSpec;
    }

    @NotNull
    public final NodeAssertionsSpec hasText(@Nullable Object obj) {
        NodeAssertionsSpec nodeAssertionsSpec;
        NodeAssertionsSpec $this$hasText_u24lambda_u2d10 = nodeAssertionsSpec = this;
        boolean bl = false;
        DocumentAssert documentAssert = $this$hasText_u24lambda_u2d10.softAssertions.assertThat($this$hasText_u24lambda_u2d10.document);
        String string = $this$hasText_u24lambda_u2d10.cssSelector;
        Object object = obj;
        if (object == null || (object = object.toString()) == null) {
            object = "";
        }
        documentAssert.elementHasText(string, (String)object);
        return nodeAssertionsSpec;
    }

    @NotNull
    public final NodeAssertionsSpec hasClass(@NotNull String name) {
        NodeAssertionsSpec nodeAssertionsSpec;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        NodeAssertionsSpec $this$hasClass_u24lambda_u2d11 = nodeAssertionsSpec = this;
        boolean bl = false;
        $this$hasClass_u24lambda_u2d11.softAssertions.assertThat($this$hasClass_u24lambda_u2d11.document).elementHasClass($this$hasClass_u24lambda_u2d11.cssSelector, name);
        return nodeAssertionsSpec;
    }

    @NotNull
    public final NodeAssertionsSpec notHasClass(@NotNull String name) {
        NodeAssertionsSpec nodeAssertionsSpec;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        NodeAssertionsSpec $this$notHasClass_u24lambda_u2d12 = nodeAssertionsSpec = this;
        boolean bl = false;
        $this$notHasClass_u24lambda_u2d12.softAssertions.assertThat($this$notHasClass_u24lambda_u2d12.document).elementNotHasClass($this$notHasClass_u24lambda_u2d12.cssSelector, name);
        return nodeAssertionsSpec;
    }

    @NotNull
    public final NodeAssertionsSpec hasAttribute(@NotNull String name) {
        NodeAssertionsSpec nodeAssertionsSpec;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        NodeAssertionsSpec $this$hasAttribute_u24lambda_u2d13 = nodeAssertionsSpec = this;
        boolean bl = false;
        $this$hasAttribute_u24lambda_u2d13.attribute(name, (Function1<? super AttributeAssertionsSpec, AttributeAssertionsSpec>)((Function1)hasAttribute.1.1.INSTANCE));
        return nodeAssertionsSpec;
    }

    @NotNull
    public final NodeAssertionsSpec notHasAttribute(@NotNull String name) {
        NodeAssertionsSpec nodeAssertionsSpec;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        NodeAssertionsSpec $this$notHasAttribute_u24lambda_u2d14 = nodeAssertionsSpec = this;
        boolean bl = false;
        $this$notHasAttribute_u24lambda_u2d14.attribute(name, (Function1<? super AttributeAssertionsSpec, AttributeAssertionsSpec>)((Function1)notHasAttribute.1.1.INSTANCE));
        return nodeAssertionsSpec;
    }

    @NotNull
    public final NodeAssertionsSpec attribute(@NotNull String attributeName, @NotNull Function1<? super AttributeAssertionsSpec, AttributeAssertionsSpec> function1) {
        NodeAssertionsSpec nodeAssertionsSpec;
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        Intrinsics.checkNotNullParameter(function1, (String)"assert");
        NodeAssertionsSpec $this$attribute_u24lambda_u2d15 = nodeAssertionsSpec = this;
        boolean bl = false;
        AttributeAssertionsSpec spec = new AttributeAssertionsSpec($this$attribute_u24lambda_u2d15.softAssertions, $this$attribute_u24lambda_u2d15.document, $this$attribute_u24lambda_u2d15.cssSelector, attributeName);
        function1.invoke((Object)spec);
        return nodeAssertionsSpec;
    }

    @NotNull
    public final NodeAssertionsSpec attribute(@NotNull String attributeName) {
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        return this.attribute(attributeName, (Function1<? super AttributeAssertionsSpec, AttributeAssertionsSpec>)((Function1)attribute.2.INSTANCE));
    }

    private final DocumentSoftAssertions component1() {
        return this.softAssertions;
    }

    private final Document component2() {
        return this.document;
    }

    private final String component3() {
        return this.cssSelector;
    }

    @NotNull
    public final NodeAssertionsSpec copy(@NotNull DocumentSoftAssertions softAssertions, @NotNull Document document, @NotNull String cssSelector) {
        Intrinsics.checkNotNullParameter((Object)((Object)softAssertions), (String)"softAssertions");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)cssSelector, (String)"cssSelector");
        return new NodeAssertionsSpec(softAssertions, document, cssSelector);
    }

    public static /* synthetic */ NodeAssertionsSpec copy$default(NodeAssertionsSpec nodeAssertionsSpec, DocumentSoftAssertions documentSoftAssertions, Document document, String string, int n, Object object) {
        if ((n & 1) != 0) {
            documentSoftAssertions = nodeAssertionsSpec.softAssertions;
        }
        if ((n & 2) != 0) {
            document = nodeAssertionsSpec.document;
        }
        if ((n & 4) != 0) {
            string = nodeAssertionsSpec.cssSelector;
        }
        return nodeAssertionsSpec.copy(documentSoftAssertions, document, string);
    }

    @NotNull
    public String toString() {
        return "NodeAssertionsSpec(softAssertions=" + (Object)((Object)this.softAssertions) + ", document=" + this.document + ", cssSelector=" + this.cssSelector + ')';
    }

    public int hashCode() {
        int result = this.softAssertions.hashCode();
        result = result * 31 + this.document.hashCode();
        result = result * 31 + this.cssSelector.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NodeAssertionsSpec)) {
            return false;
        }
        NodeAssertionsSpec nodeAssertionsSpec = (NodeAssertionsSpec)other;
        if (!Intrinsics.areEqual((Object)((Object)this.softAssertions), (Object)((Object)nodeAssertionsSpec.softAssertions))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.document, (Object)nodeAssertionsSpec.document)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.cssSelector, (Object)nodeAssertionsSpec.cssSelector);
    }
}

