/*
 * Decompiled with CFR 0.152.
 */
package io.github.uptalent.starter.config;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class AuthenticationFilter
extends OncePerRequestFilter {
    protected void doFilterInternal(HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        String userIdHeader = request.getHeader("User-Id");
        String userRoleHeader = request.getHeader("User-Role");
        if (userIdHeader != null && userRoleHeader != null) {
            Authentication authentication = this.getAuthentication(userIdHeader, userRoleHeader);
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private Authentication getAuthentication(String userIdHeader, String userRoleHeader) {
        long id = Long.parseLong(userIdHeader);
        SimpleGrantedAuthority authority = new SimpleGrantedAuthority(userRoleHeader);
        return new UsernamePasswordAuthenticationToken((Object)id, null, List.of(authority));
    }
}

