/*
 * Decompiled with CFR 0.152.
 */
package io.github.uptalent.starter.config;

import feign.RequestInterceptor;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import jakarta.servlet.http.HttpServletRequest;
import java.time.Duration;
import java.util.Collection;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FeignConfig {
    private final HttpServletRequest request;

    @Bean
    public RequestInterceptor requestInterceptor() {
        return requestTemplate -> {
            Collection skipInterceptorHeaders = (Collection)requestTemplate.headers().get("skipInterceptor");
            if (skipInterceptorHeaders == null || !Boolean.parseBoolean((String)skipInterceptorHeaders.iterator().next())) {
                String userId = this.request.getHeader("User-Id");
                String userRole = this.request.getHeader("User-Role");
                if (userId != null) {
                    requestTemplate.header("User-Id", new String[]{userId});
                }
                if (userRole != null) {
                    requestTemplate.header("User-Role", new String[]{userRole});
                }
            }
        };
    }

    @Bean
    public CircuitBreakerRegistry circuitBreakerRegistry() {
        CircuitBreakerConfig circuitBreakerConfig = CircuitBreakerConfig.custom().slidingWindowSize(5).minimumNumberOfCalls(10).failureRateThreshold(50.0f).waitDurationInOpenState(Duration.ofSeconds(10L)).build();
        return CircuitBreakerRegistry.of((CircuitBreakerConfig)circuitBreakerConfig);
    }

    @Bean
    public TimeLimiterRegistry timeLimiterRegistry() {
        TimeLimiterConfig timeLimiterConfig = TimeLimiterConfig.custom().timeoutDuration(Duration.ofMillis(10000L)).build();
        return TimeLimiterRegistry.of((TimeLimiterConfig)timeLimiterConfig);
    }

    public FeignConfig(HttpServletRequest request) {
        this.request = request;
    }
}

