/*
 * Decompiled with CFR 0.152.
 */
package io.github.uptalent.starter.security;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import java.time.Instant;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class JwtBlacklistService {
    private static final String BEARER_PREFIX = "Bearer ";
    private static final String JWT_BLACKLIST_KEY = "jwt_blacklist:";
    private final RedisTemplate<String, String> redisTemplate;

    public void addToBlacklist(String token) {
        token = token.substring(BEARER_PREFIX.length());
        JWTClaimsSet claims = JWTParser.parse((String)token).getJWTClaimsSet();
        Instant tokenExpiration = claims.getExpirationTime().toInstant();
        String key = JWT_BLACKLIST_KEY + token.toLowerCase();
        this.redisTemplate.opsForValue().set((Object)key, (Object)"");
        this.redisTemplate.expireAt((Object)key, tokenExpiration);
    }

    public JwtBlacklistService(RedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

