/*
 * Decompiled with CFR 0.152.
 */
package io.github.uptalent.starter.util.enums;

import io.github.uptalent.starter.util.enums.EnumValue;
import io.github.uptalent.starter.util.exception.InvalidEnumValueException;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public class EnumValidator
implements ConstraintValidator<EnumValue, String> {
    private Set<String> allowedValues;

    public void initialize(EnumValue validEnumValue) {
        Class<Enum<?>> enumClass = validEnumValue.enumClass();
        this.allowedValues = Arrays.stream(enumClass.getEnumConstants()).map(Enum::name).collect(Collectors.toSet());
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value != null && this.allowedValues.contains(value.toUpperCase())) {
            return true;
        }
        throw new InvalidEnumValueException("Invalid value: " + value);
    }
}

