/*
 * Decompiled with CFR 0.152.
 */
package io.github.uptalent.starter.validation;

import io.github.uptalent.starter.util.ErrorResponse;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@RestControllerAdvice
public class ValidationExceptionHandler {
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={AccessDeniedException.class})
    public ErrorResponse handlerAccessDeniedException() {
        return new ErrorResponse("You do not have the necessary permissions to perform this operation");
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Map<String, String> handleMethodArgumentNotValidException(MethodArgumentNotValidException ex) {
        List fieldErrors = ex.getBindingResult().getFieldErrors();
        return fieldErrors.stream().collect(Collectors.toMap(FieldError::getField, fieldError -> Optional.ofNullable(fieldError.getDefaultMessage()).orElse("N/A")));
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Map<String, String> handleConstraintViolationException(ConstraintViolationException ex) {
        Set constraintViolations = ex.getConstraintViolations();
        return constraintViolations.stream().collect(Collectors.toMap(violation -> this.getFieldNameFromPath(violation.getPropertyPath()), ConstraintViolation::getMessage));
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Map<String, String> handleMethodArgumentTypeMismatchException(MethodArgumentTypeMismatchException e) {
        HashMap<String, String> errorMap = new HashMap<String, String>();
        errorMap.put(e.getName(), "Invalid query parameter");
        return errorMap;
    }

    private String getFieldNameFromPath(Path propertyPath) {
        String fullPath = propertyPath.toString();
        int dotIndex = fullPath.lastIndexOf(".");
        if (dotIndex != -1) {
            return fullPath.substring(dotIndex + 1);
        }
        return fullPath;
    }
}

