/*
 * Decompiled with CFR 0.152.
 */
package ap;

import ap.AbstractFileProver;
import ap.AbstractFileProver$;
import ap.CmdlMain$NullStream$;
import ap.IntelliFileProver;
import ap.ParallelFileProver;
import ap.ParallelFileProver$;
import ap.Prover;
import ap.Prover$NoCounterModel$;
import ap.Prover$NoModel$;
import ap.Prover$TimeoutResult$;
import ap.api.SimpleAPI;
import ap.package$;
import ap.parameters.GlobalSettings;
import ap.parameters.GlobalSettings$;
import ap.parameters.Param;
import ap.parameters.Param$ASSERTIONS$;
import ap.parameters.Param$COMPUTE_UNSAT_CORE$;
import ap.parameters.Param$COUNTER_TIMEOUT$;
import ap.parameters.Param$FULL_HELP$;
import ap.parameters.Param$GENERATE_TOTALITY_AXIOMS$;
import ap.parameters.Param$INCREMENTAL$;
import ap.parameters.Param$INPUT_FORMAT$;
import ap.parameters.Param$InputFormat$;
import ap.parameters.Param$LOGO$;
import ap.parameters.Param$LOG_COUNTERS$;
import ap.parameters.Param$LOG_COUNTERS_CONT$;
import ap.parameters.Param$LOG_LEVEL$;
import ap.parameters.Param$LOG_STATS$;
import ap.parameters.Param$MOST_GENERAL_CONSTRAINT$;
import ap.parameters.Param$PORTFOLIO$;
import ap.parameters.Param$PORTFOLIO_THREAD_NUM$;
import ap.parameters.Param$PRINT_CERTIFICATE$;
import ap.parameters.Param$PRINT_DOT_CERTIFICATE_FILE$;
import ap.parameters.Param$PRINT_SMT_FILE$;
import ap.parameters.Param$PRINT_TPTP_FILE$;
import ap.parameters.Param$PRINT_TREE$;
import ap.parameters.Param$QUIET$;
import ap.parameters.Param$RANDOM_SEED$;
import ap.parameters.Param$STDIN$;
import ap.parameters.Param$TIMEOUT$;
import ap.parameters.Param$TIMEOUT_PER$;
import ap.parameters.Param$VERSION$;
import ap.parameters.Param$WARM_UP$;
import ap.parser.IBinJunctor$;
import ap.parser.IExpression$;
import ap.parser.IExpression$Eq$;
import ap.parser.IFormula;
import ap.parser.IFunction;
import ap.parser.IInterpolantSpec;
import ap.parser.INamedPart;
import ap.parser.Internal2InputAbsy$;
import ap.parser.LineariseVisitor$;
import ap.parser.PartName;
import ap.parser.PartName$;
import ap.parser.PrincessLineariser$;
import ap.parser.SMTLineariser$;
import ap.parser.SMTParser2InputAbsy$;
import ap.parser.Simplifier;
import ap.parser.Simplifier$;
import ap.parser.TPTPLineariser$;
import ap.parser.TPTPTParser$;
import ap.parser.TPTPTParser$ConjecturePartName$;
import ap.proof.certificates.CertFormula;
import ap.proof.certificates.CertFormula$;
import ap.proof.certificates.Certificate;
import ap.proof.certificates.CertificatePrettyPrinter;
import ap.proof.certificates.DagCertificateConverter$;
import ap.proof.certificates.DotLineariser$;
import ap.proof.tree.ProofTree;
import ap.proof.tree.QuantifiedTree$;
import ap.terfor.ConstantTerm;
import ap.terfor.conjunctions.Conjunction;
import ap.terfor.conjunctions.Quantifier;
import ap.terfor.conjunctions.Quantifier$EX$;
import ap.terfor.preds.Predicate;
import ap.util.Debug$;
import ap.util.OpCounters$;
import ap.util.Seqs$;
import ap.util.Timeout$;
import ap.util.Timer$;
import ap.util.Warmup$;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import scala.;
import scala.$less$colon$less$;
import scala.Console$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class CmdlMain$ {
    public static final CmdlMain$ MODULE$ = new CmdlMain$();
    private static final String version = "2024-01-12";
    private static boolean stackTraces = false;

    public String version() {
        return version;
    }

    public boolean stackTraces() {
        return stackTraces;
    }

    public void stackTraces_$eq(boolean x$1) {
        stackTraces = x$1;
    }

    public void printGreeting() {
        Predef$.MODULE$.println((Object)"________       _____");
        Predef$.MODULE$.println((Object)"___  __ \\_________(_)________________________________");
        Predef$.MODULE$.println((Object)"__  /_/ /_  ___/_  /__  __ \\  ___/  _ \\_  ___/_  ___/");
        Predef$.MODULE$.println((Object)"_  ____/_  /   _  / _  / / / /__ /  __/(__  )_(__  )");
        Predef$.MODULE$.println((Object)"/_/     /_/    /_/  /_/ /_/\\___/ \\___//____/ /____/");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"A Theorem Prover for First-Order Logic modulo Linear Integer Arithmetic");
        Predef$.MODULE$.println((Object)new StringBuilder(2).append("(").append(this.version()).append(")").toString());
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"(c) Philipp R\u00fcmmer, 2009-2024");
        Predef$.MODULE$.println((Object)"Contributors: Peter Backeman, Peter Baumgartner, Angelo Brillout, Zafer Esen,");
        Predef$.MODULE$.println((Object)"              Amanda Stjerna.");
        Predef$.MODULE$.println((Object)"Free software under BSD-3-Clause.");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"For more information, visit http://www.philipp.ruemmer.org/princess.shtml");
    }

    public void printUsage() {
        Predef$.MODULE$.println((Object)"Usage: princess <option>* <inputfile>*");
        Predef$.MODULE$.println();
        this.printOptions();
    }

    public void printOptions() {
        Predef$.MODULE$.println((Object)"Standard options:");
        Predef$.MODULE$.println((Object)" [+-]logo                  Print logo and elapsed time              (default: +)");
        Predef$.MODULE$.println((Object)" [+-]fullHelp              Print detailed help and exit             (default: -)");
        Predef$.MODULE$.println((Object)" [+-]version               Print version and exit                   (default: -)");
        Predef$.MODULE$.println((Object)" [+-]quiet                 Suppress all output to stderr            (default: -)");
        Predef$.MODULE$.println((Object)" [+-]assert                Enable runtime assertions                (default: -)");
        Predef$.MODULE$.println((Object)" -inputFormat=val          Specify format of problem file:       (default: auto)");
        Predef$.MODULE$.println((Object)"                             auto, pri, smtlib, tptp");
        Predef$.MODULE$.println((Object)" [+-]stdin                 Read SMT-LIB 2 problems from stdin       (default: -)");
        Predef$.MODULE$.println((Object)" [+-]incremental           Incremental SMT-LIB 2 interpreter        (default: -)");
        Predef$.MODULE$.println((Object)"                             (+incremental implies -genTotalityAxioms)");
        Predef$.MODULE$.println((Object)" -timeout=val              Set a timeout in milliseconds        (default: infty)");
        Predef$.MODULE$.println((Object)" -timeoutPer=val           Set a timeout per SMT-LIB query (ms) (default: infty)");
        Predef$.MODULE$.println((Object)" [+-]model                 Compute models or countermodels          (default: -)");
        Predef$.MODULE$.println((Object)" [+-]unsatCore             Compute unsatisfiable cores              (default: -)");
        Predef$.MODULE$.println((Object)" [+-]printProof            Output the constructed proof             (default: -)");
        Predef$.MODULE$.println((Object)" [+-]mostGeneralConstraint Derive a most general constraint         (default: -)");
        Predef$.MODULE$.println((Object)"                           (quantifier elimination for PA formulae) (default: -)");
        Predef$.MODULE$.println((Object)" -clausifier=val           Choose the clausifier (none, simple)  (default: none)");
        Predef$.MODULE$.println((Object)" [+-]genTotalityAxioms     Generate totality axioms for functions   (default: +)");
    }

    public void printExoticOptions() {
        Predef$.MODULE$.println((Object)"Further general options");
        Predef$.MODULE$.println((Object)"-----------------------");
        Predef$.MODULE$.println((Object)" -timeoutSec=val           Set a timeout in seconds             (default: infty)");
        Predef$.MODULE$.println((Object)" [+-]printTree             Output the internal constraint tree     (default: -)");
        Predef$.MODULE$.println((Object)" -printSMT=filename        Output the problem in SMT-LIB format    (default: \"\")");
        Predef$.MODULE$.println((Object)" -printTPTP=filename       Output the problem in TPTP format       (default: \"\")");
        Predef$.MODULE$.println((Object)" -printDOT=filename        Output the proof in GraphViz format     (default: \"\")");
        Predef$.MODULE$.println((Object)" -portfolio=val            Use a strategy portfolio              (default: none)");
        Predef$.MODULE$.println((Object)"                             none:   off");
        Predef$.MODULE$.println((Object)"                             casc:   Optimised for CASC/TPTP");
        Predef$.MODULE$.println((Object)"                             qf_lia: Optimised for quantifier-free LIA");
        Predef$.MODULE$.println((Object)"                             bv:     Optimised for quantified BV");
        Predef$.MODULE$.println((Object)" -threads=num              Number of threads to use for portfolio   (default: 1)");
        Predef$.MODULE$.println((Object)" [+-]threads               Automatically choose number of threads   (default: -)");
        Predef$.MODULE$.println((Object)" -formulaSign=val          Optionally negate input formula       (default: auto)");
        Predef$.MODULE$.println((Object)"                             positive: do not negate");
        Predef$.MODULE$.println((Object)"                             negative: negate");
        Predef$.MODULE$.println((Object)"                             auto:     choose automatically");
        Predef$.MODULE$.println((Object)" [+-]equivInlining         Inline simple equivalences p <-> f       (default: +)");
        Predef$.MODULE$.println((Object)" -inlineSizeLimit=val      Maximum size of functions to inline    (default: 100)");
        Predef$.MODULE$.println((Object)" -randomSeed=val           Seed for randomisation");
        Predef$.MODULE$.println((Object)"                             <seed>: numeric seed             (default: 1234567)");
        Predef$.MODULE$.println((Object)"                             off:    disable randomisation");
        Predef$.MODULE$.println((Object)" -logging=flags            Comma-separated list of log flags       (default: \"\")");
        Predef$.MODULE$.println((Object)"                             Flags: tasks, splits, backtracking, stats, lemmas,");
        Predef$.MODULE$.println((Object)"                                    counters, countersCont");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"Proof/interpolation options");
        Predef$.MODULE$.println((Object)"---------------------------");
        Predef$.MODULE$.println((Object)" -constructProofs=val      Extract proofs");
        Predef$.MODULE$.println((Object)"                             never");
        Predef$.MODULE$.println((Object)"                             ifInterpolating: if \\interpolant occurs (default)");
        Predef$.MODULE$.println((Object)"                             always");
        Predef$.MODULE$.println((Object)" [+-]elimInterpolantQuants Eliminate quantifiers from interpolants  (default: +)");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"Quantifier/constraint options");
        Predef$.MODULE$.println((Object)"-----------------------------");
        Predef$.MODULE$.println((Object)" [+-]posUnitResolution     Resolution of clauses with literals in   (default: +)");
        Predef$.MODULE$.println((Object)"                           the antecedent");
        Predef$.MODULE$.println((Object)" [+-]useStrengthenTree     For quantified formulae with inequality  (default: -)");
        Predef$.MODULE$.println((Object)"                           side conditions, use the StrengthenTree");
        Predef$.MODULE$.println((Object)"                           constraint tree constructor");
        Predef$.MODULE$.println((Object)" -simplifyConstraints=val  How to simplify constraints:");
        Predef$.MODULE$.println((Object)"                             none:   not at all");
        Predef$.MODULE$.println((Object)"                             fair:   fair construction of a proof");
        Predef$.MODULE$.println((Object)"                             lemmas: proof construction with lemmas (default)");
        Predef$.MODULE$.println((Object)" -mgcFormat=val            Most general constraints in specific format:");
        Predef$.MODULE$.println((Object)"                             any: Unspecified                       (default)");
        Predef$.MODULE$.println((Object)"                             dnf: disjunctive normal form");
        Predef$.MODULE$.println((Object)"                             cnf: conjunctive normal form");
        Predef$.MODULE$.println((Object)" [+-]traceConstraintSimplifier  Show constraint simplifications     (default: -)");
        Predef$.MODULE$.println((Object)" [+-]dnfConstraints        Continuously rewrite constraints to DNF  (default: +)");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"Function options");
        Predef$.MODULE$.println((Object)"----------------");
        Predef$.MODULE$.println((Object)" -generateTriggers=val     Automatically choose triggers for quant. formulae");
        Predef$.MODULE$.println((Object)"                             none:  not at all");
        Predef$.MODULE$.println((Object)"                             total: for all total functions         (default)");
        Predef$.MODULE$.println((Object)"                             all:   for all functions");
        Predef$.MODULE$.println((Object)"                             complete, completeFrugal: in combination");
        Predef$.MODULE$.println((Object)"                               with -genTotalityAxioms, in such a way");
        Predef$.MODULE$.println((Object)"                               that completeness is not affected");
        Predef$.MODULE$.println((Object)" -triggerStrategy=val      How to choose triggers for quantified formulae");
        Predef$.MODULE$.println((Object)"                             allMinimal");
        Predef$.MODULE$.println((Object)"                             allMinimalAndEmpty");
        Predef$.MODULE$.println((Object)"                             allMaximal");
        Predef$.MODULE$.println((Object)"                             maximal                                (default)");
        Predef$.MODULE$.println((Object)"                             maximalOutermost");
        Predef$.MODULE$.println((Object)" -functionGC=val           Garbage-collect function terms");
        Predef$.MODULE$.println((Object)"                             none:  not at all");
        Predef$.MODULE$.println((Object)"                             total: for all total functions         (default)");
        Predef$.MODULE$.println((Object)"                             all:   for all functions");
        Predef$.MODULE$.println((Object)" [+-]tightFunctionScopes   Keep function application defs. local    (default: +)");
        Predef$.MODULE$.println((Object)" [+-]boolFunsAsPreds       In smtlib and tptp, encode               (default: -)");
        Predef$.MODULE$.println((Object)"                           Boolean functions as predicates");
        Predef$.MODULE$.println((Object)" [+-]reverseFunctionalityPropagation  Infer distinctness of         (default: -)");
        Predef$.MODULE$.println((Object)"                           arguments from distinctness of results");
        Predef$.MODULE$.println((Object)" [+-]useFunctionalConsistencyTheory  Use dummy theory to represent  (default: -)");
        Predef$.MODULE$.println((Object)"                           functional consistency axioms");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"Theory options");
        Predef$.MODULE$.println((Object)"--------------");
        Predef$.MODULE$.println((Object)" -mulProcedure=val         Handling of nonlinear integer formulae");
        Predef$.MODULE$.println((Object)"                             bitShift: shift-and-add axiom");
        Predef$.MODULE$.println((Object)"                             native:   built-in theory solver       (default)");
        Predef$.MODULE$.println((Object)" -mulSplitting=val         Splitting in nonlinear integer formulae");
        Predef$.MODULE$.println((Object)"                             sign:        +/-/interval splitting    (default)");
        Predef$.MODULE$.println((Object)"                             signMinimal: +/-/interval, minimal var set");
        Predef$.MODULE$.println((Object)" -adtMeasure=val           Measure to ensure acyclicity of ADTs");
        Predef$.MODULE$.println((Object)"                             relDepth: relative depth of terms");
        Predef$.MODULE$.println((Object)"                             size:     size of terms                (default)");
        Predef$.MODULE$.println((Object)" -stringSolver=val         Specify the used string solver");
        Predef$.MODULE$.println((Object)"                             (default: ap.theories.strings.SeqStringTheory)");
        Predef$.MODULE$.println((Object)" -seqSolver=val            Specify the used sequence solver");
        Predef$.MODULE$.println((Object)"                             (default: ap.theories.sequences.ArraySeqTheory)");
        Predef$.MODULE$.println((Object)" [+-]stringEscapes         Accept extended set of string escapes    (default: -)");
    }

    private void printSMT(AbstractFileProver prover, String filename, GlobalSettings settings) {
        Object object = Param$PRINT_SMT_FILE$.MODULE$.apply(settings);
        String string = "";
        if (object == null || !object.equals(string)) {
            Predef$.MODULE$.println();
            Object object2 = Param$PRINT_SMT_FILE$.MODULE$.apply(settings);
            String string2 = "-";
            if (object2 == null || !object2.equals(string2)) {
                Predef$.MODULE$.println((Object)new StringBuilder(28).append("Saving in SMT format to ").append(Param$PRINT_SMT_FILE$.MODULE$.apply(settings)).append(" ...").toString());
                FileOutputStream out = new FileOutputStream((String)Param$PRINT_SMT_FILE$.MODULE$.apply(settings));
                Console$.MODULE$.withOut((OutputStream)out, (Function0)(JFunction0.mcV.sp & Serializable)() -> CmdlMain$.linearise$1(prover, filename));
                out.close();
                return;
            }
            CmdlMain$.linearise$1(prover, filename);
            return;
        }
    }

    private void printTPTP(AbstractFileProver prover, String filename, GlobalSettings settings) {
        Object object = Param$PRINT_TPTP_FILE$.MODULE$.apply(settings);
        String string = "";
        if (object == null || !object.equals(string)) {
            Predef$.MODULE$.println();
            Object object2 = Param$PRINT_TPTP_FILE$.MODULE$.apply(settings);
            String string2 = "-";
            if (object2 == null || !object2.equals(string2)) {
                Predef$.MODULE$.println((Object)new StringBuilder(29).append("Saving in TPTP format to ").append(Param$PRINT_TPTP_FILE$.MODULE$.apply(settings)).append(" ...").toString());
                FileOutputStream out = new FileOutputStream((String)Param$PRINT_TPTP_FILE$.MODULE$.apply(settings));
                Console$.MODULE$.withOut((OutputStream)out, (Function0)(JFunction0.mcV.sp & Serializable)() -> CmdlMain$.linearise$2(prover, filename));
                out.close();
                return;
            }
            CmdlMain$.linearise$2(prover, filename);
            return;
        }
    }

    private void printCertificate(Certificate cert, GlobalSettings settings, Prover prover, Enumeration.Value format) {
        if (BoxesRunTime.unboxToBoolean((Object)Param$COMPUTE_UNSAT_CORE$.MODULE$.apply(settings))) {
            Console$.MODULE$.err().println();
            Console$.MODULE$.err().println("Unsatisfiable core:");
            scala.collection.immutable.Set nameStrings = (scala.collection.immutable.Set)((scala.collection.immutable.Set)prover.getAssumedFormulaParts(cert).$minus((Object)PartName$.MODULE$.NO_NAME())).map((Function1 & Serializable)x0$1 -> {
                Option<String> option;
                if (x0$1 != null && !(option = TPTPTParser$ConjecturePartName$.MODULE$.unapply((PartName)x0$1)).isEmpty()) {
                    return (String)option.get();
                }
                return x0$1.toString();
            });
            Predef$.MODULE$.println((Object)new StringBuilder(2).append("{").append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])nameStrings.toArray(ClassTag$.MODULE$.apply(String.class))), (Ordering)Ordering.String$.MODULE$)).mkString(", ")).append("}").toString());
        }
        if (BoxesRunTime.unboxToBoolean((Object)Param$PRINT_CERTIFICATE$.MODULE$.apply(settings))) {
            this.printTextCertificate(cert, settings, prover, format);
        }
        Object object = Param$PRINT_DOT_CERTIFICATE_FILE$.MODULE$.apply(settings);
        String string = "";
        if (object == null || !object.equals(string)) {
            this.printDOTCertificate(cert, settings);
            return;
        }
    }

    private void printTextCertificate(Certificate cert, GlobalSettings settings, Prover prover, Enumeration.Value format) {
        Predef$.MODULE$.println();
        this.doPrintTextCertificate(cert, prover.getFormulaParts(), prover.getPredTranslation(), format);
    }

    public void doPrintTextCertificate(Certificate cert, Map<PartName, Conjunction> rawFormulaParts, Map<Predicate, IFunction> predTranslation, Enumeration.Value format) {
        block14: {
            block13: {
                Enumeration.Value value;
                Enumeration.Value value2;
                block12: {
                    CertificatePrettyPrinter.FormulaPrinter formulaPrinter;
                    Map formulaParts = rawFormulaParts.view().mapValues((Function1 & Serializable)f -> CertFormula$.MODULE$.apply(f.negate())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                    Seq<Certificate> dagCert = DagCertificateConverter$.MODULE$.apply(cert);
                    Enumeration.Value value3 = Param$InputFormat$.MODULE$.Princess();
                    if (!(value3 != null ? !value3.equals(format) : format != null)) {
                        formulaPrinter = new CertificatePrettyPrinter.PrincessFormulaPrinter(predTranslation);
                    } else {
                        Enumeration.Value value4 = Param$InputFormat$.MODULE$.TPTP();
                        if (!(value4 != null ? !value4.equals(format) : format != null)) {
                            formulaPrinter = new CertificatePrettyPrinter.TPTPFormulaPrinter(predTranslation);
                        } else {
                            Enumeration.Value value5 = Param$InputFormat$.MODULE$.SMTLIB();
                            if (!(value5 != null ? !value5.equals(format) : format != null)) {
                                formulaPrinter = new CertificatePrettyPrinter.SMTLIBFormulaPrinter(predTranslation);
                            } else {
                                throw new MatchError((Object)format);
                            }
                        }
                    }
                    CertificatePrettyPrinter.PrincessFormulaPrinter formulaPrinter2 = formulaPrinter;
                    CertificatePrettyPrinter printer = new CertificatePrettyPrinter(formulaPrinter2);
                    Enumeration.Value value6 = format;
                    Enumeration.Value value7 = Param$InputFormat$.MODULE$.TPTP();
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        Predef$.MODULE$.println((Object)"% SZS output start Proof for theBenchmark");
                    }
                    printer.apply(dagCert, (Map<PartName, CertFormula>)formulaParts);
                    value2 = format;
                    value = Param$InputFormat$.MODULE$.TPTP();
                    if (value2 != null) break block12;
                    if (value != null) {
                        return;
                    }
                    break block13;
                }
                if (!value2.equals(value)) break block14;
            }
            Predef$.MODULE$.println((Object)"% SZS output end Proof for theBenchmark");
            return;
        }
    }

    private void printDOTCertificate(Certificate cert, GlobalSettings settings) {
        Console$.MODULE$.err().println();
        Object object = Param$PRINT_DOT_CERTIFICATE_FILE$.MODULE$.apply(settings);
        String string = "-";
        if (object == null || !object.equals(string)) {
            Console$.MODULE$.err().println(new StringBuilder(45).append("Saving certificate in GraphViz format to ").append(Param$PRINT_DOT_CERTIFICATE_FILE$.MODULE$.apply(settings)).append(" ...").toString());
            FileOutputStream out = new FileOutputStream((String)Param$PRINT_DOT_CERTIFICATE_FILE$.MODULE$.apply(settings));
            Console$.MODULE$.withOut((OutputStream)out, (Function0)(JFunction0.mcV.sp & Serializable)() -> DotLineariser$.MODULE$.apply(cert));
            out.close();
            return;
        }
        DotLineariser$.MODULE$.apply(cert);
    }

    public Enumeration.Value determineInputFormat(String filename, GlobalSettings settings) {
        Enumeration.Value value = (Enumeration.Value)Param$INPUT_FORMAT$.MODULE$.apply(settings);
        Enumeration.Value value2 = Param$InputFormat$.MODULE$.Auto();
        if (!(value2 != null ? !value2.equals(value) : value != null)) {
            if (filename.endsWith(".pri")) {
                return Param$InputFormat$.MODULE$.Princess();
            }
            if (filename.endsWith(".smt2")) {
                return Param$InputFormat$.MODULE$.SMTLIB();
            }
            if (filename.endsWith(".p")) {
                return Param$InputFormat$.MODULE$.TPTP();
            }
            throw new Exception("could not figure out the input format (recognised types: .pri, .smt2, .p)");
        }
        return value;
    }

    private void printFormula(IFormula f, Enumeration.Value format) {
        Enumeration.Value value = Param$InputFormat$.MODULE$.SMTLIB();
        if (!(value != null ? !value.equals(format) : format != null)) {
            SMTLineariser$.MODULE$.apply(f);
            Predef$.MODULE$.println();
            return;
        }
        PrincessLineariser$.MODULE$.printExpression(f);
        Predef$.MODULE$.println();
    }

    private void printModel(IFormula model, Enumeration.Value format) {
        Enumeration.Value value = Param$InputFormat$.MODULE$.SMTLIB();
        if (!(value != null ? !value.equals(format) : format != null)) {
            SMTLineariser$.MODULE$.printModel(model);
            return;
        }
        this.printFormula(model, format);
    }

    private void printFormula(Conjunction c, Enumeration.Value format) {
        this.printFormula(new Simplifier(Simplifier$.MODULE$.$lessinit$greater$default$1(), Simplifier$.MODULE$.$lessinit$greater$default$2()).apply(Internal2InputAbsy$.MODULE$.apply(c)), format);
    }

    private int existentialConstantNum(ProofTree p) {
        Option<Tuple3<Quantifier, Seq<ConstantTerm>, ProofTree>> option;
        if (p != null && !(option = QuantifiedTree$.MODULE$.unapply(p)).isEmpty()) {
            Quantifier quantifier = (Quantifier)((Tuple3)option.get())._1();
            Seq consts = (Seq)((Tuple3)option.get())._2();
            ProofTree subtree = (ProofTree)((Tuple3)option.get())._3();
            if (Quantifier$EX$.MODULE$.equals(quantifier)) {
                return this.existentialConstantNum(subtree) + consts.size();
            }
        }
        return BoxesRunTime.unboxToInt((Object)p.subtrees().iterator().map((Function1 & Serializable)st -> BoxesRunTime.boxToInteger((int)CmdlMain$.MODULE$.existentialConstantNum(st))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    private boolean counterPrintingEnabled(GlobalSettings settings) {
        return !Seqs$.MODULE$.disjoint((Set)Param$LOG_LEVEL$.MODULE$.apply(settings), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Param.LOG_FLAG[]{Param$LOG_COUNTERS$.MODULE$, Param$LOG_COUNTERS_CONT$.MODULE$})));
    }

    private boolean needsCounters(GlobalSettings settings) {
        return this.counterPrintingEnabled(settings) || BoxesRunTime.unboxToLong((Object)Param$COUNTER_TIMEOUT$.MODULE$.apply(settings)) != Long.MAX_VALUE;
    }

    private void warmup(GlobalSettings settings) {
        if (BoxesRunTime.unboxToBoolean((Object)Param$WARM_UP$.MODULE$.apply(settings))) {
            Warmup$.MODULE$.apply();
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Option<Prover.Result> proveProblem(GlobalSettings settings, String name, Function0<Reader> reader, Function0<Object> userDefStoppingCond, Enumeration.Value format) {
        Debug$.MODULE$.enableAllAssertions(BoxesRunTime.unboxToBoolean((Object)Param$ASSERTIONS$.MODULE$.apply(settings)));
        try {
            block25: {
                block24: {
                    timeBefore = System.currentTimeMillis();
                    baseSettings = Param$INPUT_FORMAT$.MODULE$.set(settings, format);
                    if (this.needsCounters(settings)) {
                        OpCounters$.MODULE$.init();
                    } else {
                        OpCounters$.MODULE$.disable();
                    }
                    v0 = Param$PORTFOLIO$.MODULE$.apply(settings);
                    var10_8 = "none";
                    if (v0 != null && v0.equals(var10_8)) break block24;
                    if (BoxesRunTime.unboxToBoolean((Object)Param$COMPUTE_UNSAT_CORE$.MODULE$.apply(settings)) || BoxesRunTime.unboxToBoolean((Object)Param$PRINT_CERTIFICATE$.MODULE$.apply(settings))) ** GOTO lbl-1000
                    v1 = Param$PRINT_DOT_CERTIFICATE_FILE$.MODULE$.apply(settings);
                    var12_9 = "";
                    if (v1 == null || !v1.equals(var12_9)) lbl-1000:
                    // 2 sources

                    {
                        v2 = true;
                    } else {
                        v2 = false;
                    }
                    needProof = v2;
                    args = new ParallelFileProver.ProverArguments(reader, baseSettings, BoxesRunTime.unboxToInt((Object)Param$TIMEOUT$.MODULE$.apply(settings)), userDefStoppingCond, needProof, (Function1<Prover, BoxedUnit>)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$proveProblem$1$adapted(ap.CmdlMain$ ap.parameters.GlobalSettings java.lang.String scala.Enumeration$Value ap.Prover ), (Lap/Prover;)Ljava/lang/Object;)((CmdlMain$)this, (GlobalSettings)baseSettings, (String)name, (Enumeration.Value)format), BoxesRunTime.unboxToInt((Object)Param$PORTFOLIO_THREAD_NUM$.MODULE$.apply(settings)));
                    v3 /* !! */  = ParallelFileProver$.MODULE$.apply((String)Param$PORTFOLIO$.MODULE$.apply(settings), args);
                    break block25;
                }
                v3 /* !! */  = new IntelliFileProver((Reader)reader.apply(), AbstractFileProver$.MODULE$.timeoutFromSettings(settings), true, userDefStoppingCond, baseSettings);
            }
            prover = v3 /* !! */ ;
            Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)(JFunction0.mcV.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$proveProblem$2(), ()V)());
            this.printResult(prover, settings, name, format);
            timeAfter = System.currentTimeMillis();
            Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)(JFunction0.mcV.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$proveProblem$3(ap.parameters.GlobalSettings long long ), ()V)((GlobalSettings)settings, (long)timeAfter, (long)timeBefore));
            if (prover instanceof AbstractFileProver) {
                var16_14 = prover;
                this.printSMT(var16_14, name, settings);
                this.printTPTP(var16_14, name, settings);
            }
            if (((SetOps)Param$LOG_LEVEL$.MODULE$.apply(settings)).contains((Object)Param$LOG_STATS$.MODULE$)) {
                Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)(JFunction0.mcV.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$proveProblem$4(), ()V)());
            }
            if (this.counterPrintingEnabled(settings)) {
                Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)(JFunction0.mcV.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$proveProblem$5(), ()V)());
            }
            return new Some((Object)prover.result());
        }
        catch (StackOverflowError v4) {
            v5 = format;
            var17_15 = Param$InputFormat$.MODULE$.SMTLIB();
            if (!(v5 != null ? v5.equals(var17_15) == false : var17_15 != null)) {
                Predef$.MODULE$.println((Object)"unknown");
            }
            Console$.MODULE$.err().println("Stack overflow, giving up");
            return None$.MODULE$;
        }
        catch (OutOfMemoryError v6) {
            v7 = format;
            var18_16 = Param$InputFormat$.MODULE$.SMTLIB();
            if (!(v7 != null ? v7.equals(var18_16) == false : var18_16 != null)) {
                Predef$.MODULE$.println((Object)"unknown");
            }
            Console$.MODULE$.err().println("Out of memory, giving up");
            System.gc();
            return None$.MODULE$;
        }
        catch (Throwable e) {
            if (this.stackTraces()) {
                e.printStackTrace();
            }
            v8 = format;
            var20_18 = Param$InputFormat$.MODULE$.SMTLIB();
            if (!(v8 != null ? v8.equals(var20_18) == false : var20_18 != null)) {
                var21_19 = e.getMessage();
                switch (var21_19 == null ? 0 : var21_19.hashCode()) {
                    case 0: {
                        if (var21_19 == null) {
                            Predef$.MODULE$.println((Object)"error");
                            break;
                        }
                    }
                    default: {
                        Predef$.MODULE$.println((Object)new StringBuilder(10).append("(error \"").append(SMTLineariser$.MODULE$.escapeString(var21_19)).append("\")").toString());
                        break;
                    }
                }
            } else {
                var22_20 = e.getMessage();
                switch (var22_20 == null ? 0 : var22_20.hashCode()) {
                    case 0: {
                        if (var22_20 == null) {
                            Predef$.MODULE$.println((Object)"ERROR");
                            break;
                        }
                    }
                    default: {
                        Predef$.MODULE$.println((Object)new StringBuilder(7).append("ERROR: ").append(var22_20).toString());
                    }
                }
            }
            return None$.MODULE$;
        }
    }

    public void proveMultiSMT(GlobalSettings settings, Reader input, Function0<Object> userDefStoppingCond) {
        try {
            boolean assertions = BoxesRunTime.unboxToBoolean((Object)Param$ASSERTIONS$.MODULE$.apply(settings));
            Debug$.MODULE$.enableAllAssertions(assertions);
            boolean x$3 = BoxesRunTime.unboxToBoolean((Object)Param$GENERATE_TOTALITY_AXIOMS$.MODULE$.apply(settings));
            Option x$4 = (Option)Param$RANDOM_SEED$.MODULE$.apply(settings);
            boolean x$5 = package$.MODULE$.SimpleAPI().withProver$default$3();
            String x$6 = package$.MODULE$.SimpleAPI().withProver$default$4();
            boolean x$7 = package$.MODULE$.SimpleAPI().withProver$default$5();
            String x$8 = package$.MODULE$.SimpleAPI().withProver$default$6();
            File x$9 = package$.MODULE$.SimpleAPI().withProver$default$7();
            boolean x$10 = package$.MODULE$.SimpleAPI().withProver$default$8();
            GlobalSettings x$11 = package$.MODULE$.SimpleAPI().withProver$default$11();
            Function1 & Serializable x$12 = (Function1 & Serializable)p -> {
                CmdlMain$.$anonfun$proveMultiSMT$1(settings, input, userDefStoppingCond, p);
                return BoxedUnit.UNIT;
            };
            package$.MODULE$.SimpleAPI().withProver(assertions, false, x$5, x$6, x$7, x$8, x$9, x$10, x$3, (Option<Object>)x$4, x$11, x$12);
            return;
        }
        catch (StackOverflowError stackOverflowError) {
            Predef$.MODULE$.println((Object)"unknown");
            Console$.MODULE$.err().println("Stack overflow, giving up");
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Predef$.MODULE$.println((Object)"unknown");
            Console$.MODULE$.err().println("Out of memory, giving up");
            System.gc();
            return;
        }
        catch (Throwable e) {
            Predef$.MODULE$.println((Object)"error");
            Console$.MODULE$.err().println(e.getMessage());
            if (this.stackTraces()) {
                e.printStackTrace();
                return;
            }
            return;
        }
    }

    public Object proveProblems(GlobalSettings settings, String name, Function0<Reader> input, Function0<Object> userDefStoppingCond, Enumeration.Value format) {
        Console$.MODULE$.err().println(new StringBuilder(12).append("Loading ").append(name).append(" ...").toString());
        Enumeration.Value value = Param$InputFormat$.MODULE$.SMTLIB();
        if (!(value != null ? !value.equals(format) : format != null) && BoxesRunTime.unboxToBoolean((Object)Param$INCREMENTAL$.MODULE$.apply(settings))) {
            this.proveMultiSMT(settings, (Reader)input.apply(), userDefStoppingCond);
            return BoxedUnit.UNIT;
        }
        return this.proveProblem(settings, name, input, userDefStoppingCond, format);
    }

    public void printResult(Prover prover, GlobalSettings settings, String name, Enumeration.Value format) {
        Enumeration.Value value = Param$InputFormat$.MODULE$.SMTLIB();
        if (!(value != null ? !value.equals(format) : format != null)) {
            Prover.Result result = prover.result();
            if (result instanceof Prover.Proof) {
                ProofTree tree = ((Prover.Proof)result).tree();
                Predef$.MODULE$.println((Object)"unsat");
                this.maybePrintTree(tree, settings, true);
                return;
            }
            if (result instanceof Prover.ProofWithModel) {
                ProofTree tree = ((Prover.ProofWithModel)result).tree();
                Predef$.MODULE$.println((Object)"unsat");
                this.maybePrintTree(tree, settings, true);
                return;
            }
            if (result instanceof Prover.NoProof) {
                Predef$.MODULE$.println((Object)"unknown");
                return;
            }
            if (result instanceof Prover.Invalid) {
                Predef$.MODULE$.println((Object)"sat");
                return;
            }
            if (result instanceof Prover.CounterModel) {
                Option<IFormula> optModel = ((Prover.CounterModel)result).counterModel();
                Predef$.MODULE$.println((Object)"sat");
                optModel.foreach((Function1 & Serializable)model -> {
                    CmdlMain$.MODULE$.printModel(model, format);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (result instanceof Prover.MaybeCounterModel) {
                Option<IFormula> optModel = ((Prover.MaybeCounterModel)result).counterModel();
                Predef$.MODULE$.println((Object)"unknown");
                optModel.foreach((Function1 & Serializable)model -> {
                    CmdlMain$.MODULE$.printModel(model, format);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (Prover$NoCounterModel$.MODULE$.equals(result)) {
                Predef$.MODULE$.println((Object)"unsat");
                return;
            }
            if (result instanceof Prover.NoCounterModelCert) {
                Certificate cert = ((Prover.NoCounterModelCert)result).certificate();
                Predef$.MODULE$.println((Object)"unsat");
                this.printCertificate(cert, settings, prover, format);
                return;
            }
            if (result instanceof Prover.NoCounterModelCertInter) {
                Prover.NoCounterModelCertInter noCounterModelCertInter = (Prover.NoCounterModelCertInter)result;
                Certificate cert = noCounterModelCertInter.certificate();
                Iterator<IFormula> inters = noCounterModelCertInter.interpolants();
                Predef$.MODULE$.println((Object)"unsat");
                this.printCertificate(cert, settings, prover, format);
                Predef$.MODULE$.println((Object)"(");
                inters.foreach((Function1 & Serializable)i -> {
                    CmdlMain$.$anonfun$printResult$3(format, i);
                    return BoxedUnit.UNIT;
                });
                Predef$.MODULE$.println((Object)")");
                return;
            }
            if (result instanceof Prover.Model) {
                Predef$.MODULE$.println((Object)"unsat");
                return;
            }
            if (result instanceof Prover.AllModels) {
                Predef$.MODULE$.println((Object)"unsat");
                return;
            }
            if (Prover$NoModel$.MODULE$.equals(result)) {
                Predef$.MODULE$.println((Object)"sat");
                return;
            }
            if (result instanceof Prover.TimeoutProof) {
                ProofTree tree = ((Prover.TimeoutProof)result).unfinishedTree();
                Predef$.MODULE$.println((Object)"unknown");
                Console$.MODULE$.err().println("Cancelled or timeout");
                this.maybePrintTree(tree, settings, true);
                return;
            }
            if (result != null && Prover$TimeoutResult$.MODULE$.unapply(result)) {
                Predef$.MODULE$.println((Object)"unknown");
                Console$.MODULE$.err().println("Cancelled or timeout");
                return;
            }
            throw new MatchError((Object)result);
        }
        Enumeration.Value value2 = Param$InputFormat$.MODULE$.TPTP();
        if (!(value2 != null ? !value2.equals(format) : format != null)) {
            Prover.Result result = prover.result();
            if (result instanceof Prover.Proof) {
                ProofTree tree = ((Prover.Proof)result).tree();
                this.printTPTPResult(true, prover, name);
                this.maybePrintTree(tree, settings, true);
                return;
            }
            if (result instanceof Prover.ProofWithModel) {
                ProofTree tree = ((Prover.ProofWithModel)result).tree();
                this.printTPTPResult(true, prover, name);
                this.maybePrintTree(tree, settings, true);
                return;
            }
            if (result instanceof Prover.NoProof) {
                Predef$.MODULE$.println((Object)new StringBuilder(24).append("% SZS status GaveUp for ").append(name).toString());
                return;
            }
            if (result instanceof Prover.Invalid) {
                this.printTPTPResult(false, prover, name);
                return;
            }
            if (result instanceof Prover.CounterModel) {
                Option<IFormula> optModel = ((Prover.CounterModel)result).counterModel();
                this.printTPTPResult(false, prover, name);
                this.maybePrintModel(optModel, "Countermodel", true, format);
                return;
            }
            if (result instanceof Prover.MaybeCounterModel) {
                Option<IFormula> optModel = ((Prover.MaybeCounterModel)result).counterModel();
                Predef$.MODULE$.println((Object)new StringBuilder(24).append("% SZS status GaveUp for ").append(name).toString());
                this.maybePrintModel(optModel, "Possible countermodel", true, format);
                return;
            }
            if (Prover$NoCounterModel$.MODULE$.equals(result)) {
                this.printTPTPResult(true, prover, name);
                return;
            }
            if (result instanceof Prover.NoCounterModelCert) {
                Certificate cert = ((Prover.NoCounterModelCert)result).certificate();
                this.printTPTPResult(true, prover, name);
                this.printCertificate(cert, settings, prover, format);
                return;
            }
            if (result instanceof Prover.NoCounterModelCertInter) {
                Prover.NoCounterModelCertInter noCounterModelCertInter = (Prover.NoCounterModelCertInter)result;
                Certificate cert = noCounterModelCertInter.certificate();
                Iterator<IFormula> inters = noCounterModelCertInter.interpolants();
                this.printTPTPResult(true, prover, name);
                Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    Predef$.MODULE$.println();
                    Predef$.MODULE$.println((Object)"Interpolants:");
                    inters.foreach((Function1 & Serializable)i -> {
                        CmdlMain$.MODULE$.printFormula(i, format);
                        return BoxedUnit.UNIT;
                    });
                });
                this.printCertificate(cert, settings, prover, format);
                return;
            }
            if (result instanceof Prover.Model) {
                Option<IFormula> optModel = ((Prover.Model)result).model();
                this.printTPTPResult(true, prover, name);
                this.maybePrintModel(optModel, "Under the assignment", true, format);
                return;
            }
            if (result instanceof Prover.AllModels) {
                Option<IFormula> optModel = ((Prover.AllModels)result).model();
                this.printTPTPResult(true, prover, name);
                this.maybePrintModel(optModel, "Concrete witness", true, format);
                return;
            }
            if (Prover$NoModel$.MODULE$.equals(result)) {
                this.printTPTPResult(false, prover, name);
                return;
            }
            if (result instanceof Prover.TimeoutProof) {
                Predef$.MODULE$.println((Object)new StringBuilder(25).append("% SZS status Timeout for ").append(name).toString());
                return;
            }
            if (result != null && Prover$TimeoutResult$.MODULE$.unapply(result)) {
                Predef$.MODULE$.println((Object)new StringBuilder(25).append("% SZS status Timeout for ").append(name).toString());
                return;
            }
            throw new MatchError((Object)result);
        }
        Prover.Result result = prover.result();
        if (result instanceof Prover.Proof) {
            Prover.Proof proof = (Prover.Proof)result;
            ProofTree tree = proof.tree();
            IFormula constraint = proof.constraint();
            Predef$.MODULE$.println((Object)"VALID");
            this.maybePrintConstraint(constraint, settings, format);
            this.maybePrintTree(tree, settings, this.maybePrintTree$default$3());
            return;
        }
        if (result instanceof Prover.ProofWithModel) {
            Prover.ProofWithModel proofWithModel = (Prover.ProofWithModel)result;
            ProofTree tree = proofWithModel.tree();
            IFormula constraint = proofWithModel.constraint();
            IFormula model2 = proofWithModel.model();
            Predef$.MODULE$.println((Object)"VALID");
            this.maybePrintConstraint(constraint, settings, format);
            if (!LineariseVisitor$.MODULE$.apply(constraint, IBinJunctor$.MODULE$.And()).forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CmdlMain$.$anonfun$printResult$6(x0$1)))) {
                Predef$.MODULE$.println();
                Predef$.MODULE$.println((Object)"Concrete witness:");
                this.printModel(model2, format);
            }
            this.maybePrintTree(tree, settings, this.maybePrintTree$default$3());
            return;
        }
        if (result instanceof Prover.NoProof) {
            Predef$.MODULE$.println((Object)"UNKNOWN");
            this.maybePrintFixedConstraint(false, "Most-general constraint", settings);
            return;
        }
        if (result instanceof Prover.Invalid) {
            Predef$.MODULE$.println((Object)"INVALID");
            this.maybePrintFixedConstraint(false, "Most-general constraint", settings);
            return;
        }
        if (result instanceof Prover.CounterModel) {
            Option<IFormula> optModel = ((Prover.CounterModel)result).counterModel();
            Predef$.MODULE$.println((Object)"INVALID");
            this.maybePrintModel(optModel, "Countermodel", this.maybePrintModel$default$3(), format);
            this.maybePrintFixedConstraint(false, "Most-general constraint", settings);
            return;
        }
        if (result instanceof Prover.MaybeCounterModel) {
            Option<IFormula> optModel = ((Prover.MaybeCounterModel)result).counterModel();
            Predef$.MODULE$.println((Object)"UNKNOWN");
            this.maybePrintModel(optModel, "Possible countermodel", this.maybePrintModel$default$3(), format);
            this.maybePrintFixedConstraint(false, "Most-general constraint", settings);
            return;
        }
        if (Prover$NoCounterModel$.MODULE$.equals(result)) {
            Predef$.MODULE$.println((Object)"VALID");
            this.maybePrintFixedConstraint(true, "Most-general constraint", settings);
            return;
        }
        if (result instanceof Prover.NoCounterModelCert) {
            Certificate cert = ((Prover.NoCounterModelCert)result).certificate();
            Predef$.MODULE$.println((Object)"VALID");
            this.maybePrintFixedConstraint(true, "Most-general constraint", settings);
            this.printCertificate(cert, settings, prover, format);
            return;
        }
        if (result instanceof Prover.NoCounterModelCertInter) {
            Prover.NoCounterModelCertInter noCounterModelCertInter = (Prover.NoCounterModelCertInter)result;
            Certificate cert = noCounterModelCertInter.certificate();
            Iterator<IFormula> inters = noCounterModelCertInter.interpolants();
            Predef$.MODULE$.println((Object)"VALID");
            this.maybePrintFixedConstraint(true, "Most-general constraint", settings);
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)"Interpolants:");
            inters.foreach((Function1 & Serializable)i -> {
                CmdlMain$.MODULE$.printFormula(i, format);
                return BoxedUnit.UNIT;
            });
            this.printCertificate(cert, settings, prover, format);
            return;
        }
        if (result instanceof Prover.Model) {
            Option<IFormula> optModel = ((Prover.Model)result).model();
            Predef$.MODULE$.println((Object)"VALID");
            this.maybePrintModel(optModel, "Under the assignment", this.maybePrintModel$default$3(), format);
            return;
        }
        if (result instanceof Prover.AllModels) {
            Prover.AllModels allModels = (Prover.AllModels)result;
            IFormula constraint = allModels.constraint();
            Option<IFormula> optModel = allModels.model();
            Predef$.MODULE$.println((Object)"VALID");
            if (BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
                Predef$.MODULE$.println();
                Predef$.MODULE$.println((Object)"Equivalent constraint:");
                this.printFormula(constraint, format);
            }
            this.maybePrintModel(optModel, "Concrete witness", this.maybePrintModel$default$3(), format);
            return;
        }
        if (Prover$NoModel$.MODULE$.equals(result)) {
            Predef$.MODULE$.println((Object)"INVALID");
            this.maybePrintFixedConstraint(false, "Equivalent constraint", settings);
            return;
        }
        if (result instanceof Prover.TimeoutProof) {
            ProofTree tree = ((Prover.TimeoutProof)result).unfinishedTree();
            Predef$.MODULE$.println((Object)"CANCELLED/TIMEOUT");
            if (BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
                Predef$.MODULE$.println();
                Predef$.MODULE$.println((Object)"Current constraint:");
                Timeout$.MODULE$.withTimeoutMillis(1000L, (JFunction0.mcV.sp & Serializable)() -> MODULE$.printFormula(tree.closingConstraint(), format), (JFunction0.mcV.sp & Serializable)() -> Predef$.MODULE$.println((Object)"(timeout)"));
            }
            this.maybePrintTree(tree, settings, this.maybePrintTree$default$3());
            return;
        }
        if (result != null && Prover$TimeoutResult$.MODULE$.unapply(result)) {
            Predef$.MODULE$.println((Object)"CANCELLED/TIMEOUT");
            this.maybePrintFixedConstraint(false, "Current constraint", settings);
            return;
        }
        throw new MatchError((Object)result);
    }

    private boolean containsTPTPConjecture(Prover p) {
        return p.getInputFormulaParts().exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CmdlMain$.$anonfun$containsTPTPConjecture$1(x0$1)));
    }

    private void printTPTPResult(boolean positive, Prover prover, String name) {
        String string;
        boolean bl = this.containsTPTPConjecture(prover);
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(positive, bl);
        if (positive && bl) {
            string = "Theorem";
        } else if (positive && !bl) {
            string = "Unsatisfiable";
        } else if (!positive && bl) {
            string = "CounterSatisfiable";
        } else if (!positive && !bl) {
            string = "Satisfiable";
        } else {
            throw new MatchError((Object)sp2);
        }
        String status = string;
        Predef$.MODULE$.println((Object)new StringBuilder(18).append("% SZS status ").append(status).append(" for ").append(name).toString());
    }

    private void maybePrintTree(ProofTree tree, GlobalSettings settings, boolean stderr) {
        if (BoxesRunTime.unboxToBoolean((Object)Param$PRINT_TREE$.MODULE$.apply(settings))) {
            Console$.MODULE$.withOut(stderr ? Console$.MODULE$.err() : Console$.MODULE$.out(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                Predef$.MODULE$.println();
                Predef$.MODULE$.println((Object)"Proof tree:");
                Predef$.MODULE$.println((Object)tree);
            });
            return;
        }
    }

    private boolean maybePrintTree$default$3() {
        return false;
    }

    private void maybePrintConstraint(IFormula constraint, GlobalSettings settings, Enumeration.Value format) {
        if (!constraint.isTrue() || BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)new StringBuilder(21).append("Under the ").append((Object)(BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings)) ? "most-general " : "")).append("constraint:").toString());
            this.printFormula(constraint, format);
            return;
        }
    }

    private void maybePrintFixedConstraint(boolean value, String name, GlobalSettings settings) {
        if (BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)new StringBuilder(1).append(name).append(":").toString());
            Predef$.MODULE$.println((Object)BoxesRunTime.boxToBoolean((boolean)value));
            return;
        }
    }

    private void maybePrintModel(Option<IFormula> optModel, String name, boolean stderr, Enumeration.Value format) {
        optModel.foreach((Function1 & Serializable)model -> {
            Console$.MODULE$.withOut(stderr ? Console$.MODULE$.err() : Console$.MODULE$.out(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                Predef$.MODULE$.println();
                Predef$.MODULE$.println((Object)new StringBuilder(1).append(name$3).append(":").toString());
                CmdlMain$.MODULE$.printModel(model, format$3);
            });
            return BoxedUnit.UNIT;
        });
    }

    private boolean maybePrintModel$default$3() {
        return false;
    }

    public void main(String[] args) {
        this.doMain(args, (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> false);
    }

    /*
     * WARNING - void declaration
     */
    public void doMain(String[] args, Function0<Object> userDefStoppingCond) {
        Object object = new Object();
        try {
            void var6_6;
            void var5_5;
            Tuple2 tuple2 = this.liftedTree1$1(args, object);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            GlobalSettings settings = (GlobalSettings)tuple2._1();
            Seq inputs = (Seq)tuple2._2();
            if (BoxesRunTime.unboxToBoolean((Object)Param$VERSION$.MODULE$.apply(var5_5))) {
                Predef$.MODULE$.println((Object)this.version());
                return;
            }
            if (BoxesRunTime.unboxToBoolean((Object)Param$FULL_HELP$.MODULE$.apply(var5_5))) {
                Predef$.MODULE$.println((Object)this.version());
                Predef$.MODULE$.println();
                this.printUsage();
                Predef$.MODULE$.println();
                Predef$.MODULE$.println();
                this.printExoticOptions();
                Predef$.MODULE$.println();
                return;
            }
            Console$.MODULE$.withErr(BoxesRunTime.unboxToBoolean((Object)Param$QUIET$.MODULE$.apply(var5_5)) ? CmdlMain$NullStream$.MODULE$ : Console$.MODULE$.err(), (Function0)((JFunction0.mcV.sp & Serializable)() -> CmdlMain$.$anonfun$doMain$2((GlobalSettings)var5_5, (Seq)var6_6, object, userDefStoppingCond)));
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    public static final /* synthetic */ boolean $anonfun$printSMT$2(PartName name$1, INamedPart x0$1) {
        if (x0$1 != null) {
            PartName partName = x0$1.name();
            PartName partName2 = name$1;
            if (!(partName2 != null ? !partName2.equals(partName) : partName != null)) {
                return true;
            }
        }
        return false;
    }

    private static final IFormula formula$1(PartName name, AbstractFileProver prover$1) {
        return IExpression$.MODULE$.removePartName((IFormula)prover$1.inputFormulas().find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CmdlMain$.$anonfun$printSMT$2(name, x0$1))).getOrElse((Function0 & Serializable)() -> IExpression$.MODULE$.Boolean2IFormula(false)));
    }

    private static final void linearise$1(AbstractFileProver prover$1, String filename$1) {
        IInterpolantSpec iInterpolantSpec;
        SeqOps seqOps;
        List<IInterpolantSpec> list = prover$1.interpolantSpecs();
        if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.List().unapplySeq(list))) {
            new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0) == 0) {
                if (prover$1.signature().existentialConstants().isEmpty() && prover$1.signature().universalConstants().isEmpty()) {
                    SMTLineariser$.MODULE$.apply((Seq<IFormula>)new .colon.colon((Object)prover$1.rawInputFormula(), (List)Nil$.MODULE$), prover$1.rawSignature(), filename$1);
                    return;
                }
                List formulas = prover$1.inputFormulas().map((Function1 & Serializable)f -> IExpression$.MODULE$.removePartName((IFormula)f));
                SMTLineariser$.MODULE$.apply((Seq<IFormula>)formulas, prover$1.signature(), filename$1);
                return;
            }
        }
        if (list instanceof .colon.colon && (iInterpolantSpec = (IInterpolantSpec)((.colon.colon)list).head()) != null) {
            List<PartName> left = iInterpolantSpec.left();
            List<PartName> right = iInterpolantSpec.right();
            IFormula common = CmdlMain$.formula$1(PartName$.MODULE$.NO_NAME(), prover$1);
            List formulas = ((List)left.$plus$plus(right)).map((Function1 & Serializable)part -> common.$bar$bar$bar(CmdlMain$.formula$1(part, prover$1)));
            SMTLineariser$.MODULE$.apply((Seq<IFormula>)formulas, prover$1.signature(), filename$1);
            return;
        }
        throw new MatchError(list);
    }

    private static final void linearise$2(AbstractFileProver prover$2, String filename$2) {
        TPTPLineariser$.MODULE$.apply(prover$2.rawInputFormula(), filename$2);
    }

    private final void prelPrinter$1(Prover p, GlobalSettings baseSettings$1, String name$2, Enumeration.Value format$1) {
        Console$.MODULE$.err().println();
        this.printResult(p, baseSettings$1, name$2, format$1);
        Console$.MODULE$.err().println();
    }

    public static final /* synthetic */ void $anonfun$proveProblem$2() {
        Predef$.MODULE$.println();
    }

    public static final /* synthetic */ void $anonfun$proveProblem$3(GlobalSettings settings$1, long timeAfter$1, long timeBefore$1) {
        Predef$.MODULE$.println();
        if (BoxesRunTime.unboxToBoolean((Object)Param$LOGO$.MODULE$.apply(settings$1))) {
            Predef$.MODULE$.println((Object)new StringBuilder(2).append(timeAfter$1 - timeBefore$1).append("ms").toString());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$proveProblem$4() {
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"Statistics:");
        Predef$.MODULE$.println((Object)Timer$.MODULE$);
        Timer$.MODULE$.reset();
    }

    public static final /* synthetic */ void $anonfun$proveProblem$5() {
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"Counters:");
        OpCounters$.MODULE$.printCounters();
    }

    public static final /* synthetic */ void $anonfun$proveMultiSMT$1(GlobalSettings settings$2, Reader input$1, Function0 userDefStoppingCond$1, SimpleAPI p) {
        SMTParser2InputAbsy$.MODULE$.apply(settings$2.toParserSettings(), p).processIncrementally(input$1, BoxesRunTime.unboxToInt((Object)Param$TIMEOUT$.MODULE$.apply(settings$2)), BoxesRunTime.unboxToInt((Object)Param$TIMEOUT_PER$.MODULE$.apply(settings$2)), (Function0<Object>)userDefStoppingCond$1);
    }

    public static final /* synthetic */ void $anonfun$printResult$3(Enumeration.Value format$2, IFormula i) {
        Predef$.MODULE$.print((Object)"  ");
        MODULE$.printFormula(i, format$2);
    }

    public static final /* synthetic */ boolean $anonfun$printResult$6(IFormula x0$1) {
        return x0$1 != null && !IExpression$Eq$.MODULE$.unapply(x0$1).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$containsTPTPConjecture$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((PartName)x0$1._1()).toString().endsWith(TPTPTParser$.MODULE$.CONJECTURE_SUFFIX());
        }
        throw new MatchError(null);
    }

    private final /* synthetic */ Tuple2 liftedTree1$1(String[] args$1, Object nonLocalReturnKey1$1) {
        try {
            return GlobalSettings$.MODULE$.fromArguments((Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)args$1), GlobalSettings$.MODULE$.DEFAULT());
        }
        catch (Throwable e) {
            Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                MODULE$.printGreeting();
                Predef$.MODULE$.println();
            });
            Predef$.MODULE$.println((Object)e.getMessage());
            Predef$.MODULE$.println();
            this.printUsage();
            Predef$.MODULE$.println();
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
    }

    public static final /* synthetic */ void $anonfun$doMain$2(GlobalSettings settings$3, Seq inputs$1, Object nonLocalReturnKey1$1, Function0 userDefStoppingCond$2) {
        if (BoxesRunTime.unboxToBoolean((Object)Param$LOGO$.MODULE$.apply(settings$3))) {
            Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                MODULE$.printGreeting();
                Predef$.MODULE$.println();
            });
        }
        if (inputs$1.isEmpty() && !BoxesRunTime.unboxToBoolean((Object)Param$STDIN$.MODULE$.apply(settings$3))) {
            Console$.MODULE$.err().println("No inputs given, exiting");
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
        MODULE$.warmup(settings$3);
        if (inputs$1.isEmpty() && !BoxesRunTime.unboxToBoolean((Object)Param$STDIN$.MODULE$.apply(settings$3))) {
            Console$.MODULE$.err().println("No inputs given, exiting");
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
        inputs$1.foreach((Function1 & Serializable)filename -> {
            try {
                Enumeration.Value format = MODULE$.determineInputFormat((String)filename, settings$3);
                return MODULE$.proveProblems(settings$3, (String)filename, (Function0<Reader>)(Function0 & Serializable)() -> new BufferedReader(new FileReader(new File((String)filename))), (Function0<Object>)userDefStoppingCond$2, format);
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)new StringBuilder(7).append("ERROR: ").append(e.getMessage()).toString());
                if (MODULE$.stackTraces()) {
                    e.printStackTrace();
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            }
        });
        if (BoxesRunTime.unboxToBoolean((Object)Param$STDIN$.MODULE$.apply(settings$3))) {
            Console$.MODULE$.err().println("Reading SMT-LIB 2 input from stdin ...");
            MODULE$.proveMultiSMT(settings$3, Console$.MODULE$.in(), (Function0<Object>)userDefStoppingCond$2);
            return;
        }
    }

    private CmdlMain$() {
    }

    public static final /* synthetic */ Object $anonfun$proveProblem$1$adapted(CmdlMain$ $this, GlobalSettings baseSettings$1, String name$2, Enumeration.Value format$1, Prover p) {
        $this.prelPrinter$1(p, baseSettings$1, name$2, format$1);
        return BoxedUnit.UNIT;
    }
}

