/*
 * Decompiled with CFR 0.152.
 */
package ap.parser;

import ap.parser.IBoolLit;
import ap.parser.IExpression;
import ap.parser.IExpression$;
import ap.parser.IFormula;
import ap.parser.ITerm;
import ap.parser.ITermITE;
import ap.parser.Parser2InputAbsy;
import ap.parser.SMTLineariser$;
import ap.parser.SMTTypes;
import ap.parser.SMTTypes$SMTBool$;
import ap.parser.smtlib.Absyn.CastIdentifierRef;
import ap.parser.smtlib.Absyn.CompositeSort;
import ap.parser.smtlib.Absyn.HexIndex;
import ap.parser.smtlib.Absyn.IdentSort;
import ap.parser.smtlib.Absyn.Identifier;
import ap.parser.smtlib.Absyn.IdentifierRef;
import ap.parser.smtlib.Absyn.IndexC;
import ap.parser.smtlib.Absyn.IndexIdent;
import ap.parser.smtlib.Absyn.NormalSymbol;
import ap.parser.smtlib.Absyn.NumIndex;
import ap.parser.smtlib.Absyn.QuotedSymbol;
import ap.parser.smtlib.Absyn.Sort;
import ap.parser.smtlib.Absyn.SymIndex;
import ap.parser.smtlib.Absyn.Symbol;
import ap.parser.smtlib.Absyn.SymbolIdent;
import ap.parser.smtlib.Absyn.SymbolRef;
import ap.parser.smtlib.Yylex;
import ap.parser.smtlib.parser;
import java.io.Reader;
import java.io.Serializable;
import java.util.List;
import java_cup.runtime.Scanner;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.util.matching.Regex;

public final class SMTParsingUtils$ {
    public static final SMTParsingUtils$ MODULE$ = new SMTParsingUtils$();
    private static final Regex DecLiteral = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("([0-9]+)"));
    private static final Regex HexLiteral = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("#x([0-9a-fA-F]+)"));
    private static final Regex BVDecLiteral = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("bv([0-9]+)"));
    private static final Regex FFDecLiteral = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("ff([0-9]+)"));

    public <T> T parseWithEntry(Reader input, Function1<parser, T> entry) {
        Yylex l = new Yylex((Reader)new Parser2InputAbsy.CRRemover2(input));
        parser p = new parser((Scanner)l);
        try {
            return (T)entry.apply((Object)p);
        }
        catch (Exception e) {
            try {
                String msg = new StringBuilder(24).append("At line ").append(String.valueOf(l.line_num())).append(", near \"").append(l.buff()).append("\" :").append("     ").append(e.getMessage()).toString();
                throw new Parser2InputAbsy.ParseException(msg);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                throw new Parser2InputAbsy.ParseException("Runaway block, probably due to mismatched parentheses");
            }
        }
    }

    public <A> Seq<A> impToScalaList(List<A> l) {
        return JavaConverters$.MODULE$.asScala(l).toSeq();
    }

    public <A> Iterator<A> impToScalaIterator(java.util.Iterator<A> l) {
        return JavaConverters$.MODULE$.asScala(l);
    }

    public String asString(SymbolRef s) {
        if (s instanceof IdentifierRef) {
            IdentifierRef identifierRef = (IdentifierRef)s;
            return this.asString(identifierRef.identifier_);
        }
        if (s instanceof CastIdentifierRef) {
            CastIdentifierRef castIdentifierRef = (CastIdentifierRef)s;
            return this.asString(castIdentifierRef.identifier_);
        }
        throw new MatchError((Object)s);
    }

    public String asString(IndexC id) {
        if (id instanceof NumIndex) {
            return ((NumIndex)id).numeral_;
        }
        if (id instanceof HexIndex) {
            return ((HexIndex)id).hexadecimal_;
        }
        if (id instanceof SymIndex) {
            SymIndex symIndex = (SymIndex)id;
            return this.asString(symIndex.symbol_);
        }
        throw new MatchError((Object)id);
    }

    public String asString(Identifier id2) {
        if (id2 instanceof SymbolIdent) {
            SymbolIdent symbolIdent = (SymbolIdent)id2;
            return this.asString(symbolIdent.symbol_);
        }
        if (id2 instanceof IndexIdent) {
            IndexIdent indexIdent = (IndexIdent)id2;
            return new StringBuilder(1).append(this.asString(indexIdent.symbol_)).append("_").append(((IterableOnceOps)this.impToScalaList((List)indexIdent.listindexc_).map((Function1 & Serializable)id -> MODULE$.asString((IndexC)id))).mkString("_")).toString();
        }
        throw new MatchError((Object)id2);
    }

    public String asString(Symbol s) {
        if (s instanceof NormalSymbol) {
            return ((NormalSymbol)s).normalsymbolt_;
        }
        if (s instanceof QuotedSymbol) {
            QuotedSymbol quotedSymbol = (QuotedSymbol)s;
            return quotedSymbol.quotedsymbolt_.substring(1, quotedSymbol.quotedsymbolt_.length() - 1);
        }
        throw new MatchError((Object)s);
    }

    public String asString(Sort s) {
        if (s instanceof IdentSort) {
            IdentSort identSort = (IdentSort)s;
            return this.asString(identSort.identifier_);
        }
        if (s instanceof CompositeSort) {
            CompositeSort compositeSort = (CompositeSort)s;
            return new StringBuilder(1).append(this.asString(compositeSort.identifier_)).append("_").append(((IterableOnceOps)this.impToScalaList((List)compositeSort.listsort_).map((Function1 & Serializable)x$1 -> MODULE$.asString((Sort)x$1))).mkString("_")).toString();
        }
        throw new MatchError((Object)s);
    }

    public Regex DecLiteral() {
        return DecLiteral;
    }

    public Regex HexLiteral() {
        return HexLiteral;
    }

    public Regex BVDecLiteral() {
        return BVDecLiteral;
    }

    public Regex FFDecLiteral() {
        return FFDecLiteral;
    }

    public ITerm asTerm(Tuple2<IExpression, SMTTypes.SMTType> expr) {
        boolean bl;
        IExpression iExpression;
        boolean bl2;
        IExpression iExpression2;
        IExpression expr2;
        if (expr != null && (expr2 = (IExpression)expr._1()) instanceof ITerm) {
            return (ITerm)expr2;
        }
        if (expr != null && (iExpression2 = (IExpression)expr._1()) instanceof IBoolLit && (bl2 = ((IBoolLit)iExpression2).value())) {
            return IExpression$.MODULE$.i(0);
        }
        if (expr != null && (iExpression = (IExpression)expr._1()) instanceof IBoolLit && !(bl = ((IBoolLit)iExpression).value())) {
            return IExpression$.MODULE$.i(1);
        }
        if (expr != null) {
            IExpression expr3 = (IExpression)expr._1();
            SMTTypes.SMTType sMTType = (SMTTypes.SMTType)expr._2();
            if (expr3 instanceof IFormula) {
                IFormula iFormula = (IFormula)expr3;
                if (SMTTypes$SMTBool$.MODULE$.equals(sMTType)) {
                    return new ITermITE(iFormula, IExpression$.MODULE$.i(0), IExpression$.MODULE$.i(1));
                }
            }
        }
        if (expr != null) {
            IExpression expr4 = (IExpression)expr._1();
            throw new Parser2InputAbsy.TranslationException(new StringBuilder(21).append("Expected a term, not ").append(expr4).toString());
        }
        throw new MatchError(null);
    }

    public ITerm asTerm(Tuple2<IExpression, SMTTypes.SMTType> expr, SMTTypes.SMTType expectedSort) {
        if (expr != null) {
            IExpression expr2 = (IExpression)expr._1();
            SMTTypes.SMTType sMTType = (SMTTypes.SMTType)expr._2();
            if (expr2 instanceof ITerm) {
                ITerm iTerm = (ITerm)expr2;
                SMTTypes.SMTType sMTType2 = expectedSort;
                if (!(sMTType2 != null ? !sMTType2.equals(sMTType) : sMTType != null)) {
                    return iTerm;
                }
            }
        }
        if (expr != null) {
            IExpression expr3 = (IExpression)expr._1();
            throw new Parser2InputAbsy.TranslationException(new StringBuilder(30).append("Expected a term of type ").append(SMTLineariser$.MODULE$.smtTypeAsString(expectedSort)).append(", not ").append(expr3).toString());
        }
        throw new MatchError(null);
    }

    private SMTParsingUtils$() {
    }
}

