/*
 * Decompiled with CFR 0.152.
 */
package ap.proof.certificates;

import ap.proof.certificates.AlphaInference;
import ap.proof.certificates.BranchInference;
import ap.proof.certificates.BranchInferenceCertificate$;
import ap.proof.certificates.BranchInferenceCollection;
import ap.proof.certificates.CertArithLiteral;
import ap.proof.certificates.CertCompoundFormula;
import ap.proof.certificates.CertEquation;
import ap.proof.certificates.CertFormula;
import ap.proof.certificates.CertFormula$;
import ap.proof.certificates.CertInequality;
import ap.proof.certificates.CertNegEquation;
import ap.proof.certificates.Certificate;
import ap.proof.certificates.MacroInference;
import ap.proof.certificates.PartialCertificate;
import ap.proof.certificates.PartialCertificateInference;
import ap.proof.certificates.SimpInference;
import ap.terfor.TermOrder;
import ap.terfor.conjunctions.Conjunction;
import ap.terfor.linearcombination.LinearCombination;
import ap.util.Debug$;
import ap.util.Debug$AC_CERTIFICATES$;
import ap.util.Seqs$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SetOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashSet;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

public final class BranchInferenceCollection$ {
    public static final BranchInferenceCollection$ MODULE$ = new BranchInferenceCollection$();
    private static final Debug$AC_CERTIFICATES$ AC = Debug$AC_CERTIFICATES$.MODULE$;
    private static final BranchInferenceCollection EMPTY = new BranchInferenceCollection((List<BranchInference>)Nil$.MODULE$);

    private Debug$AC_CERTIFICATES$ AC() {
        return AC;
    }

    public BranchInferenceCollection EMPTY() {
        return EMPTY;
    }

    public BranchInferenceCollection apply(Iterable<Conjunction> initialFors) {
        return this.applyCert((Iterable<CertFormula>)((Iterable)initialFors.map((Function1 & Serializable)c -> CertFormula$.MODULE$.apply((Conjunction)c))));
    }

    public BranchInferenceCollection applyCert(Iterable<CertFormula> initialFors) {
        if (initialFors.isEmpty()) {
            return this.EMPTY();
        }
        return this.apply((List<BranchInference>)((IterableOnceOps)initialFors.flatMap((Function1 & Serializable)f -> (Seq)MODULE$.genDefaultInferences((CertFormula)f).map((Function1 & Serializable)inf -> inf))).toList());
    }

    public BranchInferenceCollection apply(List<BranchInference> inferences) {
        return new BranchInferenceCollection(inferences);
    }

    public Seq<BranchInference> genDefaultInferences(CertFormula f) {
        Seq<BranchInference> alphaInfs = this.genAlphaInferences(f);
        Seq<BranchInference> directSimpInfs = this.genSimpInferences(f);
        Seq indirectSimpInfs = (Seq)alphaInfs.flatMap((Function1 & Serializable)inf -> (Set)inf.providedFormulas().flatMap((Function1 & Serializable)f -> (Seq)MODULE$.genSimpInferences((CertFormula)f).map((Function1 & Serializable)i -> i)));
        return (Seq)((IterableOps)alphaInfs.$plus$plus(directSimpInfs)).$plus$plus((IterableOnce)indirectSimpInfs);
    }

    private Seq<BranchInference> genAlphaInferences(CertFormula cf) {
        CertCompoundFormula certCompoundFormula;
        Conjunction f;
        if (cf instanceof CertCompoundFormula && (f = (certCompoundFormula = (CertCompoundFormula)cf).f()).size() > 1 && f.quans().isEmpty()) {
            return new .colon.colon((Object)new AlphaInference(certCompoundFormula, (Set<CertFormula>)((Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)).$plus$plus((IterableOnce)f.iterator().map((Function1 & Serializable)l -> CertFormula$.MODULE$.apply((Conjunction)l))))), (List)Nil$.MODULE$);
        }
        return Nil$.MODULE$;
    }

    private Seq<BranchInference> genSimpInferences(CertFormula f) {
        if (f.isTrue() || f.isFalse()) {
            return Nil$.MODULE$;
        }
        if (f instanceof CertInequality) {
            LinearCombination simplified;
            CertInequality certInequality = (CertInequality)f;
            LinearCombination lhs = certInequality._lhs();
            LinearCombination linearCombination = simplified = lhs.makePrimitive();
            if (linearCombination != null && ((Object)linearCombination).equals(lhs)) {
                return Nil$.MODULE$;
            }
            return new .colon.colon((Object)new SimpInference(certInequality, new CertInequality(simplified), certInequality.order()), (List)Nil$.MODULE$);
        }
        if (f instanceof CertArithLiteral) {
            LinearCombination simplified;
            CertArithLiteral certArithLiteral = (CertArithLiteral)f;
            Debug$.MODULE$.assertInt(this.AC(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> certArithLiteral instanceof CertEquation || certArithLiteral instanceof CertNegEquation);
            LinearCombination linearCombination = simplified = certArithLiteral.lhs().makePrimitiveAndPositive();
            LinearCombination linearCombination2 = certArithLiteral.lhs();
            if (!(linearCombination != null ? !((Object)linearCombination).equals(linearCombination2) : linearCombination2 != null)) {
                return Nil$.MODULE$;
            }
            return new .colon.colon((Object)new SimpInference(certArithLiteral, certArithLiteral.update(simplified), certArithLiteral.order()), (List)Nil$.MODULE$);
        }
        return Nil$.MODULE$;
    }

    public Certificate ap$proof$certificates$BranchInferenceCollection$$getCertificateHelp(List<BranchInference> infs, Certificate child, TermOrder order) {
        if (infs.isEmpty()) {
            return child;
        }
        HashSet requiredFormulas = new HashSet();
        HashSet containedConstants = new HashSet();
        requiredFormulas.$plus$plus$eq(child.assumedFormulas());
        containedConstants.$plus$plus$eq(child.constants());
        Nil$ selectedInferences = Nil$.MODULE$;
        ObjectRef remInferences = ObjectRef.create(infs);
        while (!((List)remInferences.elem).isEmpty()) {
            BranchInference inf = (BranchInference)((List)remInferences.elem).head();
            remInferences.elem = (List)((List)remInferences.elem).tail();
            if (Seqs$.MODULE$.disjoint(inf.providedFormulas(), requiredFormulas) && Seqs$.MODULE$.disjoint(inf.localBoundConstants(), containedConstants)) continue;
            if (inf instanceof PartialCertificateInference) {
                PartialCertificate pCert = ((PartialCertificateInference)inf).pCert();
                Certificate infCert = BranchInferenceCertificate$.MODULE$.prepend((Seq<BranchInference>)selectedInferences, child, order);
                Certificate newChild = pCert.apply((Seq<Certificate>)new .colon.colon((Object)infCert, (List)Nil$.MODULE$));
                return this.ap$proof$certificates$BranchInferenceCollection$$getCertificateHelp((List<BranchInference>)((List)remInferences.elem), newChild, order);
            }
            if (inf instanceof MacroInference) {
                ((MacroInference)inf).expand().foreach((Function1 & Serializable)n -> {
                    remInferences.elem = ((List)remInferences.elem).$colon$colon((Object)n);
                    return BoxedUnit.UNIT;
                });
                continue;
            }
            requiredFormulas.$minus$minus$eq(inf.providedFormulas());
            requiredFormulas.$plus$plus$eq(inf.assumedFormulas());
            containedConstants.$plus$plus$eq(inf.constants());
            containedConstants.$minus$minus$eq(inf.localBoundConstants());
            selectedInferences = selectedInferences.$colon$colon((Object)inf);
        }
        return BranchInferenceCertificate$.MODULE$.prepend((Seq<BranchInference>)selectedInferences, child, order);
    }

    private BranchInferenceCollection$() {
    }
}

