/*
 * Decompiled with CFR 0.152.
 */
package ap.proof.certificates;

import ap.proof.certificates.CertCompoundFormula;
import ap.proof.certificates.CertEquation;
import ap.proof.certificates.CertFormula;
import ap.proof.certificates.CertInequality;
import ap.proof.certificates.CertNegEquation;
import ap.proof.certificates.CertPredLiteral;
import ap.terfor.TermOrder;
import ap.terfor.conjunctions.Conjunction;
import ap.terfor.conjunctions.Conjunction$;
import ap.terfor.linearcombination.LinearCombination;
import ap.terfor.preds.Atom;
import ap.util.Debug$;
import ap.util.Debug$AC_CERTIFICATES$;
import ap.util.Seqs$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Some;
import scala.Tuple2;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

public final class CertFormula$ {
    public static final CertFormula$ MODULE$ = new CertFormula$();
    private static final Debug$AC_CERTIFICATES$ AC = Debug$AC_CERTIFICATES$.MODULE$;

    private Debug$AC_CERTIFICATES$ AC() {
        return AC;
    }

    public CertFormula apply(Conjunction f) {
        if (!f.isTrue() && !f.isFalse() && f.isLiteral()) {
            if (f.arithConj().positiveEqs().size() == 1) {
                return new CertEquation(f.arithConj().positiveEqs().apply(0));
            }
            if (f.arithConj().negativeEqs().size() == 1) {
                return new CertNegEquation(f.arithConj().negativeEqs().apply(0));
            }
            if (f.arithConj().inEqs().size() == 1) {
                return new CertInequality(f.arithConj().inEqs().apply(0));
            }
            if (f.predConj().positiveLits().size() == 1) {
                return new CertPredLiteral(false, (Atom)f.predConj().positiveLits().apply(0));
            }
            Debug$.MODULE$.assertInt(this.AC(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> f.predConj().negativeLits().size() == 1);
            return new CertPredLiteral(true, (Atom)f.predConj().negativeLits().apply(0));
        }
        return new CertCompoundFormula(f);
    }

    public Ordering<CertFormula> certFormulaOrdering(TermOrder order) {
        return new Ordering<CertFormula>(order){
            private final Ordering<Conjunction> co;
            private final TermOrder order$1;

            public Some tryCompare(Object x, Object y) {
                return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.max$((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.min$((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<CertFormula> reverse() {
                return Ordering.reverse$((Ordering)this);
            }

            public boolean isReverseOf(Ordering<?> other) {
                return Ordering.isReverseOf$((Ordering)this, other);
            }

            public <U> Ordering<U> on(Function1<U, CertFormula> f) {
                return Ordering.on$((Ordering)this, f);
            }

            public Ordering<CertFormula> orElse(Ordering<CertFormula> other) {
                return Ordering.orElse$((Ordering)this, other);
            }

            public <S> Ordering<CertFormula> orElseBy(Function1<CertFormula, S> f, Ordering<S> ord) {
                return Ordering.orElseBy$((Ordering)this, f, ord);
            }

            public Ordering.OrderingOps mkOrderingOps(Object lhs) {
                return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
            }

            private Ordering<Conjunction> co() {
                return this.co;
            }

            public int compare(CertFormula a, CertFormula b) {
                Tuple2 tuple2 = new Tuple2((Object)a, (Object)b);
                if (a instanceof CertEquation) {
                    LinearCombination aLC = ((CertEquation)a)._lhs();
                    if (b instanceof CertEquation) {
                        LinearCombination bLC = ((CertEquation)b)._lhs();
                        return this.order$1.compare(aLC, bLC);
                    }
                }
                if (a instanceof CertNegEquation) {
                    LinearCombination aLC = ((CertNegEquation)a)._lhs();
                    if (b instanceof CertNegEquation) {
                        LinearCombination bLC = ((CertNegEquation)b)._lhs();
                        return this.order$1.compare(aLC, bLC);
                    }
                }
                if (a instanceof CertInequality) {
                    LinearCombination aLC = ((CertInequality)a)._lhs();
                    if (b instanceof CertInequality) {
                        LinearCombination bLC = ((CertInequality)b)._lhs();
                        return this.order$1.compare(aLC, bLC);
                    }
                }
                if (a instanceof CertPredLiteral) {
                    CertPredLiteral certPredLiteral = (CertPredLiteral)a;
                    boolean aNeg = certPredLiteral.negated();
                    Atom aAtom = certPredLiteral.atom();
                    if (b instanceof CertPredLiteral) {
                        CertPredLiteral certPredLiteral2 = (CertPredLiteral)b;
                        boolean bNeg = certPredLiteral2.negated();
                        Atom bAtom = certPredLiteral2.atom();
                        return Seqs$.MODULE$.lexCombineInts((aNeg ? 0 : 1) - (bNeg ? 0 : 1), (Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> $this.order$1.compare(aAtom, bAtom));
                    }
                }
                if (a instanceof CertCompoundFormula) {
                    Conjunction aFor = ((CertCompoundFormula)a).f();
                    if (b instanceof CertCompoundFormula) {
                        Conjunction bFor = ((CertCompoundFormula)b).f();
                        return this.co().compare((Object)aFor, (Object)bFor);
                    }
                }
                if (a instanceof CertEquation) {
                    return -1;
                }
                if (a instanceof CertNegEquation && b instanceof CertEquation) {
                    return 1;
                }
                if (a instanceof CertNegEquation) {
                    return -1;
                }
                if (a instanceof CertInequality && (b instanceof CertEquation ? true : b instanceof CertNegEquation)) {
                    return 1;
                }
                if (a instanceof CertInequality) {
                    return -1;
                }
                if (tuple2 != null && a instanceof CertPredLiteral && b instanceof CertCompoundFormula) {
                    return -1;
                }
                if (tuple2 != null && a instanceof CertPredLiteral) {
                    return 1;
                }
                if (tuple2 != null && a instanceof CertCompoundFormula) {
                    return 1;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.order$1 = order$1;
                PartialOrdering.$init$((PartialOrdering)this);
                Ordering.$init$((Ordering)this);
                this.co = Conjunction$.MODULE$.conjOrdering(order$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$compare$1(ap.proof.certificates.CertFormula$$anon$1 ap.terfor.preds.Atom ap.terfor.preds.Atom )}, serializedLambda);
            }
        };
    }

    private CertFormula$() {
    }
}

