package com.poiji.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Created by hakan on 16/03/2018
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
@Documented
public @interface ExcelCellName {

    int ABSENT_ORDER = -1;

    /**
     * Specifies the column name where the corresponding value is mapped from the excel data
     *
     * @return column name
     */
    String value();

    /**
     * Specifies 0-based column order in saved file.
     *
     * @return column order
     */
    int order() default ABSENT_ORDER;

    /**
     * Delimiter for column multiname.
     * <p>
     * Example: @ExcelCellName(value = "id,identifier", columnNameDelimiter = ",")
     * reading: column with name 'id' will be mapped into field, or if no column 'id',
     * then column 'identifier' will be mapped into field.
     * writing: field will be saved into column 'id'
     *
     * @return delimiter for column multiname.
     */
    String columnNameDelimiter() default "";

    /**
     * Set true if this header is mandatory, otherwise false
     */
    boolean mandatory() default false;
}
