/*
 * Decompiled with CFR 0.152.
 */
package io.github.vantiv.sdk;

import io.github.vantiv.sdk.CnpBatchException;
import io.github.vantiv.sdk.CnpBatchFileResponse;
import io.github.vantiv.sdk.CnpBatchRequest;
import io.github.vantiv.sdk.Communication;
import io.github.vantiv.sdk.Configuration;
import io.github.vantiv.sdk.PgpHelper;
import io.github.vantiv.sdk.generate.Authentication;
import io.github.vantiv.sdk.generate.CnpRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.bouncycastle.openpgp.PGPException;

public class CnpBatchFileRequest {
    private JAXBContext jc;
    private Properties properties;
    private Communication communication;
    private List<CnpBatchRequest> cnpBatchRequestList;
    private String requestFileName;
    private File requestFile;
    private File responseFile;
    private File tempBatchRequestFile;
    private String requestId;
    private Marshaller marshaller;
    private Configuration config = null;
    protected int maxAllowedTransactionsPerFile;
    private final int CNP_LIMIT_MAX_ALLOWED_TNXS_PER_FILE = 500000;

    public CnpBatchFileRequest(String requestFileName) {
        this.initializeMembers(requestFileName);
    }

    public CnpBatchFileRequest(String requestFileName, Properties properties) {
        this.initializeMembers(requestFileName, properties);
    }

    public CnpBatchFileRequest(String requestFileName, Configuration config) {
        this.config = config;
        this.initializeMembers(requestFileName, null);
    }

    private void initializeMembers(String requestFileName) {
        this.initializeMembers(requestFileName, null);
    }

    public void initializeMembers(String requestFileName, Properties in_properties) throws CnpBatchException {
        try {
            this.jc = JAXBContext.newInstance((String)"io.github.vantiv.sdk.generate");
            if (this.config == null) {
                this.config = new Configuration();
            }
            this.communication = new Communication();
            this.cnpBatchRequestList = new ArrayList<CnpBatchRequest>();
            this.requestFileName = requestFileName;
            this.marshaller = this.jc.createMarshaller();
            this.marshaller.setProperty("jaxb.fragment", (Object)true);
            this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
            if (in_properties == null || in_properties.isEmpty()) {
                this.properties = new Properties();
                this.properties.load(new FileInputStream(this.config.location()));
            } else {
                this.fillInMissingFieldsFromConfig(in_properties);
                this.properties = in_properties;
            }
            this.maxAllowedTransactionsPerFile = Integer.parseInt(this.properties.getProperty("maxAllowedTransactionsPerFile", "1000"));
            if (this.maxAllowedTransactionsPerFile > 500000) {
                throw new CnpBatchException("maxAllowedTransactionsPerFile property value cannot exceed " + String.valueOf(500000));
            }
            this.requestFile = this.getFileToWrite("batchRequestFolder");
            this.responseFile = this.getFileToWrite("batchResponseFolder");
        }
        catch (FileNotFoundException e) {
            throw new CnpBatchException("Configuration file not found. If you are not using the .cnp_SDK_config.properties file, please use the " + CnpBatchFileRequest.class.getSimpleName() + "(String, Properties) constructor. If you are using .cnp_SDK_config.properties, you can generate one using: java -jar cnp-sdk-for-java-x.xx.jar", e);
        }
        catch (IOException e) {
            throw new CnpBatchException("Configuration file could not be loaded.  Check to see if the current user has permission to access the file", e);
        }
        catch (JAXBException e) {
            throw new CnpBatchException("Unable to load jaxb dependencies.  Perhaps a classpath issue?", (Exception)((Object)e));
        }
    }

    protected void setCommunication(Communication communication) {
        this.communication = communication;
    }

    public Properties getConfig() {
        return this.properties;
    }

    public CnpBatchRequest createBatch(String merchantId) throws CnpBatchException {
        CnpBatchRequest cnpBatchRequest = new CnpBatchRequest(merchantId, this);
        this.cnpBatchRequestList.add(cnpBatchRequest);
        return cnpBatchRequest;
    }

    public void generateRequestFile() throws CnpBatchException {
        FileOutputStream cnpReqWriter = null;
        try {
            CnpRequest cnpRequest = this.buildCnpRequest();
            StringWriter sw = new StringWriter();
            try {
                Marshaller marshaller = this.jc.createMarshaller();
                marshaller.marshal((Object)cnpRequest, (Writer)sw);
            }
            catch (JAXBException e) {
                throw new CnpBatchException("Unable to load jaxb dependencies.  Perhaps a classpath issue?");
            }
            String xmlRequest = sw.toString();
            xmlRequest = xmlRequest.replace("</cnpRequest>", " ");
            cnpReqWriter = new FileOutputStream(this.requestFile);
            FileInputStream fis = new FileInputStream(this.tempBatchRequestFile);
            byte[] readData = new byte[1024];
            ((OutputStream)cnpReqWriter).write(xmlRequest.getBytes());
            int i = fis.read(readData);
            while (i != -1) {
                ((OutputStream)cnpReqWriter).write(readData, 0, i);
                i = fis.read(readData);
            }
            ((OutputStream)cnpReqWriter).write("</cnpRequest>\n".getBytes());
            fis.close();
            this.tempBatchRequestFile.delete();
            ((OutputStream)cnpReqWriter).close();
        }
        catch (IOException e) {
            throw new CnpBatchException("Error while creating a batch request file. Check to see if the current user has permission to read and write to " + this.properties.getProperty("batchRequestFolder"), e);
        }
    }

    public File getFile() {
        return this.requestFile;
    }

    public int getMaxAllowedTransactionsPerFile() {
        return this.maxAllowedTransactionsPerFile;
    }

    void fillInMissingFieldsFromConfig(Properties config) throws CnpBatchException {
        Properties localConfig = new Properties();
        boolean propertiesReadFromFile = false;
        try {
            String[] allProperties;
            for (String prop : allProperties = new String[]{"username", "password", "proxyHost", "proxyPort", "batchHost", "batchPort", "batchTcpTimeout", "batchUseSSL", "maxAllowedTransactionsPerFile", "maxTransactionsPerBatch", "batchRequestFolder", "batchResponseFolder", "sftpUsername", "sftpPassword", "sftpTimeout", "merchantId", "printxml", "useEncryption", "VantivPublicKeyPath", "PrivateKeyPath", "PublicKeyPath", "gpgPassphrase", "deleteBatchFiles"}) {
                if (config.getProperty(prop) != null) continue;
                if (this.properties != null && this.properties.get(prop) != null) {
                    config.setProperty(prop, this.properties.getProperty(prop));
                    continue;
                }
                if (!propertiesReadFromFile) {
                    localConfig.load(new FileInputStream(new Configuration().location()));
                    propertiesReadFromFile = true;
                }
                if (localConfig.getProperty(prop) == null) continue;
                config.setProperty(prop, localConfig.getProperty(prop));
            }
        }
        catch (FileNotFoundException e) {
            throw new CnpBatchException("File .cnp_SDK_config.properties was not found. Please run the Setup.java application to create the file at location " + new Configuration().location(), e);
        }
        catch (IOException e) {
            throw new CnpBatchException("There was an exception while reading the .cnp_SDK_config.properties file.", e);
        }
    }

    public int getNumberOfBatches() {
        return this.cnpBatchRequestList.size();
    }

    public int getNumberOfTransactionInFile() {
        int totalNumberOfTransactions = 0;
        for (int i = 0; i < this.getNumberOfBatches(); ++i) {
            CnpBatchRequest lbr = this.cnpBatchRequestList.get(i);
            totalNumberOfTransactions += lbr.getNumberOfTransactions();
        }
        return totalNumberOfTransactions;
    }

    public CnpBatchFileResponse sendToCnpSFTP() throws CnpBatchException {
        return this.sendToCnpSFTP(false);
    }

    public CnpBatchFileResponse sendToCnpSFTP(boolean useExistingFile) throws CnpBatchException {
        this.sendOnlyToCnpSFTP(useExistingFile);
        CnpBatchFileResponse retObj = this.retrieveOnlyFromCnpSFTP();
        return retObj;
    }

    public void sendOnlyToCnpSFTP() throws CnpBatchException {
        this.sendOnlyToCnpSFTP(false);
    }

    public void sendOnlyToCnpSFTP(boolean useExistingFile) throws CnpBatchException {
        try {
            if (!useExistingFile) {
                this.prepareForDelivery();
            }
            this.communication.sendCnpRequestFileToSFTP(this.requestFile, this.properties);
            this.checkDeleteBatchRequestFiles();
        }
        catch (IOException e) {
            throw new CnpBatchException("There was an exception while creating the Cnp Request file. Check to see if the current user has permission to read and write to " + this.properties.getProperty("batchRequestFolder"), e);
        }
    }

    private void checkDeleteBatchRequestFiles() {
        boolean deleteBatchFiles = "true".equalsIgnoreCase(this.properties.getProperty("deleteBatchFiles"));
        if (deleteBatchFiles) {
            this.requestFile.delete();
        }
    }

    public CnpBatchFileResponse retrieveOnlyFromCnpSFTP() throws CnpBatchException {
        try {
            boolean useEncryption = "true".equalsIgnoreCase(this.properties.getProperty("useEncryption"));
            File requestFileToFetch = this.requestFile;
            File responseFileToRecieve = this.responseFile;
            if (useEncryption) {
                requestFileToFetch = new File(this.requestFile.getAbsolutePath());
                responseFileToRecieve = new File(this.responseFile.getAbsolutePath() + ".encrypted");
            }
            this.communication.receiveCnpRequestResponseFileFromSFTP(requestFileToFetch, responseFileToRecieve, this.properties);
            if (useEncryption) {
                this.decryptResponseFile();
            }
            CnpBatchFileResponse retObj = new CnpBatchFileResponse(this.responseFile);
            this.checkDeleteBatchResponseFiles(responseFileToRecieve);
            return retObj;
        }
        catch (IOException e) {
            throw new CnpBatchException("There was an exception while creating the Cnp Request file. Check to see if the current user has permission to read and write to " + this.properties.getProperty("batchRequestFolder"), e);
        }
    }

    private void decryptResponseFile() {
        String encResponseFilename = this.responseFile.getAbsolutePath() + ".encrypted";
        String passwd = this.properties.getProperty("gpgPassphrase");
        String privateKeyPath = this.properties.getProperty("PrivateKeyPath");
        try {
            PgpHelper.decrypt(encResponseFilename, this.responseFile.getAbsolutePath(), privateKeyPath, passwd);
        }
        catch (PGPException pgpe) {
            throw new CnpBatchException("Error while decrypting response file. Check if " + privateKeyPath + " contains correct private key.and that the gpgPassphrase provided in config file is correct.", (Exception)((Object)pgpe));
        }
        catch (IOException ioe) {
            throw new CnpBatchException("Error in decrypting response file. Check to see if the current user has permission to read and write to" + this.properties.getProperty("batchRequestFolder") + ".Also check if " + privateKeyPath + " contains the private key.");
        }
    }

    private void checkDeleteBatchResponseFiles(File fileToBeDeleted) {
        boolean deleteBatchFiles = "true".equalsIgnoreCase(this.properties.getProperty("deleteBatchFiles"));
        if (deleteBatchFiles) {
            this.responseFile.delete();
            fileToBeDeleted.delete();
        }
    }

    public void prepareForDelivery() {
        if ("true".equalsIgnoreCase(this.properties.getProperty("useEncryption"))) {
            this.prepareForEncryptedDelivery();
        } else {
            try {
                String writeFolderPath = this.properties.getProperty("batchRequestFolder");
                this.tempBatchRequestFile = new File(writeFolderPath + "/tmp/tempBatchFileTesting");
                FileOutputStream batchReqWriter = new FileOutputStream(this.tempBatchRequestFile.getAbsoluteFile());
                byte[] readData = new byte[1024];
                for (CnpBatchRequest batchReq : this.cnpBatchRequestList) {
                    batchReq.closeFile();
                    String batchRequestXml = this.buildBatchRequestXml(batchReq);
                    batchRequestXml = batchRequestXml.replaceFirst("/>", ">");
                    FileInputStream fis = new FileInputStream(batchReq.getFile());
                    ((OutputStream)batchReqWriter).write(batchRequestXml.getBytes());
                    int i = fis.read(readData);
                    while (i != -1) {
                        ((OutputStream)batchReqWriter).write(readData, 0, i);
                        i = fis.read(readData);
                    }
                    ((OutputStream)batchReqWriter).write("</batchRequest>\n".getBytes());
                    fis.close();
                    batchReq.getFile().delete();
                }
                ((OutputStream)batchReqWriter).close();
                this.generateRequestFile();
                File tmpFile = new File(writeFolderPath + "/tmp");
                if (tmpFile.exists()) {
                    tmpFile.delete();
                }
            }
            catch (IOException ioe) {
                throw new CnpBatchException("There was an exception while creating the Cnp Request file. Check to see if the current user has permission to read and write to " + this.properties.getProperty("batchRequestFolder"), ioe);
            }
        }
    }

    private void prepareForEncryptedDelivery() {
        String privateKeyPath = this.properties.getProperty("PrivateKeyPath");
        String gpgPassphrase = this.properties.getProperty("gpgPassphrase");
        String vantivPubKeyPath = this.properties.getProperty("VantivPublicKeyPath");
        String cnpRequestXml = this.buildCnpRequestXml();
        try {
            cnpRequestXml = cnpRequestXml.replace("</cnpRequest>", " ");
            OutputStream encryptedCnpRequestWriter = PgpHelper.encryptionStream(this.requestFile.getAbsolutePath(), vantivPubKeyPath);
            encryptedCnpRequestWriter.write(cnpRequestXml.getBytes());
            byte[] clearData = new byte[0x200000];
            for (CnpBatchRequest batchReq : this.cnpBatchRequestList) {
                int len;
                batchReq.closeFile();
                String batchRequestXml = this.buildBatchRequestXml(batchReq);
                batchRequestXml = batchRequestXml.replaceFirst("/>", ">");
                encryptedCnpRequestWriter.write(batchRequestXml.getBytes());
                InputStream decryptionStream = PgpHelper.decryptionStream(batchReq.getFile().getAbsolutePath(), privateKeyPath, gpgPassphrase);
                while ((len = decryptionStream.read(clearData)) > 0) {
                    encryptedCnpRequestWriter.write(clearData, 0, len);
                }
                decryptionStream.close();
                encryptedCnpRequestWriter.write("</batchRequest>\n".getBytes());
                batchReq.getFile().delete();
            }
            encryptedCnpRequestWriter.write("</cnpRequest>\n".getBytes());
            encryptedCnpRequestWriter.close();
        }
        catch (IOException e) {
            throw new CnpBatchException("There was an exception while creating the Cnp Request file. Check to see if the current user has permission to read and write to " + this.properties.getProperty("batchRequestFolder"), e);
        }
        catch (PGPException pgpe) {
            throw new CnpBatchException("Error in creating encrypted request file. Check if " + privateKeyPath + " contains correct private key.and that the gpgPassphrase provided in config file is correct.\nAlso check if " + vantivPubKeyPath + " contains correct public key.", (Exception)((Object)pgpe));
        }
    }

    private String buildBatchRequestXml(CnpBatchRequest batchRequest) {
        try {
            StringWriter sw = new StringWriter();
            this.marshaller.marshal((Object)batchRequest.getBatchRequest(), (Writer)sw);
            return sw.toString();
        }
        catch (JAXBException e) {
            throw new CnpBatchException("There was an exception while marshalling BatchRequest or CnpRequest objects.", (Exception)((Object)e));
        }
    }

    void setResponseFile(File inFile) {
        this.responseFile = inFile;
    }

    void setId(String id) {
        this.requestId = id;
    }

    private String buildCnpRequestXml() {
        CnpRequest cnpRequest = this.buildCnpRequest();
        StringWriter sw = new StringWriter();
        try {
            Marshaller marshaller = this.jc.createMarshaller();
            marshaller.marshal((Object)cnpRequest, (Writer)sw);
        }
        catch (JAXBException e) {
            throw new CnpBatchException("Unable to load jaxb dependencies.  Perhaps a classpath issue?");
        }
        return sw.toString();
    }

    private CnpRequest buildCnpRequest() {
        Authentication authentication = new Authentication();
        authentication.setPassword(this.properties.getProperty("password"));
        authentication.setUser(this.properties.getProperty("username"));
        CnpRequest cnpRequest = new CnpRequest();
        if (this.requestId != null && this.requestId.length() != 0) {
            cnpRequest.setId(this.requestId);
        }
        cnpRequest.setAuthentication(authentication);
        cnpRequest.setVersion("12.19");
        BigInteger numOfBatches = BigInteger.valueOf(this.cnpBatchRequestList.size());
        cnpRequest.setNumBatchRequests(numOfBatches);
        return cnpRequest;
    }

    File getFileToWrite(String locationKey) {
        String fileName = this.requestFileName;
        String writeFolderPath = this.properties.getProperty(locationKey);
        File fileToReturn = new File(writeFolderPath, fileName);
        if (!fileToReturn.getParentFile().exists()) {
            fileToReturn.getParentFile().mkdirs();
        }
        return fileToReturn;
    }

    public boolean isEmpty() {
        return this.getNumberOfTransactionInFile() == 0;
    }

    public boolean isFull() {
        return this.getNumberOfTransactionInFile() == this.maxAllowedTransactionsPerFile;
    }
}

