/*
 * Decompiled with CFR 0.152.
 */
package io.github.vantiv.sdk;

import io.github.vantiv.sdk.CnpBatchBatchFullException;
import io.github.vantiv.sdk.CnpBatchException;
import io.github.vantiv.sdk.CnpBatchFileFullException;
import io.github.vantiv.sdk.CnpBatchFileRequest;
import io.github.vantiv.sdk.PgpHelper;
import io.github.vantiv.sdk.TransactionCodeEnum;
import io.github.vantiv.sdk.generate.AccountUpdate;
import io.github.vantiv.sdk.generate.Activate;
import io.github.vantiv.sdk.generate.AuthReversal;
import io.github.vantiv.sdk.generate.Authorization;
import io.github.vantiv.sdk.generate.BalanceInquiry;
import io.github.vantiv.sdk.generate.BatchRequest;
import io.github.vantiv.sdk.generate.CancelSubscription;
import io.github.vantiv.sdk.generate.Capture;
import io.github.vantiv.sdk.generate.CaptureGivenAuth;
import io.github.vantiv.sdk.generate.CnpTransactionInterface;
import io.github.vantiv.sdk.generate.CreatePlan;
import io.github.vantiv.sdk.generate.Credit;
import io.github.vantiv.sdk.generate.CustomerCredit;
import io.github.vantiv.sdk.generate.CustomerDebit;
import io.github.vantiv.sdk.generate.Deactivate;
import io.github.vantiv.sdk.generate.DepositTransactionReversal;
import io.github.vantiv.sdk.generate.EcheckCredit;
import io.github.vantiv.sdk.generate.EcheckPreNoteCredit;
import io.github.vantiv.sdk.generate.EcheckPreNoteSale;
import io.github.vantiv.sdk.generate.EcheckRedeposit;
import io.github.vantiv.sdk.generate.EcheckSale;
import io.github.vantiv.sdk.generate.EcheckVerification;
import io.github.vantiv.sdk.generate.FastAccessFunding;
import io.github.vantiv.sdk.generate.ForceCapture;
import io.github.vantiv.sdk.generate.FundingInstructionVoid;
import io.github.vantiv.sdk.generate.GiftCardAuthReversal;
import io.github.vantiv.sdk.generate.GiftCardCapture;
import io.github.vantiv.sdk.generate.GiftCardCredit;
import io.github.vantiv.sdk.generate.Load;
import io.github.vantiv.sdk.generate.ObjectFactory;
import io.github.vantiv.sdk.generate.PayFacCredit;
import io.github.vantiv.sdk.generate.PayFacDebit;
import io.github.vantiv.sdk.generate.PayoutOrgCredit;
import io.github.vantiv.sdk.generate.PayoutOrgDebit;
import io.github.vantiv.sdk.generate.PhysicalCheckCredit;
import io.github.vantiv.sdk.generate.PhysicalCheckDebit;
import io.github.vantiv.sdk.generate.RefundTransactionReversal;
import io.github.vantiv.sdk.generate.RegisterTokenRequestType;
import io.github.vantiv.sdk.generate.ReserveCredit;
import io.github.vantiv.sdk.generate.ReserveDebit;
import io.github.vantiv.sdk.generate.Sale;
import io.github.vantiv.sdk.generate.SubmerchantCredit;
import io.github.vantiv.sdk.generate.SubmerchantDebit;
import io.github.vantiv.sdk.generate.TransactionType;
import io.github.vantiv.sdk.generate.TranslateToLowValueTokenRequestType;
import io.github.vantiv.sdk.generate.Unload;
import io.github.vantiv.sdk.generate.UpdateCardValidationNumOnToken;
import io.github.vantiv.sdk.generate.UpdatePlan;
import io.github.vantiv.sdk.generate.UpdateSubscription;
import io.github.vantiv.sdk.generate.VendorCredit;
import io.github.vantiv.sdk.generate.VendorDebit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.bouncycastle.openpgp.PGPException;

public class CnpBatchRequest {
    private BatchRequest batchRequest = new BatchRequest();
    private JAXBContext jc;
    private File file;
    private Marshaller marshaller;
    ObjectFactory objFac;
    TransactionType txn;
    String filePath;
    OutputStream osWrttxn;
    int numOfTxn;
    private final int maxTransactionsPerBatch;
    protected int cnpLimit_maxTransactionsPerBatch = 100000;
    private final CnpBatchFileRequest lbfr;

    CnpBatchRequest(String merchantId, CnpBatchFileRequest lbfr) throws CnpBatchException {
        this.batchRequest.setMerchantId(merchantId);
        this.batchRequest.setMerchantSdk("Java;12.19.0");
        this.objFac = new ObjectFactory();
        this.lbfr = lbfr;
        File tmpFile = new File(lbfr.getConfig().getProperty("batchRequestFolder") + "/tmp");
        if (!tmpFile.exists()) {
            tmpFile.mkdir();
        }
        String dateString = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS").format(new Date());
        this.filePath = new String(lbfr.getConfig().getProperty("batchRequestFolder") + "/tmp/Transactions" + merchantId + dateString);
        this.numOfTxn = 0;
        try {
            this.jc = JAXBContext.newInstance((String)"io.github.vantiv.sdk.generate");
            this.marshaller = this.jc.createMarshaller();
            this.marshaller.setProperty("jaxb.fragment", (Object)true);
            this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
        }
        catch (JAXBException e) {
            throw new CnpBatchException("Unable to load jaxb dependencies.  Perhaps a classpath issue?", (Exception)((Object)e));
        }
        this.maxTransactionsPerBatch = Integer.parseInt(lbfr.getConfig().getProperty("maxTransactionsPerBatch", "10000"));
        if (this.maxTransactionsPerBatch > this.cnpLimit_maxTransactionsPerBatch) {
            throw new CnpBatchException("maxTransactionsPerBatch property value cannot exceed " + String.valueOf(this.cnpLimit_maxTransactionsPerBatch));
        }
    }

    BatchRequest getBatchRequest() {
        return this.batchRequest;
    }

    public TransactionCodeEnum addTransaction(CnpTransactionInterface transactionType) throws CnpBatchException {
        Object transaction;
        if (this.numOfTxn == 0) {
            Properties properties = this.lbfr.getConfig();
            this.file = new File(this.filePath);
            try {
                this.osWrttxn = "true".equalsIgnoreCase(properties.getProperty("useEncryption")) ? PgpHelper.encryptionStream(this.filePath, properties.getProperty("PublicKeyPath")) : new FileOutputStream(this.file.getAbsolutePath());
            }
            catch (FileNotFoundException e) {
                throw new CnpBatchException("There was an exception while trying to create a Request file. Please check if the folder: " + properties.getProperty("batchRequestFolder") + " has read and write access. ");
            }
            catch (IOException ioe) {
                throw new CnpBatchException("Could not read merchant public key at " + properties.getProperty("PublicKeyPath") + "\nMake sure that the provided public key path is correct", ioe);
            }
            catch (PGPException pgpe) {
                throw new CnpBatchException("There was an error while trying to read merchant public key at " + properties.getProperty("PublicKeyPath") + "\nMake sure that the provided public key path contains a valid public key", (Exception)((Object)pgpe));
            }
        }
        if (this.numOfTxn > 0 && this.batchRequest.getNumAccountUpdates().intValue() != this.numOfTxn && transactionType instanceof AccountUpdate) {
            throw new CnpBatchException("An account update cannot be added to a batch containing transactions other than other AccountUpdates.");
        }
        if (this.numOfTxn > 0 && this.batchRequest.getNumAccountUpdates().intValue() == this.numOfTxn && !(transactionType instanceof AccountUpdate)) {
            throw new CnpBatchException("Transactions that are not AccountUpdates cannot be added to a batch containing AccountUpdates.");
        }
        TransactionCodeEnum batchFileStatus = this.verifyFileThresholds();
        if (batchFileStatus == TransactionCodeEnum.FILEFULL) {
            Exception e = new Exception();
            throw new CnpBatchFileFullException("Batch File is already full -- it has reached the maximum number of transactions allowed per batch file.", e);
        }
        if (batchFileStatus == TransactionCodeEnum.BATCHFULL) {
            Exception e = new Exception();
            throw new CnpBatchBatchFullException("Batch is already full -- it has reached the maximum number of transactions allowed per batch.", e);
        }
        BigInteger numToAdd = new BigInteger("1");
        boolean transactionAdded = false;
        if (transactionType instanceof Sale) {
            this.batchRequest.setNumSales(this.batchRequest.getNumSales().add(BigInteger.valueOf(1L)));
            this.batchRequest.setSaleAmount(this.batchRequest.getSaleAmount().add(BigInteger.valueOf(((Sale)transactionType).getAmount())));
            transaction = this.objFac.createSale((Sale)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof Authorization) {
            this.batchRequest.setNumAuths(this.batchRequest.getNumAuths().add(BigInteger.valueOf(1L)));
            this.batchRequest.setAuthAmount(this.batchRequest.getAuthAmount().add(BigInteger.valueOf(((Authorization)transactionType).getAmount())));
            transaction = this.objFac.createAuthorization((Authorization)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof Credit) {
            this.batchRequest.setNumCredits(this.batchRequest.getNumCredits().add(BigInteger.valueOf(1L)));
            this.batchRequest.setCreditAmount(this.batchRequest.getCreditAmount().add(BigInteger.valueOf(((Credit)transactionType).getAmount())));
            transaction = this.objFac.createCredit((Credit)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof RegisterTokenRequestType) {
            this.batchRequest.setNumTokenRegistrations(this.batchRequest.getNumTokenRegistrations().add(BigInteger.valueOf(1L)));
            transaction = this.objFac.createRegisterTokenRequest((RegisterTokenRequestType)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof CaptureGivenAuth) {
            this.batchRequest.setNumCaptureGivenAuths(this.batchRequest.getNumCaptureGivenAuths().add(BigInteger.valueOf(1L)));
            this.batchRequest.setCaptureGivenAuthAmount(this.batchRequest.getCaptureGivenAuthAmount().add(BigInteger.valueOf(((CaptureGivenAuth)transactionType).getAmount())));
            transaction = this.objFac.createCaptureGivenAuth((CaptureGivenAuth)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof ForceCapture) {
            this.batchRequest.setNumForceCaptures(this.batchRequest.getNumForceCaptures().add(BigInteger.valueOf(1L)));
            this.batchRequest.setForceCaptureAmount(this.batchRequest.getForceCaptureAmount().add(BigInteger.valueOf(((ForceCapture)transactionType).getAmount())));
            transaction = this.objFac.createForceCapture((ForceCapture)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof AuthReversal) {
            this.batchRequest.setNumAuthReversals(this.batchRequest.getNumAuthReversals().add(BigInteger.valueOf(1L)));
            this.batchRequest.setAuthReversalAmount(this.batchRequest.getAuthReversalAmount().add(BigInteger.valueOf(((AuthReversal)transactionType).getAmount())));
            transaction = this.objFac.createAuthReversal((AuthReversal)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof DepositTransactionReversal) {
            this.batchRequest.setNumDepositTransactionReversals(this.batchRequest.getNumDepositTransactionReversals().add(BigInteger.valueOf(1L)));
            this.batchRequest.setDepositTransactionReversalAmount(this.batchRequest.getDepositTransactionReversalAmount().add(BigInteger.valueOf(((DepositTransactionReversal)transactionType).getAmount())));
            transaction = this.objFac.createDepositTransactionReversal((DepositTransactionReversal)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof RefundTransactionReversal) {
            this.batchRequest.setNumRefundTransactionReversals(this.batchRequest.getNumRefundTransactionReversals().add(BigInteger.valueOf(1L)));
            this.batchRequest.setRefundTransactionReversalAmount(this.batchRequest.getRefundTransactionReversalAmount().add(BigInteger.valueOf(((RefundTransactionReversal)transactionType).getAmount())));
            transaction = this.objFac.createRefundTransactionReversal((RefundTransactionReversal)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof Capture) {
            this.batchRequest.setNumCaptures(this.batchRequest.getNumCaptures().add(BigInteger.valueOf(1L)));
            this.batchRequest.setCaptureAmount(this.batchRequest.getCaptureAmount().add(BigInteger.valueOf(((Capture)transactionType).getAmount())));
            transaction = this.objFac.createCapture((Capture)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof EcheckVerification) {
            this.batchRequest.setNumEcheckVerification(this.batchRequest.getNumEcheckVerification().add(BigInteger.valueOf(1L)));
            this.batchRequest.setEcheckVerificationAmount(this.batchRequest.getEcheckVerificationAmount().add(BigInteger.valueOf(((EcheckVerification)transactionType).getAmount())));
            transaction = this.objFac.createEcheckVerification((EcheckVerification)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof EcheckCredit) {
            this.batchRequest.setNumEcheckCredit(this.batchRequest.getNumEcheckCredit().add(BigInteger.valueOf(1L)));
            this.batchRequest.setEcheckCreditAmount(this.batchRequest.getEcheckCreditAmount().add(BigInteger.valueOf(((EcheckCredit)transactionType).getAmount())));
            transaction = this.objFac.createEcheckCredit((EcheckCredit)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof EcheckRedeposit) {
            this.batchRequest.setNumEcheckRedeposit(this.batchRequest.getNumEcheckRedeposit().add(BigInteger.valueOf(1L)));
            transaction = this.objFac.createEcheckRedeposit((EcheckRedeposit)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof EcheckSale) {
            this.batchRequest.setNumEcheckSales(this.batchRequest.getNumEcheckSales().add(BigInteger.valueOf(1L)));
            this.batchRequest.setEcheckSalesAmount(this.batchRequest.getEcheckSalesAmount().add(BigInteger.valueOf(((EcheckSale)transactionType).getAmount())));
            transaction = this.objFac.createEcheckSale((EcheckSale)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof UpdateCardValidationNumOnToken) {
            this.batchRequest.setNumUpdateCardValidationNumOnTokens(this.batchRequest.getNumUpdateCardValidationNumOnTokens().add(BigInteger.valueOf(1L)));
            transaction = this.objFac.createUpdateCardValidationNumOnToken((UpdateCardValidationNumOnToken)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof UpdateSubscription) {
            this.batchRequest.setNumUpdateSubscriptions(this.batchRequest.getNumUpdateSubscriptions().add(BigInteger.valueOf(1L)));
            transaction = this.objFac.createUpdateSubscription((UpdateSubscription)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof CancelSubscription) {
            this.batchRequest.setNumCancelSubscriptions(this.batchRequest.getNumCancelSubscriptions().add(BigInteger.valueOf(1L)));
            transaction = this.objFac.createCancelSubscription((CancelSubscription)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof CreatePlan) {
            this.batchRequest.setNumCreatePlans(this.batchRequest.getNumCreatePlans().add(BigInteger.valueOf(1L)));
            transaction = this.objFac.createCreatePlan((CreatePlan)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof UpdatePlan) {
            this.batchRequest.setNumUpdatePlans(this.batchRequest.getNumUpdatePlans().add(BigInteger.valueOf(1L)));
            transaction = this.objFac.createUpdatePlan((UpdatePlan)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof Activate) {
            this.batchRequest.setNumActivates(this.batchRequest.getNumActivates().add(BigInteger.valueOf(1L)));
            this.batchRequest.setActivateAmount(this.batchRequest.getActivateAmount().add(BigInteger.valueOf(((Activate)transactionType).getAmount())));
            transaction = this.objFac.createActivate((Activate)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof Deactivate) {
            this.batchRequest.setNumDeactivates(this.batchRequest.getNumDeactivates().add(BigInteger.valueOf(1L)));
            transaction = this.objFac.createDeactivate((Deactivate)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof Load) {
            this.batchRequest.setNumLoads(this.batchRequest.getNumLoads().add(BigInteger.valueOf(1L)));
            this.batchRequest.setLoadAmount(this.batchRequest.getLoadAmount().add(BigInteger.valueOf(((Load)transactionType).getAmount())));
            transaction = this.objFac.createLoad((Load)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof Unload) {
            this.batchRequest.setNumUnloads(this.batchRequest.getNumUnloads().add(BigInteger.valueOf(1L)));
            this.batchRequest.setUnloadAmount(this.batchRequest.getUnloadAmount().add(BigInteger.valueOf(((Unload)transactionType).getAmount())));
            transaction = this.objFac.createUnload((Unload)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof BalanceInquiry) {
            this.batchRequest.setNumBalanceInquirys(this.batchRequest.getNumBalanceInquirys().add(BigInteger.valueOf(1L)));
            transaction = this.objFac.createBalanceInquiry((BalanceInquiry)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof EcheckPreNoteSale) {
            this.batchRequest.setNumEcheckPreNoteSale(this.batchRequest.getNumEcheckPreNoteSale().add(BigInteger.valueOf(1L)));
            transaction = this.objFac.createEcheckPreNoteSale((EcheckPreNoteSale)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof EcheckPreNoteCredit) {
            this.batchRequest.setNumEcheckPreNoteCredit(this.batchRequest.getNumEcheckPreNoteCredit().add(BigInteger.valueOf(1L)));
            transaction = this.objFac.createEcheckPreNoteCredit((EcheckPreNoteCredit)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof PayFacCredit) {
            this.batchRequest.setNumPayFacCredit(this.batchRequest.getNumPayFacCredit().add(BigInteger.valueOf(1L)));
            this.batchRequest.setPayFacCreditAmount(this.batchRequest.getPayFacCreditAmount().add(BigInteger.valueOf(((PayFacCredit)transactionType).getAmount())));
            transaction = this.objFac.createPayFacCredit((PayFacCredit)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof SubmerchantCredit) {
            this.batchRequest.setNumSubmerchantCredit(this.batchRequest.getNumSubmerchantCredit().add(BigInteger.valueOf(1L)));
            this.batchRequest.setSubmerchantCreditAmount(this.batchRequest.getSubmerchantCreditAmount().add(BigInteger.valueOf(((SubmerchantCredit)transactionType).getAmount())));
            transaction = this.objFac.createSubmerchantCredit((SubmerchantCredit)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof VendorCredit) {
            this.batchRequest.setNumVendorCredit(this.batchRequest.getNumVendorCredit().add(BigInteger.valueOf(1L)));
            this.batchRequest.setVendorCreditAmount(this.batchRequest.getVendorCreditAmount().add(BigInteger.valueOf(((VendorCredit)transactionType).getAmount())));
            transaction = this.objFac.createVendorCredit((VendorCredit)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof ReserveCredit) {
            this.batchRequest.setNumReserveCredit(this.batchRequest.getNumReserveCredit().add(BigInteger.valueOf(1L)));
            this.batchRequest.setReserveCreditAmount(this.batchRequest.getReserveCreditAmount().add(BigInteger.valueOf(((ReserveCredit)transactionType).getAmount())));
            transaction = this.objFac.createReserveCredit((ReserveCredit)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof PhysicalCheckCredit) {
            this.batchRequest.setNumPhysicalCheckCredit(this.batchRequest.getNumPhysicalCheckCredit().add(BigInteger.valueOf(1L)));
            this.batchRequest.setPhysicalCheckCreditAmount(this.batchRequest.getPhysicalCheckCreditAmount().add(BigInteger.valueOf(((PhysicalCheckCredit)transactionType).getAmount())));
            transaction = this.objFac.createPhysicalCheckCredit((PhysicalCheckCredit)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof PayFacDebit) {
            this.batchRequest.setNumPayFacDebit(this.batchRequest.getNumPayFacDebit().add(BigInteger.valueOf(1L)));
            this.batchRequest.setPayFacDebitAmount(this.batchRequest.getPayFacDebitAmount().add(BigInteger.valueOf(((PayFacDebit)transactionType).getAmount())));
            transaction = this.objFac.createPayFacDebit((PayFacDebit)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof SubmerchantDebit) {
            this.batchRequest.setNumSubmerchantDebit(this.batchRequest.getNumSubmerchantDebit().add(BigInteger.valueOf(1L)));
            this.batchRequest.setSubmerchantDebitAmount(this.batchRequest.getSubmerchantDebitAmount().add(BigInteger.valueOf(((SubmerchantDebit)transactionType).getAmount())));
            transaction = this.objFac.createSubmerchantDebit((SubmerchantDebit)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof VendorDebit) {
            this.batchRequest.setNumVendorDebit(this.batchRequest.getNumVendorDebit().add(BigInteger.valueOf(1L)));
            this.batchRequest.setVendorDebitAmount(this.batchRequest.getVendorDebitAmount().add(BigInteger.valueOf(((VendorDebit)transactionType).getAmount())));
            transaction = this.objFac.createVendorDebit((VendorDebit)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof ReserveDebit) {
            this.batchRequest.setNumReserveDebit(this.batchRequest.getNumReserveDebit().add(BigInteger.valueOf(1L)));
            this.batchRequest.setReserveDebitAmount(this.batchRequest.getReserveDebitAmount().add(BigInteger.valueOf(((ReserveDebit)transactionType).getAmount())));
            transaction = this.objFac.createReserveDebit((ReserveDebit)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof PhysicalCheckDebit) {
            this.batchRequest.setNumPhysicalCheckDebit(this.batchRequest.getNumPhysicalCheckDebit().add(BigInteger.valueOf(1L)));
            this.batchRequest.setPhysicalCheckDebitAmount(this.batchRequest.getPhysicalCheckDebitAmount().add(BigInteger.valueOf(((PhysicalCheckDebit)transactionType).getAmount())));
            transaction = this.objFac.createPhysicalCheckDebit((PhysicalCheckDebit)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof AccountUpdate) {
            this.batchRequest.setNumAccountUpdates(this.batchRequest.getNumAccountUpdates().add(BigInteger.valueOf(1L)));
            transaction = this.objFac.createAccountUpdate((AccountUpdate)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof FundingInstructionVoid) {
            this.batchRequest.setNumFundingInstructionVoid(this.batchRequest.getNumFundingInstructionVoid().add(BigInteger.valueOf(1L)));
            transaction = this.objFac.createFundingInstructionVoid((FundingInstructionVoid)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof GiftCardAuthReversal) {
            this.batchRequest.setNumGiftCardAuthReversals(this.batchRequest.getNumGiftCardAuthReversals().add(BigInteger.valueOf(1L)));
            this.batchRequest.setGiftCardAuthReversalOriginalAmount(this.batchRequest.getGiftCardAuthReversalOriginalAmount().add(BigInteger.valueOf(((GiftCardAuthReversal)transactionType).getOriginalAmount())));
            transaction = this.objFac.createGiftCardAuthReversal((GiftCardAuthReversal)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof GiftCardCapture) {
            this.batchRequest.setNumGiftCardCaptures(this.batchRequest.getNumGiftCardCaptures().add(BigInteger.valueOf(1L)));
            this.batchRequest.setGiftCardCaptureAmount(this.batchRequest.getGiftCardCaptureAmount().add(BigInteger.valueOf(((GiftCardCapture)transactionType).getCaptureAmount())));
            transaction = this.objFac.createGiftCardCapture((GiftCardCapture)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof GiftCardCredit) {
            this.batchRequest.setNumGiftCardCredits(this.batchRequest.getNumGiftCardCredits().add(BigInteger.valueOf(1L)));
            this.batchRequest.setGiftCardCreditAmount(this.batchRequest.getGiftCardCreditAmount().add(BigInteger.valueOf(((GiftCardCredit)transactionType).getCreditAmount())));
            transaction = this.objFac.createGiftCardCredit((GiftCardCredit)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof FastAccessFunding) {
            this.batchRequest.setNumFastAccessFunding(this.batchRequest.getNumFastAccessFunding().add(BigInteger.valueOf(1L)));
            this.batchRequest.setFastAccessFundingAmount(this.batchRequest.getFastAccessFundingAmount().add(BigInteger.valueOf(((FastAccessFunding)transactionType).getAmount())));
            transaction = this.objFac.createFastAccessFunding((FastAccessFunding)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof TranslateToLowValueTokenRequestType) {
            this.batchRequest.setNumTranslateToLowValueTokenRequests(this.batchRequest.getNumTranslateToLowValueTokenRequests().add(BigInteger.valueOf(1L)));
            transaction = this.objFac.createTranslateToLowValueTokenRequest((TranslateToLowValueTokenRequestType)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof CustomerCredit) {
            this.batchRequest.setNumCustomerCredit(this.batchRequest.getNumCustomerCredit().add(BigInteger.valueOf(1L)));
            this.batchRequest.setCustomerCreditAmount(this.batchRequest.getCustomerCreditAmount().add(BigInteger.valueOf(((CustomerCredit)transactionType).getAmount())));
            transaction = this.objFac.createCustomerCredit((CustomerCredit)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof CustomerDebit) {
            this.batchRequest.setNumCustomerDebit(this.batchRequest.getNumCustomerDebit().add(BigInteger.valueOf(1L)));
            this.batchRequest.setCustomerDebitAmount(this.batchRequest.getCustomerDebitAmount().add(BigInteger.valueOf(((CustomerDebit)transactionType).getAmount())));
            transaction = this.objFac.createCustomerDebit((CustomerDebit)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof PayoutOrgCredit) {
            this.batchRequest.setNumPayoutOrgCredit(this.batchRequest.getNumPayoutOrgCredit().add(BigInteger.valueOf(1L)));
            this.batchRequest.setPayoutOrgCreditAmount(this.batchRequest.getPayoutOrgCreditAmount().add(BigInteger.valueOf(((PayoutOrgCredit)transactionType).getAmount())));
            transaction = this.objFac.createPayoutOrgCredit((PayoutOrgCredit)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else if (transactionType instanceof PayoutOrgDebit) {
            this.batchRequest.setNumPayoutOrgDebit(this.batchRequest.getNumPayoutOrgDebit().add(BigInteger.valueOf(1L)));
            this.batchRequest.setPayoutOrgDebitAmount(this.batchRequest.getPayoutOrgDebitAmount().add(BigInteger.valueOf(((PayoutOrgDebit)transactionType).getAmount())));
            transaction = this.objFac.createPayoutOrgDebit((PayoutOrgDebit)transactionType);
            transactionAdded = true;
            ++this.numOfTxn;
        } else {
            transaction = this.objFac.createTransaction(new TransactionType());
        }
        try {
            this.marshaller.marshal(transaction, this.osWrttxn);
        }
        catch (JAXBException e) {
            throw new CnpBatchException("There was an exception while marshalling the transaction object.", (Exception)((Object)e));
        }
        batchFileStatus = this.verifyFileThresholds();
        if (batchFileStatus == TransactionCodeEnum.FILEFULL) {
            return TransactionCodeEnum.FILEFULL;
        }
        if (batchFileStatus == TransactionCodeEnum.BATCHFULL) {
            return TransactionCodeEnum.BATCHFULL;
        }
        if (transactionAdded) {
            return TransactionCodeEnum.SUCCESS;
        }
        return TransactionCodeEnum.FAILURE;
    }

    TransactionCodeEnum verifyFileThresholds() {
        if (this.lbfr.getNumberOfTransactionInFile() == this.lbfr.getMaxAllowedTransactionsPerFile()) {
            return TransactionCodeEnum.FILEFULL;
        }
        if (this.getNumberOfTransactions() == this.maxTransactionsPerBatch) {
            return TransactionCodeEnum.BATCHFULL;
        }
        return TransactionCodeEnum.SUCCESS;
    }

    public int getNumberOfTransactions() {
        return this.numOfTxn;
    }

    public boolean isFull() {
        return this.getNumberOfTransactions() == this.maxTransactionsPerBatch;
    }

    public void closeFile() throws IOException {
        this.osWrttxn.close();
    }

    public File getFile() {
        return this.file;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public int getNumOfTxn() {
        return this.numOfTxn;
    }

    public void setNumOfTxn(int numOfTxn) {
        this.numOfTxn = numOfTxn;
    }
}

