/*
 * Decompiled with CFR 0.152.
 */
package io.github.vantiv.sdk;

import io.github.vantiv.sdk.CnpBatchException;
import io.github.vantiv.sdk.CnpBatchNoMoreBatchTransactionException;
import io.github.vantiv.sdk.CnpResponseProcessor;
import io.github.vantiv.sdk.ResponseFileParser;
import io.github.vantiv.sdk.generate.BatchResponse;
import io.github.vantiv.sdk.generate.CnpTransactionInterface;
import io.github.vantiv.sdk.generate.TransactionType;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class CnpBatchResponse {
    private BatchResponse batchResponse;
    ResponseFileParser responseFileParser;
    private JAXBContext jc;
    private Unmarshaller unmarshaller;
    private boolean allTransactionsRetrieved = false;

    CnpBatchResponse(BatchResponse batchResponse) {
        this.setBatchResponse(batchResponse);
    }

    public CnpBatchResponse(ResponseFileParser responseFileParser) throws CnpBatchException {
        this.responseFileParser = responseFileParser;
        String batchResponseXML = "";
        try {
            batchResponseXML = responseFileParser.getNextTag("batchResponse");
            this.jc = JAXBContext.newInstance((String)"io.github.vantiv.sdk.generate");
            this.unmarshaller = this.jc.createUnmarshaller();
            this.batchResponse = (BatchResponse)this.unmarshaller.unmarshal((Reader)new StringReader(batchResponseXML));
        }
        catch (JAXBException e) {
            throw new CnpBatchException("There was an exception while trying to unmarshall batchResponse: " + batchResponseXML, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new CnpBatchException("There was an unknown error while parsing the response file.", e);
        }
    }

    void setBatchResponse(BatchResponse batchResponse) {
        this.batchResponse = batchResponse;
    }

    BatchResponse getBatchResponse() {
        return this.batchResponse;
    }

    public long getCnpBatchId() {
        return this.batchResponse.getCnpBatchId();
    }

    public String getMerchantId() {
        return this.batchResponse.getMerchantId();
    }

    public CnpTransactionInterface getNextTransaction() {
        if (this.allTransactionsRetrieved) {
            throw new CnpBatchNoMoreBatchTransactionException("All transactions from this batch have already been retrieved");
        }
        String txnXML = "";
        try {
            txnXML = this.responseFileParser.getNextTag("transactionResponse");
        }
        catch (Exception e) {
            this.allTransactionsRetrieved = true;
            throw new CnpBatchNoMoreBatchTransactionException("All transactions from this batch have already been retrieved");
        }
        try {
            TransactionType objToRet = (TransactionType)((JAXBElement)this.unmarshaller.unmarshal((Reader)new StringReader(txnXML))).getValue();
            return objToRet;
        }
        catch (JAXBException e) {
            throw new CnpBatchException("There was an exception while trying to unmarshall transactionResponse: " + txnXML, (Exception)((Object)e));
        }
    }

    public boolean processNextTransaction(CnpResponseProcessor processor) {
        CnpTransactionInterface objToRet;
        String txnXml;
        try {
            txnXml = this.responseFileParser.getNextTag("transactionResponse");
        }
        catch (Exception e) {
            return false;
        }
        try {
            objToRet = (CnpTransactionInterface)((JAXBElement)this.unmarshaller.unmarshal((Reader)new StringReader(txnXml))).getValue();
        }
        catch (JAXBException e) {
            throw new CnpBatchException("There was an exception while trying to unmarshall transactionResponse: " + txnXml, (Exception)((Object)e));
        }
        String methodName = "process" + objToRet.getClass().getSimpleName();
        try {
            Method processMethod = CnpResponseProcessor.class.getMethod(methodName, objToRet.getClass());
            processMethod.invoke((Object)processor, objToRet);
            return true;
        }
        catch (NoSuchMethodException e) {
            throw new CnpBatchException("CnpResponseProcessor is missing a method: " + methodName, e);
        }
        catch (IllegalAccessException e) {
            throw new CnpBatchException("Illegally accessed " + methodName, e);
        }
        catch (InvocationTargetException e) {
            throw new CnpBatchException("An uncaught exception occurred in " + methodName, e);
        }
    }
}

