/*
 * Decompiled with CFR 0.152.
 */
package io.github.vantiv.sdk;

import io.github.vantiv.sdk.CnpBatchException;
import io.github.vantiv.sdk.ResponseFileParser;
import io.github.vantiv.sdk.generate.CnpResponse;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

abstract class CnpFileResponse
implements AutoCloseable {
    protected JAXBContext jc;
    protected CnpResponse cnpResponse;
    protected Unmarshaller unmarshaller;
    protected File xmlFile;
    ResponseFileParser responseFileParser;

    public CnpFileResponse(File xmlFile) throws CnpBatchException {
        try {
            this.xmlFile = xmlFile;
            this.responseFileParser = new ResponseFileParser(xmlFile);
            String cnpResponseXml = this.responseFileParser.getNextTag("cnpResponse");
            this.jc = JAXBContext.newInstance((String)"io.github.vantiv.sdk.generate");
            this.unmarshaller = this.jc.createUnmarshaller();
            this.cnpResponse = (CnpResponse)this.unmarshaller.unmarshal((Reader)new StringReader(cnpResponseXml));
        }
        catch (JAXBException e) {
            throw new CnpBatchException("There was an exception while unmarshalling the response file. Check your JAXB dependencies.", (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new CnpBatchException("There was an exception while reading the Cnp response file. The response file might not have been generated. Try re-sending the request file or contact us.", e);
        }
    }

    public File getFile() {
        return this.xmlFile;
    }

    public long getCnpSessionId() {
        return this.cnpResponse.getCnpSessionId();
    }

    public String getVersion() {
        return this.cnpResponse.getVersion();
    }

    public String getResponse() {
        return this.cnpResponse.getResponse();
    }

    public String getMessage() {
        return this.cnpResponse.getMessage();
    }

    public String getId() {
        return this.cnpResponse.getId();
    }

    public ResponseFileParser getResponseFileParser() {
        return this.responseFileParser;
    }

    public void setResponseFileParser(ResponseFileParser responseFileParser) {
        this.responseFileParser = responseFileParser;
    }

    @Override
    public void close() throws IOException {
        this.responseFileParser.close();
    }

    @Deprecated
    public void closeResources() throws IOException {
        this.close();
    }
}

