/*
 * Decompiled with CFR 0.152.
 */
package io.github.vantiv.sdk;

import io.github.vantiv.sdk.CnpConnectionLimitExceededException;
import io.github.vantiv.sdk.CnpContext;
import io.github.vantiv.sdk.CnpInvalidCredentialException;
import io.github.vantiv.sdk.CnpObjectionableContentException;
import io.github.vantiv.sdk.CnpOnlineException;
import io.github.vantiv.sdk.Communication;
import io.github.vantiv.sdk.Configuration;
import io.github.vantiv.sdk.generate.Activate;
import io.github.vantiv.sdk.generate.ActivateResponse;
import io.github.vantiv.sdk.generate.ActivateReversal;
import io.github.vantiv.sdk.generate.ActivateReversalResponse;
import io.github.vantiv.sdk.generate.AuthReversal;
import io.github.vantiv.sdk.generate.AuthReversalResponse;
import io.github.vantiv.sdk.generate.Authentication;
import io.github.vantiv.sdk.generate.Authorization;
import io.github.vantiv.sdk.generate.AuthorizationResponse;
import io.github.vantiv.sdk.generate.BalanceInquiry;
import io.github.vantiv.sdk.generate.BalanceInquiryResponse;
import io.github.vantiv.sdk.generate.CancelSubscription;
import io.github.vantiv.sdk.generate.CancelSubscriptionResponse;
import io.github.vantiv.sdk.generate.Capture;
import io.github.vantiv.sdk.generate.CaptureGivenAuth;
import io.github.vantiv.sdk.generate.CaptureGivenAuthResponse;
import io.github.vantiv.sdk.generate.CaptureResponse;
import io.github.vantiv.sdk.generate.CnpOnlineRequest;
import io.github.vantiv.sdk.generate.CnpOnlineResponse;
import io.github.vantiv.sdk.generate.CreatePlan;
import io.github.vantiv.sdk.generate.CreatePlanResponse;
import io.github.vantiv.sdk.generate.Credit;
import io.github.vantiv.sdk.generate.CreditResponse;
import io.github.vantiv.sdk.generate.CustomerCredit;
import io.github.vantiv.sdk.generate.CustomerCreditResponse;
import io.github.vantiv.sdk.generate.CustomerDebit;
import io.github.vantiv.sdk.generate.CustomerDebitResponse;
import io.github.vantiv.sdk.generate.Deactivate;
import io.github.vantiv.sdk.generate.DeactivateResponse;
import io.github.vantiv.sdk.generate.DeactivateReversal;
import io.github.vantiv.sdk.generate.DeactivateReversalResponse;
import io.github.vantiv.sdk.generate.DepositReversal;
import io.github.vantiv.sdk.generate.DepositReversalResponse;
import io.github.vantiv.sdk.generate.DepositTransactionReversal;
import io.github.vantiv.sdk.generate.DepositTransactionReversalResponse;
import io.github.vantiv.sdk.generate.EcheckCredit;
import io.github.vantiv.sdk.generate.EcheckCreditResponse;
import io.github.vantiv.sdk.generate.EcheckRedeposit;
import io.github.vantiv.sdk.generate.EcheckRedepositResponse;
import io.github.vantiv.sdk.generate.EcheckSale;
import io.github.vantiv.sdk.generate.EcheckSalesResponse;
import io.github.vantiv.sdk.generate.EcheckVerification;
import io.github.vantiv.sdk.generate.EcheckVerificationResponse;
import io.github.vantiv.sdk.generate.EcheckVoid;
import io.github.vantiv.sdk.generate.EcheckVoidResponse;
import io.github.vantiv.sdk.generate.FastAccessFunding;
import io.github.vantiv.sdk.generate.FastAccessFundingResponse;
import io.github.vantiv.sdk.generate.ForceCapture;
import io.github.vantiv.sdk.generate.ForceCaptureResponse;
import io.github.vantiv.sdk.generate.FraudCheck;
import io.github.vantiv.sdk.generate.FraudCheckResponse;
import io.github.vantiv.sdk.generate.FundingInstructionVoid;
import io.github.vantiv.sdk.generate.FundingInstructionVoidResponse;
import io.github.vantiv.sdk.generate.GiftCardAuthReversal;
import io.github.vantiv.sdk.generate.GiftCardAuthReversalResponse;
import io.github.vantiv.sdk.generate.GiftCardCapture;
import io.github.vantiv.sdk.generate.GiftCardCaptureResponse;
import io.github.vantiv.sdk.generate.GiftCardCredit;
import io.github.vantiv.sdk.generate.GiftCardCreditResponse;
import io.github.vantiv.sdk.generate.Load;
import io.github.vantiv.sdk.generate.LoadResponse;
import io.github.vantiv.sdk.generate.LoadReversal;
import io.github.vantiv.sdk.generate.LoadReversalResponse;
import io.github.vantiv.sdk.generate.PayFacCredit;
import io.github.vantiv.sdk.generate.PayFacCreditResponse;
import io.github.vantiv.sdk.generate.PayFacDebit;
import io.github.vantiv.sdk.generate.PayFacDebitResponse;
import io.github.vantiv.sdk.generate.PayoutOrgCredit;
import io.github.vantiv.sdk.generate.PayoutOrgCreditResponse;
import io.github.vantiv.sdk.generate.PayoutOrgDebit;
import io.github.vantiv.sdk.generate.PayoutOrgDebitResponse;
import io.github.vantiv.sdk.generate.PhysicalCheckCredit;
import io.github.vantiv.sdk.generate.PhysicalCheckCreditResponse;
import io.github.vantiv.sdk.generate.PhysicalCheckDebit;
import io.github.vantiv.sdk.generate.PhysicalCheckDebitResponse;
import io.github.vantiv.sdk.generate.QueryTransaction;
import io.github.vantiv.sdk.generate.RecurringTransactionResponseType;
import io.github.vantiv.sdk.generate.RefundReversal;
import io.github.vantiv.sdk.generate.RefundReversalResponse;
import io.github.vantiv.sdk.generate.RefundTransactionReversal;
import io.github.vantiv.sdk.generate.RefundTransactionReversalResponse;
import io.github.vantiv.sdk.generate.RegisterTokenRequestType;
import io.github.vantiv.sdk.generate.RegisterTokenResponse;
import io.github.vantiv.sdk.generate.ReserveCredit;
import io.github.vantiv.sdk.generate.ReserveCreditResponse;
import io.github.vantiv.sdk.generate.ReserveDebit;
import io.github.vantiv.sdk.generate.ReserveDebitResponse;
import io.github.vantiv.sdk.generate.Sale;
import io.github.vantiv.sdk.generate.SaleResponse;
import io.github.vantiv.sdk.generate.SubmerchantCredit;
import io.github.vantiv.sdk.generate.SubmerchantCreditResponse;
import io.github.vantiv.sdk.generate.SubmerchantDebit;
import io.github.vantiv.sdk.generate.SubmerchantDebitResponse;
import io.github.vantiv.sdk.generate.TransactionTypeWithReportGroup;
import io.github.vantiv.sdk.generate.TransactionTypeWithReportGroupAndPartial;
import io.github.vantiv.sdk.generate.TranslateToLowValueTokenRequestType;
import io.github.vantiv.sdk.generate.TranslateToLowValueTokenResponse;
import io.github.vantiv.sdk.generate.Unload;
import io.github.vantiv.sdk.generate.UnloadResponse;
import io.github.vantiv.sdk.generate.UnloadReversal;
import io.github.vantiv.sdk.generate.UnloadReversalResponse;
import io.github.vantiv.sdk.generate.UpdateCardValidationNumOnToken;
import io.github.vantiv.sdk.generate.UpdateCardValidationNumOnTokenResponse;
import io.github.vantiv.sdk.generate.UpdatePlan;
import io.github.vantiv.sdk.generate.UpdatePlanResponse;
import io.github.vantiv.sdk.generate.UpdateSubscription;
import io.github.vantiv.sdk.generate.UpdateSubscriptionResponse;
import io.github.vantiv.sdk.generate.VendorCredit;
import io.github.vantiv.sdk.generate.VendorCreditResponse;
import io.github.vantiv.sdk.generate.VendorDebit;
import io.github.vantiv.sdk.generate.VendorDebitResponse;
import io.github.vantiv.sdk.generate.Void;
import io.github.vantiv.sdk.generate.VoidResponse;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;

public class CnpOnline {
    private Properties config;
    private Communication communication;
    private Boolean removeStubs = false;

    public CnpOnline() {
        this.communication = new Communication();
        FileInputStream fileInputStream = null;
        try {
            this.config = new Properties();
            fileInputStream = new FileInputStream(new Configuration().location());
            this.config.load(fileInputStream);
        }
        catch (FileNotFoundException e) {
            throw new CnpOnlineException("Configuration file not found. If you are not using the .cnp_SDK_config.properties file, please use the " + CnpOnline.class.getSimpleName() + "(Properties) constructor. If you are using .cnp_SDK_config.properties, you can generate one using java -jar cnp-sdk-for-java-x.xx.jar", e);
        }
        catch (IOException e) {
            throw new CnpOnlineException("Configuration file could not be loaded.  Check to see if the user running this has permission to access the file", e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    throw new CnpOnlineException("Configuration FileInputStream could not be closed.", e);
                }
            }
        }
    }

    public CnpOnline(Properties config) {
        this.config = config;
        this.communication = new Communication();
    }

    public CnpOnline(Properties config, Boolean removeStubs) {
        this.config = config;
        this.removeStubs = removeStubs;
        this.communication = new Communication();
    }

    protected void setCommunication(Communication communication) {
        this.communication = communication;
    }

    public AuthorizationResponse authorize(Authorization auth) throws CnpOnlineException {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.authorize(auth, request);
    }

    public AuthorizationResponse authorize(Authorization auth, CnpOnlineRequest overrides) throws CnpOnlineException {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(auth);
        request.setTransaction(CnpContext.getObjectFactory().createAuthorization(auth));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (AuthorizationResponse)newresponse.getValue();
    }

    public AuthReversalResponse authReversal(AuthReversal reversal) throws CnpOnlineException {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.authReversal(reversal, request);
    }

    public AuthReversalResponse authReversal(AuthReversal reversal, CnpOnlineRequest overrides) throws CnpOnlineException {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(reversal);
        request.setTransaction(CnpContext.getObjectFactory().createAuthReversal(reversal));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (AuthReversalResponse)newresponse.getValue();
    }

    public CaptureResponse capture(Capture capture) throws CnpOnlineException {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.capture(capture, request);
    }

    public CaptureResponse capture(Capture capture, CnpOnlineRequest overrides) throws CnpOnlineException {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(capture);
        request.setTransaction(CnpContext.getObjectFactory().createCapture(capture));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (CaptureResponse)newresponse.getValue();
    }

    public CaptureGivenAuthResponse captureGivenAuth(CaptureGivenAuth captureGivenAuth) throws CnpOnlineException {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.captureGivenAuth(captureGivenAuth, request);
    }

    public CaptureGivenAuthResponse captureGivenAuth(CaptureGivenAuth captureGivenAuth, CnpOnlineRequest overrides) throws CnpOnlineException {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(captureGivenAuth);
        request.setTransaction(CnpContext.getObjectFactory().createCaptureGivenAuth(captureGivenAuth));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (CaptureGivenAuthResponse)newresponse.getValue();
    }

    public CreditResponse credit(Credit credit) throws CnpOnlineException {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.credit(credit, request);
    }

    public CreditResponse credit(Credit credit, CnpOnlineRequest overrides) throws CnpOnlineException {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(credit);
        request.setTransaction(CnpContext.getObjectFactory().createCredit(credit));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (CreditResponse)newresponse.getValue();
    }

    public EcheckCreditResponse echeckCredit(EcheckCredit echeckcredit) throws CnpOnlineException {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.echeckCredit(echeckcredit, request);
    }

    public EcheckCreditResponse echeckCredit(EcheckCredit echeckcredit, CnpOnlineRequest overrides) throws CnpOnlineException {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(echeckcredit);
        request.setTransaction(CnpContext.getObjectFactory().createEcheckCredit(echeckcredit));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (EcheckCreditResponse)newresponse.getValue();
    }

    public EcheckRedepositResponse echeckRedeposit(EcheckRedeposit echeckRedeposit) throws CnpOnlineException {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.echeckRedeposit(echeckRedeposit, request);
    }

    public EcheckRedepositResponse echeckRedeposit(EcheckRedeposit echeckRedeposit, CnpOnlineRequest overrides) throws CnpOnlineException {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(echeckRedeposit);
        request.setTransaction(CnpContext.getObjectFactory().createEcheckRedeposit(echeckRedeposit));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (EcheckRedepositResponse)newresponse.getValue();
    }

    public EcheckSalesResponse echeckSale(EcheckSale echeckSale) throws CnpOnlineException {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.echeckSale(echeckSale, request);
    }

    public EcheckSalesResponse echeckSale(EcheckSale echeckSale, CnpOnlineRequest overrides) throws CnpOnlineException {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(echeckSale);
        request.setTransaction(CnpContext.getObjectFactory().createEcheckSale(echeckSale));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (EcheckSalesResponse)newresponse.getValue();
    }

    public EcheckVerificationResponse echeckVerification(EcheckVerification echeckVerification) throws CnpOnlineException {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.echeckVerification(echeckVerification, request);
    }

    public EcheckVerificationResponse echeckVerification(EcheckVerification echeckVerification, CnpOnlineRequest overrides) throws CnpOnlineException {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(echeckVerification);
        request.setTransaction(CnpContext.getObjectFactory().createEcheckVerification(echeckVerification));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (EcheckVerificationResponse)newresponse.getValue();
    }

    public ForceCaptureResponse forceCapture(ForceCapture forceCapture) throws CnpOnlineException {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.forceCapture(forceCapture, request);
    }

    public ForceCaptureResponse forceCapture(ForceCapture forceCapture, CnpOnlineRequest overrides) throws CnpOnlineException {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(forceCapture);
        request.setTransaction(CnpContext.getObjectFactory().createForceCapture(forceCapture));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (ForceCaptureResponse)newresponse.getValue();
    }

    public SaleResponse sale(Sale sale) throws CnpOnlineException {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.sale(sale, request);
    }

    public SaleResponse sale(Sale sale, CnpOnlineRequest overrides) throws CnpOnlineException {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(sale);
        request.setTransaction(CnpContext.getObjectFactory().createSale(sale));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (SaleResponse)newresponse.getValue();
    }

    public FraudCheckResponse fraudCheck(FraudCheck fraudCheck) throws CnpOnlineException {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.fraudCheck(fraudCheck, request);
    }

    public FraudCheckResponse fraudCheck(FraudCheck fraudCheck, CnpOnlineRequest overrides) throws CnpOnlineException {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(fraudCheck);
        request.setTransaction(CnpContext.getObjectFactory().createFraudCheck(fraudCheck));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (FraudCheckResponse)newresponse.getValue();
    }

    public RegisterTokenResponse registerToken(RegisterTokenRequestType tokenRequest) throws CnpOnlineException {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.registerToken(tokenRequest, request);
    }

    public RegisterTokenResponse registerToken(RegisterTokenRequestType tokenRequest, CnpOnlineRequest overrides) throws CnpOnlineException {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(tokenRequest);
        request.setTransaction(CnpContext.getObjectFactory().createRegisterTokenRequest(tokenRequest));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (RegisterTokenResponse)newresponse.getValue();
    }

    public VoidResponse dovoid(Void v) throws CnpOnlineException {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.dovoid(v, request);
    }

    public VoidResponse dovoid(Void v, CnpOnlineRequest overrides) throws CnpOnlineException {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(v);
        request.setTransaction(CnpContext.getObjectFactory().createVoid(v));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (VoidResponse)newresponse.getValue();
    }

    public EcheckVoidResponse echeckVoid(EcheckVoid echeckVoid) throws CnpOnlineException {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.echeckVoid(echeckVoid, request);
    }

    public EcheckVoidResponse echeckVoid(EcheckVoid echeckVoid, CnpOnlineRequest overrides) throws CnpOnlineException {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(echeckVoid);
        request.setTransaction(CnpContext.getObjectFactory().createEcheckVoid(echeckVoid));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (EcheckVoidResponse)newresponse.getValue();
    }

    public UpdateCardValidationNumOnTokenResponse updateCardValidationNumOnToken(UpdateCardValidationNumOnToken update) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.updateCardValidationNumOnToken(update, request);
    }

    public UpdateCardValidationNumOnTokenResponse updateCardValidationNumOnToken(UpdateCardValidationNumOnToken update, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(update);
        request.setTransaction(CnpContext.getObjectFactory().createUpdateCardValidationNumOnToken(update));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (UpdateCardValidationNumOnTokenResponse)newresponse.getValue();
    }

    public CancelSubscriptionResponse cancelSubscription(CancelSubscription cancellation) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.cancelSubscription(cancellation, request);
    }

    public CancelSubscriptionResponse cancelSubscription(CancelSubscription cancellation, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        request.setRecurringTransaction(CnpContext.getObjectFactory().createCancelSubscription(cancellation));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends RecurringTransactionResponseType> newresponse = response.getRecurringTransactionResponse();
        return (CancelSubscriptionResponse)newresponse.getValue();
    }

    public UpdateSubscriptionResponse updateSubscription(UpdateSubscription update) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.updateSubscription(update, request);
    }

    public UpdateSubscriptionResponse updateSubscription(UpdateSubscription update, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        request.setRecurringTransaction(CnpContext.getObjectFactory().createUpdateSubscription(update));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends RecurringTransactionResponseType> newresponse = response.getRecurringTransactionResponse();
        return (UpdateSubscriptionResponse)newresponse.getValue();
    }

    public CreatePlanResponse createPlan(CreatePlan create) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.createPlan(create, request);
    }

    public CreatePlanResponse createPlan(CreatePlan create, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        request.setRecurringTransaction(CnpContext.getObjectFactory().createCreatePlan(create));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends RecurringTransactionResponseType> newresponse = response.getRecurringTransactionResponse();
        return (CreatePlanResponse)newresponse.getValue();
    }

    public UpdatePlanResponse updatePlan(UpdatePlan update) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.updatePlan(update, request);
    }

    public UpdatePlanResponse updatePlan(UpdatePlan update, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        request.setRecurringTransaction(CnpContext.getObjectFactory().createUpdatePlan(update));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends RecurringTransactionResponseType> newresponse = response.getRecurringTransactionResponse();
        return (UpdatePlanResponse)newresponse.getValue();
    }

    public ActivateResponse activate(Activate activate) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.activate(activate, request);
    }

    public ActivateResponse activate(Activate activate, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(activate);
        request.setTransaction(CnpContext.getObjectFactory().createActivate(activate));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (ActivateResponse)newresponse.getValue();
    }

    public DeactivateResponse deactivate(Deactivate deactivate) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.deactivate(deactivate, request);
    }

    public DeactivateResponse deactivate(Deactivate deactivate, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(deactivate);
        request.setTransaction(CnpContext.getObjectFactory().createDeactivate(deactivate));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (DeactivateResponse)newresponse.getValue();
    }

    public LoadResponse load(Load load) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.load(load, request);
    }

    public LoadResponse load(Load load, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(load);
        request.setTransaction(CnpContext.getObjectFactory().createLoad(load));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (LoadResponse)newresponse.getValue();
    }

    public UnloadResponse unload(Unload unload) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.unload(unload, request);
    }

    public UnloadResponse unload(Unload unload, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(unload);
        request.setTransaction(CnpContext.getObjectFactory().createUnload(unload));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (UnloadResponse)newresponse.getValue();
    }

    public BalanceInquiryResponse balanceInquiry(BalanceInquiry balanceInquiry) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.balanceInquiry(balanceInquiry, request);
    }

    public BalanceInquiryResponse balanceInquiry(BalanceInquiry balanceInquiry, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(balanceInquiry);
        request.setTransaction(CnpContext.getObjectFactory().createBalanceInquiry(balanceInquiry));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (BalanceInquiryResponse)newresponse.getValue();
    }

    public ActivateReversalResponse activateReversal(ActivateReversal activateReversal) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.activateReversal(activateReversal, request);
    }

    public ActivateReversalResponse activateReversal(ActivateReversal activateReversal, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(activateReversal);
        request.setTransaction(CnpContext.getObjectFactory().createActivateReversal(activateReversal));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (ActivateReversalResponse)newresponse.getValue();
    }

    public DeactivateReversalResponse deactivateReversal(DeactivateReversal deactivateReversal) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.deactivateReversal(deactivateReversal, request);
    }

    public DeactivateReversalResponse deactivateReversal(DeactivateReversal deactivateReversal, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(deactivateReversal);
        request.setTransaction(CnpContext.getObjectFactory().createDeactivateReversal(deactivateReversal));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (DeactivateReversalResponse)newresponse.getValue();
    }

    public LoadReversalResponse loadReversal(LoadReversal loadReversal) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.loadReversal(loadReversal, request);
    }

    public LoadReversalResponse loadReversal(LoadReversal loadReversal, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(loadReversal);
        request.setTransaction(CnpContext.getObjectFactory().createLoadReversal(loadReversal));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (LoadReversalResponse)newresponse.getValue();
    }

    public UnloadReversalResponse unloadReversal(UnloadReversal unloadReversal) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.unloadReversal(unloadReversal, request);
    }

    public UnloadReversalResponse unloadReversal(UnloadReversal unloadReversal, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(unloadReversal);
        request.setTransaction(CnpContext.getObjectFactory().createUnloadReversal(unloadReversal));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (UnloadReversalResponse)newresponse.getValue();
    }

    public RefundReversalResponse refundReversal(RefundReversal refundReversal) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.refundReversal(refundReversal, request);
    }

    public RefundReversalResponse refundReversal(RefundReversal refundReversal, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(refundReversal);
        request.setTransaction(CnpContext.getObjectFactory().createRefundReversal(refundReversal));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (RefundReversalResponse)newresponse.getValue();
    }

    public DepositReversalResponse depositReversal(DepositReversal depositReversal) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.depositReversal(depositReversal, request);
    }

    public DepositReversalResponse depositReversal(DepositReversal depositReversal, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(depositReversal);
        request.setTransaction(CnpContext.getObjectFactory().createDepositReversal(depositReversal));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (DepositReversalResponse)newresponse.getValue();
    }

    public DepositTransactionReversalResponse depositTransactionReversal(DepositTransactionReversal depositTransactionReversal) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.depositTransactionReversal(depositTransactionReversal, request);
    }

    public DepositTransactionReversalResponse depositTransactionReversal(DepositTransactionReversal depositTransactionReversal, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(depositTransactionReversal);
        request.setTransaction(CnpContext.getObjectFactory().createDepositTransactionReversal(depositTransactionReversal));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (DepositTransactionReversalResponse)newresponse.getValue();
    }

    public RefundTransactionReversalResponse refundTransactionReversal(RefundTransactionReversal refundTransactionReversal) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.refundTransactionReversal(refundTransactionReversal, request);
    }

    public RefundTransactionReversalResponse refundTransactionReversal(RefundTransactionReversal transactionReversal, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(transactionReversal);
        request.setTransaction(CnpContext.getObjectFactory().createRefundTransactionReversal(transactionReversal));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (RefundTransactionReversalResponse)newresponse.getValue();
    }

    public TransactionTypeWithReportGroup queryTransaction(QueryTransaction queryTransaction) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.queryTransaction(queryTransaction, request);
    }

    public TransactionTypeWithReportGroup queryTransaction(QueryTransaction queryTransaction, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(queryTransaction);
        request.setTransaction(CnpContext.getObjectFactory().createQueryTransaction(queryTransaction));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (TransactionTypeWithReportGroup)newresponse.getValue();
    }

    public GiftCardCaptureResponse giftCardCapture(GiftCardCapture giftCardCapture) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.giftCardCapture(giftCardCapture, request);
    }

    public GiftCardCaptureResponse giftCardCapture(GiftCardCapture giftCardCapture, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(giftCardCapture);
        request.setTransaction(CnpContext.getObjectFactory().createGiftCardCapture(giftCardCapture));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (GiftCardCaptureResponse)newresponse.getValue();
    }

    public GiftCardAuthReversalResponse giftCardAuthReversal(GiftCardAuthReversal giftCardAuthReversal) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.giftCardAuthReversal(giftCardAuthReversal, request);
    }

    public GiftCardAuthReversalResponse giftCardAuthReversal(GiftCardAuthReversal giftCardAuthReversal, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(giftCardAuthReversal);
        request.setTransaction(CnpContext.getObjectFactory().createGiftCardAuthReversal(giftCardAuthReversal));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (GiftCardAuthReversalResponse)newresponse.getValue();
    }

    public GiftCardCreditResponse giftCardCredit(GiftCardCredit giftCardCredit) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.giftCardCredit(giftCardCredit, request);
    }

    public GiftCardCreditResponse giftCardCredit(GiftCardCredit giftCardCredit, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(giftCardCredit);
        request.setTransaction(CnpContext.getObjectFactory().createGiftCardCredit(giftCardCredit));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (GiftCardCreditResponse)newresponse.getValue();
    }

    public PayFacCreditResponse payFacCredit(PayFacCredit payFacCredit) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.payFacCredit(payFacCredit, request);
    }

    public PayFacCreditResponse payFacCredit(PayFacCredit payFacCredit, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(payFacCredit);
        request.setTransaction(CnpContext.getObjectFactory().createPayFacCredit(payFacCredit));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (PayFacCreditResponse)newresponse.getValue();
    }

    public PayFacDebitResponse payFacDebit(PayFacDebit payFacDebit) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.payFacDebit(payFacDebit, request);
    }

    public PayFacDebitResponse payFacDebit(PayFacDebit payFacDebit, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(payFacDebit);
        request.setTransaction(CnpContext.getObjectFactory().createPayFacDebit(payFacDebit));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (PayFacDebitResponse)newresponse.getValue();
    }

    public SubmerchantCreditResponse submerchantCredit(SubmerchantCredit submerchantCredit) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.submerchantCredit(submerchantCredit, request);
    }

    public SubmerchantCreditResponse submerchantCredit(SubmerchantCredit submerchantCredit, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(submerchantCredit);
        request.setTransaction(CnpContext.getObjectFactory().createSubmerchantCredit(submerchantCredit));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (SubmerchantCreditResponse)newresponse.getValue();
    }

    public SubmerchantDebitResponse submerchantDebit(SubmerchantDebit submerchantDebit) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.submerchantDebit(submerchantDebit, request);
    }

    public SubmerchantDebitResponse submerchantDebit(SubmerchantDebit submerchantDebit, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(submerchantDebit);
        request.setTransaction(CnpContext.getObjectFactory().createSubmerchantDebit(submerchantDebit));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (SubmerchantDebitResponse)newresponse.getValue();
    }

    public ReserveCreditResponse submerchantCredit(ReserveCredit reserveCredit) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.reserveCredit(reserveCredit, request);
    }

    public ReserveCreditResponse reserveCredit(ReserveCredit reserveCredit, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(reserveCredit);
        request.setTransaction(CnpContext.getObjectFactory().createReserveCredit(reserveCredit));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (ReserveCreditResponse)newresponse.getValue();
    }

    public ReserveDebitResponse submerchantDebit(ReserveDebit reserveDebit) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.reserveDebit(reserveDebit, request);
    }

    public ReserveDebitResponse reserveDebit(ReserveDebit reserveDebit, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(reserveDebit);
        request.setTransaction(CnpContext.getObjectFactory().createReserveDebit(reserveDebit));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (ReserveDebitResponse)newresponse.getValue();
    }

    public FundingInstructionVoidResponse fundingInstructionVoid(FundingInstructionVoid fundingInstructionVoid) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.fundingInstructionVoid(fundingInstructionVoid, request);
    }

    public FundingInstructionVoidResponse fundingInstructionVoid(FundingInstructionVoid fundingInstructionVoid, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(fundingInstructionVoid);
        request.setTransaction(CnpContext.getObjectFactory().createFundingInstructionVoid(fundingInstructionVoid));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (FundingInstructionVoidResponse)newresponse.getValue();
    }

    public VendorCreditResponse vendorCredit(VendorCredit vendorCredit) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.vendorCredit(vendorCredit, request);
    }

    public VendorCreditResponse vendorCredit(VendorCredit vendorCredit, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(vendorCredit);
        request.setTransaction(CnpContext.getObjectFactory().createVendorCredit(vendorCredit));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (VendorCreditResponse)newresponse.getValue();
    }

    public VendorDebitResponse physicalCheckDebit(VendorDebit vendorDebit) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.vendorDebit(vendorDebit, request);
    }

    public VendorDebitResponse vendorDebit(VendorDebit vendorDebit) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.vendorDebit(vendorDebit, request);
    }

    public VendorDebitResponse vendorDebit(VendorDebit vendorDebit, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(vendorDebit);
        request.setTransaction(CnpContext.getObjectFactory().createVendorDebit(vendorDebit));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (VendorDebitResponse)newresponse.getValue();
    }

    public PhysicalCheckCreditResponse physicalCheckCredit(PhysicalCheckCredit physicalCheckCredit) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.physicalCheckCredit(physicalCheckCredit, request);
    }

    public PhysicalCheckCreditResponse physicalCheckCredit(PhysicalCheckCredit physicalCheckCredit, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(physicalCheckCredit);
        request.setTransaction(CnpContext.getObjectFactory().createPhysicalCheckCredit(physicalCheckCredit));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (PhysicalCheckCreditResponse)newresponse.getValue();
    }

    public PhysicalCheckDebitResponse physicalCheckDebit(PhysicalCheckDebit physicalCheckDebit) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.physicalCheckDebit(physicalCheckDebit, request);
    }

    public PhysicalCheckDebitResponse physicalCheckDebit(PhysicalCheckDebit physicalCheckDebit, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(physicalCheckDebit);
        request.setTransaction(CnpContext.getObjectFactory().createPhysicalCheckDebit(physicalCheckDebit));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (PhysicalCheckDebitResponse)newresponse.getValue();
    }

    public FastAccessFundingResponse fastAccessFunding(FastAccessFunding fastAccessFunding) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.fastAccessFunding(fastAccessFunding, request);
    }

    public FastAccessFundingResponse fastAccessFunding(FastAccessFunding fastAccessFunding, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(fastAccessFunding);
        request.setTransaction(CnpContext.getObjectFactory().createFastAccessFunding(fastAccessFunding));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (FastAccessFundingResponse)newresponse.getValue();
    }

    public TranslateToLowValueTokenResponse TranslateToLowValueTokenRequest(TranslateToLowValueTokenRequestType translateToLowValueTokenRequest) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.TranslateToLowValueTokenRequest(translateToLowValueTokenRequest, request);
    }

    public TranslateToLowValueTokenResponse TranslateToLowValueTokenRequest(TranslateToLowValueTokenRequestType translateToLowValueTokenRequest, CnpOnlineRequest overridingRequestHeader) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overridingRequestHeader);
        this.fillInReportGroup(translateToLowValueTokenRequest);
        request.setTransaction(CnpContext.getObjectFactory().createTranslateToLowValueTokenRequest(translateToLowValueTokenRequest));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (TranslateToLowValueTokenResponse)newresponse.getValue();
    }

    public CustomerCreditResponse customerCredit(CustomerCredit customerCredit) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.customerCredit(customerCredit, request);
    }

    public CustomerCreditResponse customerCredit(CustomerCredit customerCredit, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(customerCredit);
        request.setTransaction(CnpContext.getObjectFactory().createCustomerCredit(customerCredit));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (CustomerCreditResponse)newresponse.getValue();
    }

    public CustomerDebitResponse customerDebit(CustomerDebit customerDebit) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.customerDebit(customerDebit, request);
    }

    public CustomerDebitResponse customerDebit(CustomerDebit customerDebit, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(customerDebit);
        request.setTransaction(CnpContext.getObjectFactory().createCustomerDebit(customerDebit));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (CustomerDebitResponse)newresponse.getValue();
    }

    public PayoutOrgCreditResponse payoutOrgCredit(PayoutOrgCredit payoutOrgCredit) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.payoutOrgCredit(payoutOrgCredit, request);
    }

    public PayoutOrgCreditResponse payoutOrgCredit(PayoutOrgCredit payoutOrgCredit, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(payoutOrgCredit);
        request.setTransaction(CnpContext.getObjectFactory().createPayoutOrgCredit(payoutOrgCredit));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (PayoutOrgCreditResponse)newresponse.getValue();
    }

    public PayoutOrgDebitResponse payoutOrgDebit(PayoutOrgDebit payoutOrgDebit) {
        CnpOnlineRequest request = this.createCnpOnlineRequest();
        return this.payoutOrgDebit(payoutOrgDebit, request);
    }

    public PayoutOrgDebitResponse payoutOrgDebit(PayoutOrgDebit payoutOrgDebit, CnpOnlineRequest overrides) {
        CnpOnlineRequest request = this.fillInMissingFieldsFromConfig(overrides);
        this.fillInReportGroup(payoutOrgDebit);
        request.setTransaction(CnpContext.getObjectFactory().createPayoutOrgDebit(payoutOrgDebit));
        CnpOnlineResponse response = this.sendToCnp(request);
        JAXBElement<? extends TransactionTypeWithReportGroup> newresponse = response.getTransactionResponse();
        return (PayoutOrgDebitResponse)newresponse.getValue();
    }

    private CnpOnlineRequest createCnpOnlineRequest() {
        CnpOnlineRequest request = new CnpOnlineRequest();
        request.setMerchantId(this.config.getProperty("merchantId"));
        request.setVersion(this.config.getProperty("version"));
        Authentication authentication = new Authentication();
        authentication.setPassword(this.config.getProperty("password"));
        authentication.setUser(this.config.getProperty("username"));
        request.setLoggedInUser(this.config.getProperty("loggedInUser", null));
        request.setAuthentication(authentication);
        return request;
    }

    private CnpOnlineRequest fillInMissingFieldsFromConfig(CnpOnlineRequest request) {
        CnpOnlineRequest retVal = new CnpOnlineRequest();
        retVal.setAuthentication(new Authentication());
        if (request.getAuthentication() == null) {
            Authentication authentication = new Authentication();
            authentication.setPassword(this.config.getProperty("password"));
            authentication.setUser(this.config.getProperty("username"));
            retVal.setAuthentication(authentication);
        } else {
            if (request.getAuthentication().getUser() == null) {
                retVal.getAuthentication().setUser(this.config.getProperty("username"));
            } else {
                retVal.getAuthentication().setUser(request.getAuthentication().getUser());
            }
            if (request.getAuthentication().getPassword() == null) {
                retVal.getAuthentication().setPassword(this.config.getProperty("password"));
            } else {
                retVal.getAuthentication().setPassword(request.getAuthentication().getPassword());
            }
        }
        if (request.getMerchantId() == null) {
            retVal.setMerchantId(this.config.getProperty("merchantId"));
        } else {
            retVal.setMerchantId(request.getMerchantId());
        }
        retVal.setVersion("12.19");
        if (request.getMerchantSdk() == null) {
            retVal.setMerchantSdk("Java;12.19.0");
        } else {
            retVal.setMerchantSdk(request.getMerchantSdk());
        }
        if (request.getLoggedInUser() != null) {
            retVal.setLoggedInUser(request.getLoggedInUser());
        }
        return retVal;
    }

    private CnpOnlineResponse sendToCnp(CnpOnlineRequest request) throws CnpOnlineException {
        try {
            CnpOnlineResponse response;
            String xmlResponse;
            StringWriter sw = new StringWriter();
            CnpContext.getJAXBContext().createMarshaller().marshal((Object)request, (Writer)sw);
            String xmlRequest = sw.toString();
            if (this.removeStubs.booleanValue()) {
                xmlRequest = xmlRequest.replaceAll("<[A-Za-z]+\\s*/>", "");
            }
            if ((xmlResponse = this.communication.requestToServer(xmlRequest, this.config)).contains("http://www.vantivcnp.com/schema/online")) {
                xmlResponse = xmlResponse.replace("http://www.vantivcnp.com/schema/online", "http://www.vantivcnp.com/schema");
            }
            if (!"0".equals((response = (CnpOnlineResponse)CnpContext.getJAXBContext().createUnmarshaller().unmarshal((Reader)new StringReader(xmlResponse))).getResponse())) {
                if ("2".equals(response.getResponse()) || "3".equals(response.getResponse())) {
                    throw new CnpInvalidCredentialException(response.getMessage());
                }
                if ("4".equals(response.getResponse())) {
                    throw new CnpConnectionLimitExceededException(response.getMessage());
                }
                if ("5".equals(response.getResponse())) {
                    throw new CnpObjectionableContentException(response.getMessage());
                }
                throw new CnpOnlineException(response.getMessage());
            }
            CnpOnlineResponse cnpOnlineResponse = response;
            return cnpOnlineResponse;
        }
        catch (JAXBException ume) {
            throw new CnpOnlineException("Error validating xml data against the schema", (Exception)((Object)ume));
        }
    }

    private void fillInReportGroup(TransactionTypeWithReportGroup txn) {
        if (txn.getReportGroup() == null) {
            txn.setReportGroup(this.config.getProperty("reportGroup"));
        }
    }

    private void fillInReportGroup(TransactionTypeWithReportGroupAndPartial txn) {
        if (txn.getReportGroup() == null) {
            txn.setReportGroup(this.config.getProperty("reportGroup"));
        }
    }
}

