/*
 * Decompiled with CFR 0.152.
 */
package io.github.vantiv.sdk;

import io.github.vantiv.sdk.CnpBatchException;
import io.github.vantiv.sdk.CnpBatchFileRequest;
import io.github.vantiv.sdk.CnpRFRFileResponse;
import io.github.vantiv.sdk.Communication;
import io.github.vantiv.sdk.Configuration;
import io.github.vantiv.sdk.generate.Authentication;
import io.github.vantiv.sdk.generate.CnpRequest;
import io.github.vantiv.sdk.generate.RFRRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class CnpRFRFileRequest {
    private RFRRequest rfrRequest;
    private JAXBContext jc;
    private Properties properties;
    private Communication communication;
    private String requestFileName;
    private File requestFile;
    private File responseFile;
    private String requestId;
    private Marshaller marshaller;
    private Configuration config = null;

    public CnpRFRFileRequest(String requestFileName, RFRRequest request, Properties properties) {
        this.rfrRequest = request;
        this.initializeMembers(requestFileName, properties);
        this.addRFRRequest(request);
    }

    public CnpRFRFileRequest(String requestFileName, RFRRequest request, Configuration config) {
        this.config = config;
        this.initializeMembers(requestFileName, null);
    }

    public CnpRFRFileRequest(String requestFileName, RFRRequest request) {
        this.rfrRequest = request;
        this.initializeMembers(requestFileName, null);
        this.addRFRRequest(request);
    }

    public void initializeMembers(String requestFileName, Properties in_properties) throws CnpBatchException {
        try {
            this.jc = JAXBContext.newInstance((String)"io.github.vantiv.sdk.generate");
            if (this.config == null) {
                this.config = new Configuration();
            }
            this.communication = new Communication();
            this.requestFileName = requestFileName;
            this.marshaller = this.jc.createMarshaller();
            this.marshaller.setProperty("jaxb.fragment", (Object)true);
            this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
            if (in_properties == null || in_properties.isEmpty()) {
                this.properties = new Properties();
                this.properties.load(new FileInputStream(this.config.location()));
            } else {
                this.fillInMissingFieldsFromConfig(in_properties);
                this.properties = in_properties;
            }
            this.responseFile = this.getFileToWrite("batchResponseFolder");
        }
        catch (FileNotFoundException e) {
            throw new CnpBatchException("Configuration file not found. If you are not using the .cnp_SDK_config.properties file, please use the " + CnpBatchFileRequest.class.getSimpleName() + "(String, Properties) constructor. If you are using .cnp_SDK_config.properties, you can generate one using java -jar cnp-sdk-for-java-x.xx.jar", e);
        }
        catch (IOException e) {
            throw new CnpBatchException("Configuration file could not be loaded.  Check to see if the current user has permission to access the file", e);
        }
        catch (JAXBException e) {
            throw new CnpBatchException("Unable to load jaxb dependencies.  Perhaps a classpath issue?", (Exception)((Object)e));
        }
    }

    private void addRFRRequest(RFRRequest request) {
        try {
            CnpRequest cnpRequest = this.buildCnpRequest();
            File localFile = this.getFileToWrite("batchRequestFolder");
            StringWriter writerRequest = new StringWriter();
            StringWriter writerRFR = new StringWriter();
            try {
                this.marshaller.marshal((Object)cnpRequest, (Writer)writerRequest);
                this.marshaller.marshal((Object)this.rfrRequest, (Writer)writerRFR);
            }
            catch (JAXBException e) {
                throw new CnpBatchException("Unable to load jaxb dependencies.  Perhaps a classpath issue?");
            }
            String xmlRequest = writerRequest.toString();
            xmlRequest = xmlRequest.replace("</cnpRequest>", " ");
            String xmlRFR = writerRFR.toString();
            FileOutputStream cnpReqWriter = new FileOutputStream(localFile);
            ((OutputStream)cnpReqWriter).write(xmlRequest.getBytes());
            ((OutputStream)cnpReqWriter).write(xmlRFR.getBytes());
            ((OutputStream)cnpReqWriter).write("</cnpRequest>\n".getBytes());
            this.requestFile = localFile;
            ((OutputStream)cnpReqWriter).close();
        }
        catch (IOException e) {
            throw new CnpBatchException("Error while creating a batch request file. Check to see if the current user has permission to read and write to " + this.properties.getProperty("batchRequestFolder"), e);
        }
    }

    private CnpRequest buildCnpRequest() {
        Authentication authentication = new Authentication();
        authentication.setPassword(this.properties.getProperty("password"));
        authentication.setUser(this.properties.getProperty("username"));
        CnpRequest cnpRequest = new CnpRequest();
        if (this.requestId != null && this.requestId.length() != 0) {
            cnpRequest.setId(this.requestId);
        }
        cnpRequest.setAuthentication(authentication);
        cnpRequest.setVersion("12.19");
        BigInteger numOfBatches = BigInteger.valueOf(0L);
        cnpRequest.setNumBatchRequests(numOfBatches);
        return cnpRequest;
    }

    public CnpRFRFileResponse sendToCnpSFTP() throws CnpBatchException {
        try {
            this.communication.sendCnpRequestFileToSFTP(this.requestFile, this.properties);
            this.communication.receiveCnpRequestResponseFileFromSFTP(this.requestFile, this.responseFile, this.properties);
            CnpRFRFileResponse retObj = new CnpRFRFileResponse(this.responseFile);
            return retObj;
        }
        catch (IOException e) {
            throw new CnpBatchException("There was an exception while creating the Cnp Request file. Check to see if the current user has permission to read and write to " + this.properties.getProperty("batchRequestFolder"), e);
        }
    }

    public File getFileToWrite(String locationKey) {
        String fileName = this.requestFileName;
        String writeFolderPath = this.properties.getProperty(locationKey);
        File fileToReturn = new File(writeFolderPath + File.separator + fileName);
        if (!fileToReturn.getParentFile().exists()) {
            fileToReturn.getParentFile().mkdir();
        }
        return fileToReturn;
    }

    private void fillInMissingFieldsFromConfig(Properties config) throws CnpBatchException {
        Properties localConfig = new Properties();
        boolean propertiesReadFromFile = false;
        try {
            String[] allProperties;
            for (String prop : allProperties = new String[]{"username", "password", "proxyHost", "proxyPort", "batchHost", "batchPort", "batchTcpTimeout", "batchUseSSL", "maxAllowedTransactionsPerFile", "maxTransactionsPerBatch", "batchRequestFolder", "batchResponseFolder"}) {
                if (config.getProperty(prop) != null) continue;
                if (this.properties != null && this.properties.get(prop) != null) {
                    config.setProperty(prop, this.properties.getProperty(prop));
                    continue;
                }
                if (!propertiesReadFromFile) {
                    localConfig.load(new FileInputStream(new Configuration().location()));
                    propertiesReadFromFile = true;
                }
                config.setProperty(prop, localConfig.getProperty(prop));
            }
        }
        catch (FileNotFoundException e) {
            throw new CnpBatchException("File .cnp_SDK_config.properties was not found. Please run the Setup.java application to create the file at location " + new Configuration().location(), e);
        }
        catch (IOException e) {
            throw new CnpBatchException("There was an exception while reading the .cnp_SDK_config.properties file.", e);
        }
    }

    Properties getConfig() {
        return this.properties;
    }

    void setResponseFile(File inFile) {
        this.responseFile = inFile;
    }

    public void setCommunication(Communication com) {
        this.communication = com;
    }

    public File getFile() {
        return this.requestFile;
    }
}

