/*
 * Decompiled with CFR 0.152.
 */
package io.github.vantiv.sdk;

import io.github.vantiv.sdk.CnpBatchException;
import io.github.vantiv.sdk.ResponseFileParser;
import io.github.vantiv.sdk.generate.RFRResponse;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class CnpRFRResponse {
    private RFRResponse rfrResponse;
    private ResponseFileParser responseFileParser;
    private JAXBContext jc;
    private Unmarshaller unmarshaller;

    CnpRFRResponse(RFRResponse rfrResponse) {
        this.setRFRResponse(rfrResponse);
    }

    public CnpRFRResponse(ResponseFileParser responseFileParser) throws CnpBatchException {
        this.responseFileParser = responseFileParser;
        String rfrResponseXML = "";
        try {
            rfrResponseXML = responseFileParser.getNextTag("RFRResponse");
            this.jc = JAXBContext.newInstance((String)"io.github.vantiv.sdk.generate");
            this.unmarshaller = this.jc.createUnmarshaller();
            this.rfrResponse = (RFRResponse)this.unmarshaller.unmarshal((Reader)new StringReader(rfrResponseXML));
        }
        catch (JAXBException e) {
            throw new CnpBatchException("There was an exception while trying to unmarshall rfrResponse: " + rfrResponseXML, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new CnpBatchException("There was an unknown error while parsing the response file.", e);
        }
    }

    void setRFRResponse(RFRResponse rfrResponse) {
        this.rfrResponse = rfrResponse;
    }

    RFRResponse getRFRResponse() {
        return this.rfrResponse;
    }

    public String getRFRResponseCode() {
        return this.rfrResponse.getResponse();
    }

    public String getRFRResponseMessage() {
        return this.rfrResponse.getMessage();
    }
}

