/*
 * Decompiled with CFR 0.152.
 */
package io.github.vantiv.sdk;

import io.github.vantiv.sdk.RequestTarget;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class CommManager {
    public static final int REQUEST_RESULT_RESPONSE_RECEIVED = 1;
    public static final int REQUEST_RESULT_CONNECTION_FAILED = 2;
    public static final int REQUEST_RESULT_RESPONSE_TIMEOUT = 3;
    private static CommManager manager = null;
    protected Properties configuration;
    protected boolean doMultiSite = false;
    protected String legacyUrl;
    protected List<String> multiSiteUrls = new ArrayList<String>();
    protected int errorCount = 0;
    protected int currentMultiSiteUrlIndex = 0;
    protected int multiSiteThreshold = 5;
    protected long lastSiteSwitchTime = 0L;
    protected int maxHoursWithoutSwitch = 48;
    protected SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected boolean printDebug = false;

    public static CommManager instance(Properties config) {
        if (manager == null) {
            manager = new CommManager(config);
        }
        return manager;
    }

    public static void reset() {
        manager = null;
    }

    private CommManager(Properties config) {
        this.configuration = config;
        this.legacyUrl = this.configuration.getProperty("url");
        this.doMultiSite = Boolean.valueOf(this.configuration.getProperty("multiSite", "false"));
        this.printDebug = Boolean.valueOf(this.configuration.getProperty("printMultiSiteDebug", "false"));
        if (this.doMultiSite) {
            String siteUrl;
            for (int x = 1; x < 3 && (siteUrl = this.configuration.getProperty("multiSiteUrl" + x)) != null; ++x) {
                this.multiSiteUrls.add(siteUrl);
            }
            if (this.multiSiteUrls.size() == 0) {
                this.doMultiSite = false;
            } else {
                int t;
                String maxHours;
                int t2;
                Collections.shuffle(this.multiSiteUrls);
                this.currentMultiSiteUrlIndex = 0;
                this.errorCount = 0;
                String threshold = this.configuration.getProperty("multiSiteErrorThreshold");
                if (threshold != null && (t2 = Integer.parseInt(threshold)) > 0 && t2 < 100) {
                    this.multiSiteThreshold = t2;
                }
                if ((maxHours = this.configuration.getProperty("maxHoursWithoutSwitch")) != null && (t = Integer.parseInt(maxHours)) >= 0 && t < 300) {
                    this.maxHoursWithoutSwitch = t;
                }
                this.lastSiteSwitchTime = System.currentTimeMillis();
            }
        }
    }

    public synchronized RequestTarget findUrl() {
        String url = this.legacyUrl;
        if (this.doMultiSite) {
            boolean switchSite = false;
            String switchReason = "";
            String currentUrl = this.multiSiteUrls.get(this.currentMultiSiteUrlIndex);
            if (this.errorCount < this.multiSiteThreshold) {
                long diffSinceSwitch;
                if (this.maxHoursWithoutSwitch > 0 && (diffSinceSwitch = (System.currentTimeMillis() - this.lastSiteSwitchTime) / 3600000L) > (long)this.maxHoursWithoutSwitch) {
                    switchReason = " more than " + this.maxHoursWithoutSwitch + " hours since last switch";
                    switchSite = true;
                }
            } else {
                switchReason = " consecutive error count has reached threshold of " + this.multiSiteThreshold;
                switchSite = true;
            }
            if (switchSite) {
                ++this.currentMultiSiteUrlIndex;
                if (this.currentMultiSiteUrlIndex >= this.multiSiteUrls.size()) {
                    this.currentMultiSiteUrlIndex = 0;
                }
                url = this.multiSiteUrls.get(this.currentMultiSiteUrlIndex);
                this.errorCount = 0;
                if (this.printDebug) {
                    Date switchDate = new Date();
                    this.lastSiteSwitchTime = switchDate.getTime();
                    System.out.println(this.dateFormatter.format(switchDate) + "  Switched to " + url + " because " + switchReason);
                }
            } else {
                url = currentUrl;
            }
        }
        if (this.printDebug) {
            System.out.println("Selected URL: " + url);
        }
        return new RequestTarget(url, this.currentMultiSiteUrlIndex);
    }

    public synchronized void reportResult(RequestTarget target, int result, int statusCode) {
        if (target.getRequestTime() < this.lastSiteSwitchTime || !this.doMultiSite) {
            return;
        }
        switch (result) {
            case 1: {
                if (statusCode == 200) {
                    this.errorCount = 0;
                    break;
                }
                if (statusCode < 400) break;
                ++this.errorCount;
                break;
            }
            case 2: {
                ++this.errorCount;
                break;
            }
            case 3: {
                ++this.errorCount;
            }
        }
    }
}

