/*
 * Decompiled with CFR 0.152.
 */
package io.github.vantiv.sdk;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import io.github.vantiv.sdk.CnpBatchException;
import io.github.vantiv.sdk.CnpOnlineException;
import io.github.vantiv.sdk.CommManager;
import io.github.vantiv.sdk.RequestTarget;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

public class Communication {
    private static final String[] SUPPORTED_PROTOCOLS = new String[]{"TLSv1.2", "TLSv1.1"};
    public static final String CONTENT_TYPE_TEXT_XML_UTF8 = "text/xml; charset=UTF-8";
    private CloseableHttpClient httpClient;
    private final int KEEP_ALIVE_DURATION = 8000;
    private static final String NEUTER_STR = "NEUTERED";

    public Communication() {
        try {
            String protocol = Communication.getBestProtocol(SSLContext.getDefault().getSupportedSSLParameters().getProtocols());
            if (protocol == null) {
                throw new IllegalStateException("No supported TLS protocols available");
            }
            SSLContext ctx = SSLContexts.custom().useProtocol(protocol).build();
            PlainConnectionSocketFactory plainSocketFactory = new PlainConnectionSocketFactory();
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(ctx);
            Registry registry = RegistryBuilder.create().register("http", (Object)plainSocketFactory).register("https", (Object)sslSocketFactory).build();
            BasicHttpClientConnectionManager manager = new BasicHttpClientConnectionManager((Lookup)registry);
            DefaultHttpRequestRetryHandler requestRetryHandler = new DefaultHttpRequestRetryHandler(0, true);
            ConnectionKeepAliveStrategy keepAliveStrategy = new ConnectionKeepAliveStrategy(){

                public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                    return 8000L;
                }
            };
            this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)manager).setRetryHandler((HttpRequestRetryHandler)requestRetryHandler).setKeepAliveStrategy(keepAliveStrategy).build();
        }
        catch (GeneralSecurityException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static String getBestProtocol(String[] availableProtocols) {
        String bestProtocol = null;
        if (availableProtocols == null || availableProtocols.length == 0) {
            return bestProtocol;
        }
        List<String> availableProtocolsList = Arrays.asList(availableProtocols);
        for (String supportedProtocol : SUPPORTED_PROTOCOLS) {
            if (!availableProtocolsList.contains(supportedProtocol)) continue;
            bestProtocol = supportedProtocol;
            break;
        }
        return bestProtocol;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String requestToServer(String xmlRequest, Properties configuration) {
        String xmlResponse;
        HttpPost post;
        block13: {
            RequestConfig requestConfig;
            String proxyHost = configuration.getProperty("proxyHost");
            String proxyPort = configuration.getProperty("proxyPort");
            boolean httpKeepAlive = Boolean.valueOf(configuration.getProperty("httpKeepAlive", "false"));
            int httpTimeout = Integer.valueOf(configuration.getProperty("timeout", "6000"));
            if (proxyHost != null && proxyHost.length() > 0 && proxyPort != null && proxyHost.length() > 0) {
                HttpHost proxy = new HttpHost(proxyHost, Integer.valueOf(proxyPort).intValue());
                requestConfig = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setProxy(proxy).setSocketTimeout(httpTimeout).setConnectTimeout(httpTimeout).build();
            } else {
                requestConfig = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setSocketTimeout(httpTimeout).setConnectTimeout(httpTimeout).build();
            }
            RequestTarget reqTarget = CommManager.instance(configuration).findUrl();
            post = new HttpPost(reqTarget.getUrl());
            post.setHeader("Content-Type", CONTENT_TYPE_TEXT_XML_UTF8);
            if (!httpKeepAlive) {
                post.setHeader("Connection", "close");
            }
            post.setConfig(requestConfig);
            HttpEntity entity = null;
            try {
                boolean printxml = "true".equalsIgnoreCase(configuration.getProperty("printxml"));
                boolean neuterXml = "true".equalsIgnoreCase(configuration.getProperty("neuterXml"));
                if (printxml) {
                    this.printXml(xmlRequest, neuterXml);
                }
                post.setEntity((HttpEntity)new StringEntity(xmlRequest, "UTF-8"));
                CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);
                entity = response.getEntity();
                CommManager.instance(configuration).reportResult(reqTarget, 1, response.getStatusLine().getStatusCode());
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new CnpOnlineException(response.getStatusLine().getStatusCode() + ":" + response.getStatusLine().getReasonPhrase());
                }
                xmlResponse = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                if (printxml) {
                    if (neuterXml) {
                        xmlResponse = this.neuterXml(xmlResponse);
                    }
                    System.out.println("Response XML: " + xmlResponse);
                }
                if (entity == null) break block13;
            }
            catch (IOException e) {
                try {
                    int result = 2;
                    if (e instanceof NoHttpResponseException) {
                        result = 3;
                    }
                    CommManager.instance(configuration).reportResult(reqTarget, result, 0);
                    throw new CnpOnlineException("Exception connection to Vantiv eCommerce", e);
                }
                catch (Throwable throwable) {
                    if (entity != null) {
                        EntityUtils.consumeQuietly(entity);
                    }
                    post.abort();
                    throw throwable;
                }
            }
            EntityUtils.consumeQuietly((HttpEntity)entity);
        }
        post.abort();
        return xmlResponse;
    }

    public void sendCnpRequestFileToSFTP(File requestFile, Properties configuration) throws IOException {
        boolean printxml;
        Channel channel;
        Session session = this.setupSession(configuration);
        try {
            channel = session.openChannel("sftp");
            channel.connect();
        }
        catch (JSchException e) {
            throw new CnpBatchException("Exception connection to Vantiv eCommerce : error in session.openChannel/channel.connect", (Exception)((Object)e));
        }
        ChannelSftp sftp = (ChannelSftp)channel;
        boolean bl = printxml = configuration.getProperty("printxml") != null && configuration.getProperty("printxml").equalsIgnoreCase("true");
        if (printxml) {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(requestFile));
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
            reader.close();
        }
        try {
            sftp.put(requestFile.getAbsolutePath(), "inbound/" + requestFile.getName() + ".prg");
            sftp.rename("inbound/" + requestFile.getName() + ".prg", "inbound/" + requestFile.getName() + ".asc");
        }
        catch (SftpException e) {
            throw new CnpBatchException("Exception in sFTP operation", (Exception)((Object)e));
        }
        channel.disconnect();
        session.disconnect();
    }

    public void receiveCnpRequestResponseFileFromSFTP(File requestFile, File responseFile, Properties configuration) throws IOException {
        boolean printxml;
        Channel channel;
        Session session = this.setupSession(configuration);
        try {
            channel = session.openChannel("sftp");
            channel.connect();
        }
        catch (JSchException e) {
            throw new CnpBatchException("Exception connection to Vantiv eCommerce : error in session.openChannel/channel.connect", (Exception)((Object)e));
        }
        ChannelSftp sftp = (ChannelSftp)channel;
        Long start = System.currentTimeMillis();
        Long timeout = Long.parseLong(configuration.getProperty("sftpTimeout"));
        System.out.println("Retrieving from sFTP...");
        while (System.currentTimeMillis() - start < timeout) {
            try {
                Thread.sleep(45000L);
            }
            catch (InterruptedException e) {
                System.out.println(e);
            }
            boolean success = true;
            try {
                sftp.get("outbound/" + requestFile.getName() + ".asc", responseFile.getAbsolutePath());
            }
            catch (SftpException e) {
                success = false;
                System.out.println((Object)e);
            }
            if (success) {
                try {
                    sftp.rm("outbound/" + requestFile.getName() + ".asc");
                    break;
                }
                catch (SftpException e) {
                    throw new CnpBatchException("Exception in sFTP operation", (Exception)((Object)e));
                }
            }
            System.out.print(".");
        }
        boolean bl = printxml = configuration.getProperty("printxml") != null && configuration.getProperty("printxml").equalsIgnoreCase("true");
        if (printxml) {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(responseFile));
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
            reader.close();
        }
        channel.disconnect();
        session.disconnect();
    }

    private Session setupSession(Properties configuration) {
        Session session;
        String username = configuration.getProperty("sftpUsername");
        String password = configuration.getProperty("sftpPassword");
        String hostname = configuration.getProperty("batchHost");
        String portStr = configuration.getProperty("sftpPort");
        int port = -1;
        if (portStr != null && portStr != "") {
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                throw new CnpBatchException("Exception parsing sftpPort from config", e);
            }
        }
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        try {
            JSch jsch = new JSch();
            session = port != -1 ? jsch.getSession(username, hostname, port) : jsch.getSession(username, hostname);
            session.setConfig(config);
            session.setPassword(password);
            session.connect();
        }
        catch (JSchException e) {
            throw new CnpBatchException("Exception connection to Vantiv eCommerce : error in session.connect", (Exception)((Object)e));
        }
        return session;
    }

    public String neuterXml(String xml) {
        if (xml == null) {
            return xml;
        }
        xml = xml.replaceAll("<accNum>.*</accNum>", "<accNum>NEUTERED</accNum>");
        xml = xml.replaceAll("<user>.*</user>", "<user>NEUTERED</user>");
        xml = xml.replaceAll("<password>.*</password>", "<password>NEUTERED</password>");
        xml = xml.replaceAll("<track>.*</track>", "<track>NEUTERED</track>");
        xml = xml.replaceAll("<number>.*</number>", "<number>NEUTERED</number>");
        xml = xml.replaceAll("<cardValidationNum>.*</cardValidationNum>", "<cardValidationNum>NEUTERED</cardValidationNum>");
        return xml;
    }

    public String printXml(String xmlRequest, boolean neuterXml) {
        String xmlToLog = xmlRequest;
        if (neuterXml) {
            xmlToLog = this.neuterXml(xmlToLog);
        }
        System.out.println("Request XML: " + xmlToLog);
        return xmlRequest;
    }
}

