/*
 * Decompiled with CFR 0.152.
 */
package io.github.vantiv.sdk;

import io.github.vantiv.sdk.DecryptedInputStream;
import io.github.vantiv.sdk.EncryptedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Date;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;

public class PgpHelper {
    public static PGPPublicKey readPublicKey(InputStream in) throws IOException, PGPException {
        InputStream decoderStream = PGPUtil.getDecoderStream((InputStream)in);
        PGPPublicKeyRingCollection pgpPub = new PGPPublicKeyRingCollection(decoderStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        PGPPublicKey pgpPublicKey = null;
        Iterator pgpPublicKeyRingIterator = pgpPub.getKeyRings();
        while (pgpPublicKey == null && pgpPublicKeyRingIterator.hasNext()) {
            PGPPublicKeyRing kRing = (PGPPublicKeyRing)pgpPublicKeyRingIterator.next();
            Iterator publicKeys = kRing.getPublicKeys();
            while (pgpPublicKey == null && publicKeys.hasNext()) {
                PGPPublicKey publicKey = (PGPPublicKey)publicKeys.next();
                if (!publicKey.isEncryptionKey()) continue;
                pgpPublicKey = publicKey;
            }
        }
        decoderStream.close();
        if (pgpPublicKey == null) {
            throw new IllegalArgumentException("Can't find encryption key in key ring.");
        }
        return pgpPublicKey;
    }

    public static PGPPrivateKey findSecretKey(InputStream keyIn, long keyID, char[] pass) throws IOException, PGPException {
        PGPSecretKeyRingCollection pgpSecretKeyRingCollection = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)keyIn), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        PGPSecretKey pgpSecretKeyKey = pgpSecretKeyRingCollection.getSecretKey(keyID);
        if (pgpSecretKeyKey == null) {
            return null;
        }
        PBESecretKeyDecryptor secretKeyDecryptor = new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(pass);
        return pgpSecretKeyKey.extractPrivateKey(secretKeyDecryptor);
    }

    public static void decrypt(String inputFilepath, String outputFilepath, String privateKeyPath, String passphrase) throws IOException, PGPException {
        int len;
        InputStream decryptionInputStream = PgpHelper.decryptionStream(inputFilepath, privateKeyPath, passphrase);
        FileOutputStream fileOutputStream = new FileOutputStream(outputFilepath);
        byte[] clearData = new byte[0x200000];
        while ((len = decryptionInputStream.read(clearData)) > 0) {
            ((OutputStream)fileOutputStream).write(clearData, 0, len);
        }
        ((OutputStream)fileOutputStream).close();
        decryptionInputStream.close();
    }

    public static InputStream decryptionStream(String inputFilepath, String privateKeyPath, String passphrase) throws IOException, PGPException {
        PGPLiteralData literalData;
        Object pgpFact;
        InputStream fileInputStream = new FileInputStream(inputFilepath);
        Security.addProvider((Provider)new BouncyCastleProvider());
        fileInputStream = PGPUtil.getDecoderStream((InputStream)fileInputStream);
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(fileInputStream);
        Object obj = jcaPGPObjectFactory.nextObject();
        PGPEncryptedDataList encryptedDataList = obj instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)obj : (PGPEncryptedDataList)jcaPGPObjectFactory.nextObject();
        Iterator pgpPublicKeyEncryptedDataIterator = encryptedDataList.getEncryptedDataObjects();
        PGPPrivateKey pgpPrivateKey = null;
        PGPPublicKeyEncryptedData pgpPublicKeyEncryptedData = null;
        while (pgpPrivateKey == null && pgpPublicKeyEncryptedDataIterator.hasNext()) {
            pgpPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)pgpPublicKeyEncryptedDataIterator.next();
            pgpPrivateKey = PgpHelper.findSecretKey(new FileInputStream(privateKeyPath), pgpPublicKeyEncryptedData.getKeyID(), passphrase.toCharArray());
        }
        if (pgpPrivateKey == null) {
            throw new IllegalArgumentException("Secret key for message not found.");
        }
        InputStream clearDataStream = pgpPublicKeyEncryptedData.getDataStream(new JcePublicKeyDataDecryptorFactoryBuilder().setProvider("BC").build(pgpPrivateKey));
        JcaPGPObjectFactory plainFact = new JcaPGPObjectFactory(clearDataStream);
        Object message = plainFact.nextObject();
        if (message instanceof PGPCompressedData) {
            PGPCompressedData compressedData = (PGPCompressedData)message;
            pgpFact = new JcaPGPObjectFactory(compressedData.getDataStream());
            message = pgpFact.nextObject();
        }
        if (message instanceof PGPLiteralData) {
            literalData = (PGPLiteralData)message;
            pgpFact = literalData.getInputStream();
        }
        if (message instanceof PGPLiteralData) {
            literalData = (PGPLiteralData)message;
            InputStream literalDataInputStream = literalData.getInputStream();
            return new DecryptedInputStream(literalDataInputStream, fileInputStream, clearDataStream);
        }
        if (message instanceof PGPOnePassSignatureList) {
            throw new PGPException("Encrypted message contains a signed message - not literal data.");
        }
        throw new PGPException("Message is not a simple encrypted file - type unknown.");
    }

    public static void encrypt(String inputFilePath, String outputFilepath, String publicKeyPath) throws IOException, PGPException {
        int len;
        OutputStream encryptionOutputStream = PgpHelper.encryptionStream(outputFilepath, publicKeyPath);
        FileInputStream fileInputStream = new FileInputStream(inputFilePath);
        byte[] clearData = new byte[0x200000];
        while ((len = ((InputStream)fileInputStream).read(clearData)) > 0) {
            encryptionOutputStream.write(clearData, 0, len);
        }
        encryptionOutputStream.close();
        ((InputStream)fileInputStream).close();
    }

    public static OutputStream encryptionStream(String outputFilepath, String publicKeyPath) throws IOException, PGPException {
        FileOutputStream fileOutputStream = new FileOutputStream(outputFilepath);
        fileOutputStream = new ArmoredOutputStream((OutputStream)fileOutputStream);
        PGPPublicKey pgpPublicKey = PgpHelper.readPublicKey(new FileInputStream(publicKeyPath));
        Security.addProvider((Provider)new BouncyCastleProvider());
        JcePGPDataEncryptorBuilder c = new JcePGPDataEncryptorBuilder(3).setSecureRandom(new SecureRandom()).setProvider("BC");
        PGPEncryptedDataGenerator cPk = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)c);
        JcePublicKeyKeyEncryptionMethodGenerator d = new JcePublicKeyKeyEncryptionMethodGenerator(pgpPublicKey).setProvider((Provider)new BouncyCastleProvider()).setSecureRandom(new SecureRandom());
        cPk.addMethod((PGPKeyEncryptionMethodGenerator)d);
        OutputStream encOut = cPk.open((OutputStream)fileOutputStream, new byte[0x200000]);
        PGPLiteralDataGenerator lData = new PGPLiteralDataGenerator();
        OutputStream pOut = lData.open(encOut, 'b', "iway", new Date(), new byte[0x200000]);
        return new EncryptedOutputStream(encOut, fileOutputStream, pOut);
    }
}

