/*
 * Decompiled with CFR 0.152.
 */
package io.github.vantiv.sdk;

import io.github.vantiv.sdk.generate.CnpTransactionInterface;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.regex.Pattern;

public class ResponseFileParser
implements AutoCloseable {
    private static final String GENERATE_PACKAGE_NAME = "io.github.vantiv.sdk.generate";
    private InputStream in = null;
    private Reader reader = null;
    private Reader buffer = null;

    public ResponseFileParser(File responseFile) {
        try {
            this.in = new FileInputStream(responseFile);
            this.reader = new InputStreamReader(this.in);
            this.buffer = new BufferedReader(this.reader);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public String getNextTag(String tagToLookFor) throws Exception {
        int r;
        StringBuilder currentStartingTagInFile = new StringBuilder();
        StringBuilder retStringBuf = new StringBuilder();
        StringBuilder currentEndingTagInFile = new StringBuilder();
        boolean startRecordingStartingTag = false;
        boolean startRecordingEndingTag = false;
        boolean startRecordingRetString = false;
        char lastChar = '\u0000';
        String openingTagToLookFor = "<" + tagToLookFor;
        String closingTagToLookFor = "</" + tagToLookFor + ">";
        while ((r = this.buffer.read()) != -1) {
            char ch = (char)r;
            if (startRecordingRetString) {
                retStringBuf.append(ch);
                if (lastChar == '<' && ch == '/') {
                    startRecordingEndingTag = true;
                    currentEndingTagInFile.append(lastChar);
                }
                if ((tagToLookFor.compareToIgnoreCase("batchResponse") == 0 || tagToLookFor.compareToIgnoreCase("cnpResponse") == 0) && ch == '>') {
                    retStringBuf.append(closingTagToLookFor);
                    break;
                }
            }
            if (ch == '<' && !startRecordingRetString) {
                startRecordingStartingTag = true;
            }
            if (startRecordingStartingTag) {
                currentStartingTagInFile.append(ch);
                if (this.okToStartOrStopRecordingString(openingTagToLookFor, currentStartingTagInFile.toString())) {
                    startRecordingRetString = true;
                    retStringBuf.append((CharSequence)currentStartingTagInFile);
                    if (openingTagToLookFor.compareToIgnoreCase("<cnpResponse") != 0) {
                        retStringBuf.append(" xmlns=\"http://www.vantivcnp.com/schema\"");
                    }
                    startRecordingStartingTag = false;
                    currentStartingTagInFile.delete(0, currentStartingTagInFile.length());
                }
                if (ch == '>') {
                    if (tagToLookFor.compareToIgnoreCase("transactionResponse") == 0 && currentStartingTagInFile.toString().compareToIgnoreCase("</batchResponse>") == 0) {
                        throw new Exception("All payments in this batch have already been retrieved.");
                    }
                    startRecordingStartingTag = false;
                    currentStartingTagInFile.delete(0, currentStartingTagInFile.length());
                }
            }
            if (startRecordingEndingTag) {
                currentEndingTagInFile.append(ch);
                if (ch == '>') {
                    startRecordingEndingTag = false;
                    if (this.okToStartOrStopRecordingString(closingTagToLookFor, currentEndingTagInFile.toString())) break;
                    currentEndingTagInFile.delete(0, currentEndingTagInFile.length());
                }
            }
            lastChar = ch;
        }
        return retStringBuf.toString();
    }

    private boolean okToStartOrStopRecordingString(String tagToLookFor, String currentStartingTagInFile) {
        return tagToLookFor.contains("transactionResponse") && ResponseFileParser.isTransactionResponse(currentStartingTagInFile.replaceAll("[</>]", "")) || tagToLookFor.equalsIgnoreCase(currentStartingTagInFile);
    }

    static boolean isTransactionResponse(String tagName) {
        Class<?> responseClass;
        if (!Pattern.matches("\\w+Response", tagName)) {
            return false;
        }
        String responseClassName = "io.github.vantiv.sdk.generate." + tagName.substring(0, 1).toUpperCase() + tagName.substring(1);
        try {
            responseClass = Class.forName(responseClassName);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        LinkedList queue = new LinkedList(Collections.singleton(responseClass));
        while (!queue.isEmpty()) {
            boolean isTransaction;
            Class<?> clazz = queue.poll();
            HashSet supers = new HashSet(Arrays.asList(clazz.getInterfaces()));
            if (clazz.getSuperclass() != null) {
                supers.add(clazz.getSuperclass());
            }
            if (isTransaction = supers.contains(CnpTransactionInterface.class)) {
                return true;
            }
            queue.addAll(supers);
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        if (this.reader != null) {
            this.reader.close();
        }
        if (this.buffer != null) {
            this.buffer.close();
        }
    }

    @Deprecated
    public void closeResources() throws IOException {
        this.close();
    }
}

