/*
 * Decompiled with CFR 0.152.
 */
package io.github.vdaburon.jmeter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.inject.Parameters;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="create-graph")
public class JMeterPluginsMojo
extends AbstractMojo {
    static final String JMETER_CONFIG_ARTIFACT_NAME = "ApacheJMeter_config";
    static final String JMETER_PLUGINS_ARTIFACT_NAME1 = "cmdrunner";
    static final String JMETER_PLUGINS_ARTIFACT_NAME2 = "jmeter-plugins";
    static final String JMETER_ARTIFACT_NAME = "ApacheJMeter";
    static final String JMETER_CORE_ARTIFACT_NAME = "ApacheJMeter_core";
    static final String JMETER_HTTP_ARTIFACT_NAME = "ApacheJMeter_http";
    static final String COMMON_IO_NAME = "commons-io";
    @Parameter
    File directoryTestFiles;
    @Parameter
    List<Graph> graphs;
    @Parameter
    List<FilterResultParam> filterResultsTool;
    @Parameter
    JMeterProcessJVMSettings jMeterProcessJVMSettings;
    @Parameters
    List<String> arguments;
    @Parameter
    Map<String, String> propertiesUser;
    @Parameter(defaultValue="${project.build.directory}/jmeter")
    File workingDirectory;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true)
    MavenSession mavenSession;
    @Component
    BuildPluginManager pluginManager;
    @Parameter(defaultValue="${plugin}", readonly=true)
    PluginDescriptor plugin;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Object parentArgs;
        ArrayList<MojoExecutor.Element> elements;
        MojoExecutor.Element elt;
        Vector<MojoExecutor.Element> listArguments;
        if (this.graphs == null && this.filterResultsTool == null) {
            this.getLog().error((CharSequence)"Error no graph defined and no filter defined");
            return;
        }
        File binDir = new File(this.workingDirectory.getAbsolutePath() + File.separator + "bin");
        File logDir = new File(this.workingDirectory.getAbsolutePath() + File.separator + "log");
        File libDir = new File(this.workingDirectory.getAbsolutePath() + File.separator + "lib");
        File libExtDir = new File(libDir.getAbsolutePath() + File.separator + "ext");
        this.createDirectoryIfNotExists(this.workingDirectory);
        this.createDirectoryIfNotExists(binDir);
        this.createDirectoryIfNotExists(logDir);
        this.createDirectoryIfNotExists(libDir);
        this.createDirectoryIfNotExists(libExtDir);
        for (Artifact artifact : this.plugin.getArtifacts()) {
            try {
                File artifactDestination;
                if (JMETER_CONFIG_ARTIFACT_NAME.equals(artifact.getArtifactId())) {
                    this.getLog().info((CharSequence)("Copy configuration files to " + binDir.getAbsolutePath()));
                    JarFile jarFile = new JarFile(artifact.getFile());
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (entry.isDirectory() || !entry.getName().startsWith("bin") || !entry.getName().endsWith(".properties") && !entry.getName().endsWith(".xml") && !entry.getName().endsWith(".bsh")) continue;
                        File configFileDestination = new File(this.workingDirectory + File.separator + entry.getName());
                        this.getLog().debug((CharSequence)("Write configuration " + configFileDestination.getAbsoluteFile()));
                        FileUtils.copyInputStreamToFile((InputStream)jarFile.getInputStream(entry), (File)configFileDestination);
                    }
                    jarFile.close();
                    continue;
                }
                if (this.isJMeterDependency(artifact)) {
                    this.getLog().debug((CharSequence)("Copy artifact " + artifact.toString() + " to " + libDir.getAbsolutePath()));
                    artifactDestination = new File(libDir.getAbsolutePath() + File.separator + artifact.getArtifactId() + ".jar");
                    FileUtils.copyFile((File)artifact.getFile(), (File)artifactDestination);
                    continue;
                }
                if (!this.isJMeterPluginsDependency(artifact)) continue;
                this.getLog().debug((CharSequence)("Copy artifact " + artifact.toString() + " to " + libExtDir.getAbsolutePath()));
                artifactDestination = new File(libExtDir.getAbsolutePath() + File.separator + artifact.getArtifactId() + ".jar");
                FileUtils.copyFile((File)artifact.getFile(), (File)artifactDestination);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not copy JMeter dependencies to working directory", (Exception)e);
            }
        }
        if (this.directoryTestFiles != null) {
            this.getLog().info((CharSequence)("directoryConfigure=" + this.directoryTestFiles.getAbsolutePath()));
            if (this.directoryTestFiles.isDirectory()) {
                this.getLog().info((CharSequence)("Copy files in directory (directoryTestFiles) : " + this.directoryTestFiles.getAbsolutePath() + " to " + binDir.getAbsolutePath()));
                try {
                    FileUtils.copyDirectory((File)this.directoryTestFiles, (File)binDir);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.getLog().warn((CharSequence)("WARN directoryTestFiles is not a directory : " + this.directoryTestFiles.getAbsolutePath()));
            }
        }
        if (this.propertiesUser != null) {
            Properties userProp = new Properties();
            try {
                FileInputStream fileStream = new FileInputStream(binDir.getAbsolutePath() + "/user.properties");
                try {
                    userProp.load(fileStream);
                    ((InputStream)fileStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            for (Map.Entry<String, String> entry : this.propertiesUser.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                userProp.put(key, value);
                this.getLog().info((CharSequence)("Merge user properties, add key : " + key + " value : " + value + " to user.properties"));
            }
            try {
                FileOutputStream output = new FileOutputStream(binDir.getAbsolutePath() + "/user.properties");
                userProp.store(output, "user.properties merged");
                ((OutputStream)output).close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.filterResultsTool != null) {
            for (FilterResultParam filterResultParam : this.filterResultsTool) {
                this.getLog().info((CharSequence)("Filtering results: " + filterResultParam != null ? filterResultParam.toString() : "<null>"));
                try {
                    listArguments = new Vector<MojoExecutor.Element>();
                    elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"-Dlog_file=");
                    listArguments.add(elt);
                    if (this.jMeterProcessJVMSettings != null) {
                        this.getLog().info((CharSequence)("Creating jMeterProcessJVMSettings: " + this.jMeterProcessJVMSettings != null ? this.jMeterProcessJVMSettings.toString() : "<null>"));
                        if (this.jMeterProcessJVMSettings.xms != null) {
                            elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)("-Xms" + String.valueOf(this.jMeterProcessJVMSettings.xms) + "m"));
                            listArguments.add(elt);
                        }
                        if (this.jMeterProcessJVMSettings.xmx != null) {
                            elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)("-Xmx" + String.valueOf(this.jMeterProcessJVMSettings.xmx) + "m"));
                            listArguments.add(elt);
                        }
                        if (this.jMeterProcessJVMSettings.arguments != null) {
                            for (int i = 0; i < this.jMeterProcessJVMSettings.arguments.size(); ++i) {
                                elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)this.jMeterProcessJVMSettings.arguments.get(i));
                                listArguments.add(elt);
                            }
                        }
                    }
                    if (System.getProperty("log4j.configurationFile") == null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)("-Dlog4j.configurationFile=" + binDir + "/log4j2.xml"));
                        listArguments.add(elt);
                    }
                    elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"-classpath");
                    listArguments.add(elt);
                    elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)(libDir.getAbsolutePath() + File.separator + "*" + File.pathSeparator + libExtDir.getAbsolutePath() + File.separator + "*"));
                    listArguments.add(elt);
                    elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"kg.apc.cmd.UniversalRunner");
                    listArguments.add(elt);
                    elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--tool");
                    listArguments.add(elt);
                    elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"FilterResults");
                    listArguments.add(elt);
                    if (filterResultParam.inputFile == null) {
                        this.getLog().error((CharSequence)"Error filter inputFile is mandatory and inputFile=null");
                        continue;
                    }
                    elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--input-file");
                    listArguments.add(elt);
                    elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)filterResultParam.inputFile.getAbsolutePath());
                    listArguments.add(elt);
                    if (filterResultParam.outputFile == null) {
                        this.getLog().error((CharSequence)"Error filter outputFile is mandatory and outputFile=null");
                        continue;
                    }
                    elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--output-file");
                    listArguments.add(elt);
                    elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)filterResultParam.outputFile.getAbsolutePath());
                    listArguments.add(elt);
                    if (filterResultParam.successFilter != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--success-filter");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)String.valueOf(filterResultParam.successFilter));
                        listArguments.add(elt);
                    }
                    if (filterResultParam.includeLabels != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--include-labels");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)filterResultParam.includeLabels);
                        listArguments.add(elt);
                    }
                    if (filterResultParam.excludeLabels != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--exclude-labels");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)filterResultParam.excludeLabels);
                        listArguments.add(elt);
                    }
                    if (filterResultParam.includeLabelRegex != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--include-label-regex");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)String.valueOf(filterResultParam.includeLabelRegex));
                        listArguments.add(elt);
                    }
                    if (filterResultParam.excludeLabelRegex != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--exclude-label-regex");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)String.valueOf(filterResultParam.excludeLabelRegex));
                        listArguments.add(elt);
                    }
                    if (filterResultParam.startOffset != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--start-offset");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)String.valueOf(filterResultParam.startOffset));
                        listArguments.add(elt);
                    }
                    if (filterResultParam.endOffset != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--end-offset");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)String.valueOf(filterResultParam.endOffset));
                        listArguments.add(elt);
                    }
                    if (filterResultParam.saveAsXml != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--save-as-xml");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)String.valueOf(filterResultParam.saveAsXml));
                        listArguments.add(elt);
                    }
                    ArrayList<MojoExecutor.Element> configuration = new ArrayList<MojoExecutor.Element>();
                    configuration.add(MojoExecutor.element((String)"executable", (String)"java"));
                    elements = new ArrayList<MojoExecutor.Element>();
                    for (MojoExecutor.Element argument : listArguments) {
                        elements.add(argument);
                    }
                    parentArgs = new MojoExecutor.Element("arguments", elements.toArray(new MojoExecutor.Element[0]));
                    configuration.add((MojoExecutor.Element)parentArgs);
                    MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.codehaus.mojo"), (String)MojoExecutor.artifactId((String)"exec-maven-plugin"), (String)MojoExecutor.version((String)"1.2.1")), (String)MojoExecutor.goal((String)"exec"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])configuration.toArray(new MojoExecutor.Element[0])), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        }
        if (this.graphs != null) {
            for (Graph graph : this.graphs) {
                this.getLog().info((CharSequence)("Creating graph: " + graph != null ? graph.toString() : "<null>"));
                try {
                    listArguments = new Vector();
                    elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"-Dlog_file=");
                    listArguments.add(elt);
                    if (this.jMeterProcessJVMSettings != null) {
                        this.getLog().info((CharSequence)("Creating jMeterProcessJVMSettings: " + this.jMeterProcessJVMSettings != null ? this.jMeterProcessJVMSettings.toString() : "<null>"));
                        if (this.jMeterProcessJVMSettings.xms != null) {
                            elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)("-Xms" + String.valueOf(this.jMeterProcessJVMSettings.xms) + "m"));
                            listArguments.add(elt);
                        }
                        if (this.jMeterProcessJVMSettings.xmx != null) {
                            elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)("-Xmx" + String.valueOf(this.jMeterProcessJVMSettings.xmx) + "m"));
                            listArguments.add(elt);
                        }
                        if (this.jMeterProcessJVMSettings.arguments != null) {
                            for (String anArgument : this.jMeterProcessJVMSettings.arguments) {
                                elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)anArgument);
                                listArguments.add(elt);
                            }
                        }
                    }
                    if (System.getProperty("log4j.configurationFile") == null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)("-Dlog4j.configurationFile=" + binDir + "/log4j2.xml"));
                        listArguments.add(elt);
                    }
                    elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"-classpath");
                    listArguments.add(elt);
                    elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)(libDir.getAbsolutePath() + File.separator + "*" + File.pathSeparator + libExtDir.getAbsolutePath() + File.separator + "*"));
                    listArguments.add(elt);
                    elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"kg.apc.cmd.UniversalRunner");
                    listArguments.add(elt);
                    elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--tool");
                    listArguments.add(elt);
                    elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"Reporter");
                    listArguments.add(elt);
                    if (graph.inputFile == null) {
                        this.getLog().error((CharSequence)"Error grah inputFile is mandatory and inputFile=null");
                        continue;
                    }
                    elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--input-jtl");
                    listArguments.add(elt);
                    elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)graph.inputFile.getAbsolutePath());
                    listArguments.add(elt);
                    if (graph.pluginType == null) {
                        this.getLog().error((CharSequence)"Error graph pluginType is mandatory and pluginType=null");
                        continue;
                    }
                    elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--plugin-type");
                    listArguments.add(elt);
                    elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)graph.pluginType);
                    listArguments.add(elt);
                    if (graph.width != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--width");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)String.valueOf(graph.width));
                        listArguments.add(elt);
                    }
                    if (graph.height != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--height");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)String.valueOf(graph.height));
                        listArguments.add(elt);
                    }
                    if (graph.generatePng != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--generate-png");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)graph.generatePng.getAbsolutePath());
                        listArguments.add(elt);
                    }
                    if (graph.generateCsv != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--generate-csv");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)graph.generateCsv.getAbsolutePath());
                        listArguments.add(elt);
                    }
                    if (graph.limitRows != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--limit-rows");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)String.valueOf(graph.limitRows));
                        listArguments.add(elt);
                    }
                    if (graph.granulation != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--granulation");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)String.valueOf(graph.granulation));
                        listArguments.add(elt);
                    }
                    if (graph.relativeTimes != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--relative-times");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)graph.relativeTimes);
                        listArguments.add(elt);
                    }
                    if (graph.aggregateRows != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--aggregate-rows");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)graph.aggregateRows);
                        listArguments.add(elt);
                    }
                    if (graph.paintGradient != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--paint-gradient");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)graph.paintGradient);
                        listArguments.add(elt);
                    }
                    if (graph.paintZeroing != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--paint-zeroing");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)graph.paintZeroing);
                        listArguments.add(elt);
                    }
                    if (graph.paintMarkers != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--paint-markers");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)graph.paintMarkers);
                        listArguments.add(elt);
                    }
                    if (graph.preventOutliers != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--prevent-outliers");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)graph.preventOutliers);
                        listArguments.add(elt);
                    }
                    if (graph.forceY != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--force-y");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)String.valueOf(graph.forceY));
                        listArguments.add(elt);
                    }
                    if (graph.hideLowCounts != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--hide-low-counts");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)String.valueOf(graph.hideLowCounts));
                        listArguments.add(elt);
                    }
                    if (graph.successFilter != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--success-filter");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)String.valueOf(graph.successFilter));
                        listArguments.add(elt);
                    }
                    if (graph.includeLabels != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--include-labels");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)graph.includeLabels);
                        listArguments.add(elt);
                    }
                    if (graph.excludeLabels != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--exclude-labels");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)graph.excludeLabels);
                        listArguments.add(elt);
                    }
                    if (graph.autoScale != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--auto-scale");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)graph.autoScale);
                        listArguments.add(elt);
                    }
                    if (graph.lineWeight != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--line-weight");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)String.valueOf(graph.lineWeight));
                        listArguments.add(elt);
                    }
                    if (graph.extractorRegexps != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--extractor-regexps");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)graph.extractorRegexps);
                        listArguments.add(elt);
                    }
                    if (graph.includeLabelRegex != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--include-label-regex");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)String.valueOf(graph.includeLabelRegex));
                        listArguments.add(elt);
                    }
                    if (graph.excludeLabelRegex != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--exclude-label-regex");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)String.valueOf(graph.excludeLabelRegex));
                        listArguments.add(elt);
                    }
                    if (graph.startOffset != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--start-offset");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)String.valueOf(graph.startOffset));
                        listArguments.add(elt);
                    }
                    if (graph.endOffset != null) {
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"--end-offset");
                        listArguments.add(elt);
                        elt = MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)String.valueOf(graph.endOffset));
                        listArguments.add(elt);
                    }
                    ArrayList configuration = new ArrayList();
                    configuration.add(MojoExecutor.element((String)"executable", (String)"java"));
                    elements = new ArrayList();
                    for (MojoExecutor.Element argument : listArguments) {
                        elements.add(argument);
                    }
                    parentArgs = new MojoExecutor.Element("arguments", elements.toArray(new MojoExecutor.Element[0]));
                    configuration.add(parentArgs);
                    MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.codehaus.mojo"), (String)MojoExecutor.artifactId((String)"exec-maven-plugin"), (String)MojoExecutor.version((String)"1.2.1")), (String)MojoExecutor.goal((String)"exec"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])configuration.toArray(new MojoExecutor.Element[0])), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        }
    }

    private boolean isJMeterPluginsDependency(Artifact artifact) {
        return this.isDependencyOf(artifact, JMETER_PLUGINS_ARTIFACT_NAME1) || this.isDependencyOf(artifact, JMETER_PLUGINS_ARTIFACT_NAME2);
    }

    private boolean isJMeterDependency(Artifact artifact) {
        return this.isDependencyOf(artifact, JMETER_ARTIFACT_NAME) || this.isDependencyOf(artifact, JMETER_CORE_ARTIFACT_NAME) || this.isDependencyOf(artifact, JMETER_HTTP_ARTIFACT_NAME) || this.isDependencyOf(artifact, COMMON_IO_NAME);
    }

    private boolean isDependencyOf(Artifact artifact, String parentArtifactName) {
        this.getLog().debug((CharSequence)("artifact:" + artifact + ", parentArtifactName:" + parentArtifactName + ", artifact.getDependencyTrail()=" + artifact.getDependencyTrail()));
        for (String parent : artifact.getDependencyTrail()) {
            if (!parent.contains(parentArtifactName)) continue;
            this.getLog().debug((CharSequence)"isDependencyOf=true");
            return true;
        }
        this.getLog().debug((CharSequence)"isDependencyOf=false");
        return false;
    }

    private void createDirectoryIfNotExists(File directory) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Set up jmeter in " + directory));
        if (!directory.exists() && !directory.mkdirs()) {
            throw new MojoExecutionException("Could not make working directory: '" + directory.getAbsolutePath() + "'");
        }
    }

    public static class Graph {
        File inputFile;
        String pluginType;
        Integer width;
        Integer height;
        File generatePng;
        File generateCsv;
        Integer granulation;
        String relativeTimes;
        String aggregateRows;
        String paintGradient;
        String paintZeroing;
        String paintMarkers;
        String preventOutliers;
        Integer limitRows;
        Integer forceY;
        Integer hideLowCounts;
        Boolean successFilter;
        String includeLabels;
        String excludeLabels;
        String autoScale;
        Integer lineWeight;
        String extractorRegexps;
        Boolean includeLabelRegex;
        Boolean excludeLabelRegex;
        Integer startOffset;
        Integer endOffset;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Graph [inputFile=");
            builder.append(this.inputFile);
            builder.append(", pluginType=");
            builder.append(this.pluginType);
            builder.append(", width=");
            builder.append(this.width);
            builder.append(", height=");
            builder.append(this.height);
            builder.append(", generatePng=");
            builder.append(this.generatePng);
            builder.append(", generateCsv=");
            builder.append(this.generateCsv);
            builder.append(", granulation=");
            builder.append(this.granulation);
            builder.append(", relativeTimes=");
            builder.append(this.relativeTimes);
            builder.append(", aggregateRows=");
            builder.append(this.aggregateRows);
            builder.append(", paintGradient=");
            builder.append(this.paintGradient);
            builder.append(", paintZeroing=");
            builder.append(this.paintZeroing);
            builder.append(", paintMarkers=");
            builder.append(this.paintMarkers);
            builder.append(", preventOutliers=");
            builder.append(this.preventOutliers);
            builder.append(", limitRows=");
            builder.append(this.limitRows);
            builder.append(", forceY=");
            builder.append(this.forceY);
            builder.append(", hideLowCounts=");
            builder.append(this.hideLowCounts);
            builder.append(", successFilter=");
            builder.append(this.successFilter);
            builder.append(", includeLabels=");
            builder.append(this.includeLabels);
            builder.append(", excludeLabels=");
            builder.append(this.excludeLabels);
            builder.append(", autoScale=");
            builder.append(this.autoScale);
            builder.append(", lineWeight=");
            builder.append(this.lineWeight);
            builder.append(", extractorRegexps=");
            builder.append(this.extractorRegexps);
            builder.append(", includeLabelRegex=");
            builder.append(this.includeLabelRegex);
            builder.append(", excludeLabelRegex=");
            builder.append(this.excludeLabelRegex);
            builder.append(", startOffset=");
            builder.append(this.startOffset);
            builder.append(", endOffset=");
            builder.append(this.endOffset);
            builder.append("]");
            return builder.toString();
        }
    }

    public static class FilterResultParam {
        File inputFile;
        File outputFile;
        Boolean successFilter;
        String includeLabels;
        Boolean includeLabelRegex;
        String excludeLabels;
        Boolean excludeLabelRegex;
        Integer startOffset;
        Integer endOffset;
        Boolean saveAsXml;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("FilterResultParam [inputFile=");
            builder.append(this.inputFile);
            builder.append(", outputFile=");
            builder.append(this.outputFile);
            builder.append(", successFilter=");
            builder.append(this.successFilter);
            builder.append(", includeLabels=");
            builder.append(this.includeLabels);
            builder.append(", includeLabelRegex=");
            builder.append(this.includeLabelRegex);
            builder.append(", excludeLabels=");
            builder.append(this.excludeLabels);
            builder.append(", excludeLabelRegex=");
            builder.append(this.excludeLabelRegex);
            builder.append(", startOffset=");
            builder.append(this.startOffset);
            builder.append(", endOffset=");
            builder.append(this.endOffset);
            builder.append(", saveAsXml=");
            builder.append(this.saveAsXml);
            builder.append("]");
            return builder.toString();
        }
    }

    public static class JMeterProcessJVMSettings {
        Integer xms;
        Integer xmx;
        List<String> arguments = new ArrayList<String>();

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("JMeterProcessJVMSettings [xms=");
            builder.append(this.xms);
            builder.append(", xmx=");
            builder.append(this.xmx);
            builder.append(", arguments=");
            builder.append(this.arguments);
            builder.append("]");
            return builder.toString();
        }
    }

    public static class propertiesUser {
        List<String> propertiesUser;
    }
}

