/*
 * Decompiled with CFR 0.152.
 */
package io.github.viepovsky.polishutils.pesel;

import io.github.viepovsky.polishutils.pesel.PeselDecoder;
import io.github.viepovsky.polishutils.pesel.PeselDigits;
import io.github.viepovsky.polishutils.pesel.PeselValidator;
import java.time.LocalDate;

public class Pesel
extends PeselDigits {
    private final LocalDate birthDate;
    private final Gender gender;

    public Pesel(String pesel) {
        this(new PeselDecoder(), pesel);
    }

    private Pesel(PeselDecoder peselDecoder, String pesel) {
        PeselValidator.assertIsPeselValid(pesel);
        this.birthDate = peselDecoder.decodeBirthDate(pesel);
        this.gender = peselDecoder.decodeGender(pesel);
        this.setBirthDateDigits(pesel);
        this.setSerialDigits(pesel);
        this.setGenderDigit(pesel);
        this.setControlDigit(pesel);
    }

    public String getGender() {
        return String.valueOf((Object)this.gender);
    }

    public LocalDate getBirthDate() {
        return this.birthDate;
    }

    static enum Gender {
        MALE,
        FEMALE;

    }
}

