/*
 * Decompiled with CFR 0.152.
 */
package io.github.viepovsky.polishutils.pesel;

import io.github.viepovsky.polishutils.pesel.PeselGeneratorParams;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Random;

public class PeselGenerator {
    private static final int[] CONTROL_WEIGHTS = new int[]{1, 3, 7, 9, 1, 3, 7, 9, 1, 3};
    private static final Random RANDOM = new Random();
    private static PeselGeneratorParams.Gender gender;
    private final LocalDate minDate;
    private final LocalDate maxDate;

    public PeselGenerator(PeselGeneratorParams params) {
        gender = params.getGender();
        this.minDate = params.getMinDate();
        this.maxDate = params.getMaxDate();
    }

    public static String generatePeselStatic() {
        LocalDate minDate = PeselGeneratorParams.getDefaultMinDate();
        LocalDate maxDate = PeselGeneratorParams.getDefaultMaxDate();
        return PeselGenerator.generatePesel(minDate, maxDate);
    }

    public String generatePesel() {
        return PeselGenerator.generatePesel(this.minDate, this.maxDate);
    }

    private static String generatePesel(LocalDate minDate, LocalDate maxDate) {
        String birthDateDigits = PeselGenerator.getBirthDateDigit(minDate, maxDate);
        String randomSerialDigits = PeselGenerator.getRandomSerialDigits();
        String genderDigit = PeselGenerator.getGenderRandomDigit();
        String controlDigit = PeselGenerator.getControlDigit(birthDateDigits, randomSerialDigits, genderDigit);
        return birthDateDigits + randomSerialDigits + genderDigit + controlDigit;
    }

    private static String getBirthDateDigit(LocalDate minDate, LocalDate maxDate) {
        LocalDate birthDate = PeselGenerator.getRandomBirthDate(minDate, maxDate);
        return PeselGenerator.encodeBirthDate(birthDate);
    }

    private static LocalDate getRandomBirthDate(LocalDate minDate, LocalDate maxDate) {
        long days = ChronoUnit.DAYS.between(minDate, maxDate);
        return minDate.plusDays(RANDOM.nextLong(days + 1L));
    }

    private static String encodeBirthDate(LocalDate birthDate) {
        int year = birthDate.getYear();
        int month = birthDate.getMonthValue();
        int day = birthDate.getDayOfMonth();
        switch (year / 100) {
            case 18: {
                month += 80;
                break;
            }
            case 20: {
                month += 20;
                break;
            }
            case 21: {
                month += 40;
                break;
            }
            case 22: {
                month += 60;
            }
        }
        Object encodedBirthDate = "";
        encodedBirthDate = String.valueOf(year % 100).length() == 1 ? (String)encodedBirthDate + "0" + year % 100 : (String)encodedBirthDate + year % 100;
        encodedBirthDate = String.valueOf(month).length() == 1 ? (String)encodedBirthDate + "0" + month : (String)encodedBirthDate + month;
        encodedBirthDate = String.valueOf(day).length() == 1 ? (String)encodedBirthDate + "0" + day : (String)encodedBirthDate + day;
        return encodedBirthDate;
    }

    private static String getRandomSerialDigits() {
        return String.valueOf(RANDOM.nextInt(10)) + RANDOM.nextInt(10) + RANDOM.nextInt(10);
    }

    private static String getGenderRandomDigit() {
        if (!PeselGenerator.isGenderGiven()) {
            PeselGenerator.setRandomGender();
            String genderDigit = PeselGenerator.checkGenderAndEncodeDigit();
            gender = null;
            return genderDigit;
        }
        return PeselGenerator.checkGenderAndEncodeDigit();
    }

    private static boolean isGenderGiven() {
        return gender != null;
    }

    private static void setRandomGender() {
        gender = RANDOM.nextInt(10) % 2 == 0 ? PeselGeneratorParams.Gender.FEMALE : PeselGeneratorParams.Gender.MALE;
    }

    private static String checkGenderAndEncodeDigit() {
        if (gender.equals((Object)PeselGeneratorParams.Gender.FEMALE)) {
            return PeselGenerator.encodeRandomFemaleDigit();
        }
        return PeselGenerator.encodeRandomMaleDigit();
    }

    private static String encodeRandomFemaleDigit() {
        return String.valueOf(RANDOM.nextInt(5) * 2);
    }

    private static String encodeRandomMaleDigit() {
        return String.valueOf(RANDOM.nextInt(5) * 2 + 1);
    }

    private static String getControlDigit(String birthDateDigits, String randomSerialDigits, String genderDigit) {
        String pesel = birthDateDigits + randomSerialDigits + genderDigit;
        int controlSum = 0;
        for (int i = 0; i < 10; ++i) {
            int multipliedNumber = CONTROL_WEIGHTS[i] * Character.getNumericValue(pesel.charAt(i));
            if (multipliedNumber >= 10) {
                controlSum += Character.getNumericValue(String.valueOf(multipliedNumber).charAt(1));
                continue;
            }
            controlSum += multipliedNumber;
        }
        if ((controlSum %= 10) == 0) {
            return "0";
        }
        return String.valueOf(10 - controlSum);
    }
}

