/*
 * Decompiled with CFR 0.152.
 */
package io.github.viepovsky.polishutils.pesel;

import java.time.LocalDate;

public class PeselGeneratorParams {
    private static final LocalDate MIN_DATE_POSSIBLE = LocalDate.of(1800, 1, 1);
    private static final LocalDate MAX_DATE_POSSIBLE = LocalDate.of(2299, 12, 31);
    private static final LocalDate DEFAULT_MIN_DATE = LocalDate.now().minusYears(100L);
    private static final LocalDate DEFAULT_MAX_DATE = LocalDate.now();
    private final Gender gender;
    private LocalDate minDate;
    private LocalDate maxDate;

    private PeselGeneratorParams(Builder builder) {
        this.gender = builder.gender;
        if (builder.minDate != null && builder.maxDate != null) {
            this.minDate = builder.minDate;
            this.maxDate = builder.maxDate;
        } else if (builder.minDate == null && builder.maxDate == null) {
            this.minDate = DEFAULT_MIN_DATE;
            this.maxDate = DEFAULT_MAX_DATE;
        } else {
            this.minDate = builder.minDate == null ? MIN_DATE_POSSIBLE : builder.minDate;
            LocalDate localDate = this.maxDate = builder.maxDate == null ? MAX_DATE_POSSIBLE : builder.maxDate;
        }
        if (this.minDate.isAfter(this.maxDate)) {
            LocalDate tempDate = this.minDate;
            this.minDate = this.maxDate;
            this.maxDate = tempDate;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    Gender getGender() {
        return this.gender;
    }

    LocalDate getMinDate() {
        return this.minDate;
    }

    LocalDate getMaxDate() {
        return this.maxDate;
    }

    static LocalDate getDefaultMinDate() {
        return DEFAULT_MIN_DATE;
    }

    static LocalDate getDefaultMaxDate() {
        return DEFAULT_MAX_DATE;
    }

    public static final class Builder {
        private Gender gender;
        private LocalDate minDate;
        private LocalDate maxDate;

        public Builder gender(Gender gender) {
            this.gender = gender;
            return this;
        }

        public Builder minDate(LocalDate minDate) {
            if (minDate.isBefore(MAX_DATE_POSSIBLE.plusDays(1L)) && minDate.isAfter(MIN_DATE_POSSIBLE.minusDays(1L))) {
                this.minDate = minDate;
                return this;
            }
            throw new IllegalArgumentException("Min and max dates should be between: " + MIN_DATE_POSSIBLE + " and " + MAX_DATE_POSSIBLE);
        }

        public Builder maxDate(LocalDate maxDate) {
            if (maxDate.isBefore(MAX_DATE_POSSIBLE.plusDays(1L)) && maxDate.isAfter(MIN_DATE_POSSIBLE.minusDays(1L))) {
                this.maxDate = maxDate;
                return this;
            }
            throw new IllegalArgumentException("Min and max dates should be between: " + MIN_DATE_POSSIBLE + " and " + MAX_DATE_POSSIBLE);
        }

        public PeselGeneratorParams build() {
            return new PeselGeneratorParams(this);
        }
    }

    public static enum Gender {
        MALE,
        FEMALE;

    }
}

