package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  HistoryData,
  HistorySummary,
  Timestamp,
  AlarmName
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AlarmHistoryItem(
    alarmName: Option[AlarmName] = None,
    alarmType: Option[io.github.vigoo.zioaws.cloudwatch.model.AlarmType] = None,
    timestamp: Option[Timestamp] = None,
    historyItemType: Option[
      io.github.vigoo.zioaws.cloudwatch.model.HistoryItemType
    ] = None,
    historySummary: Option[HistorySummary] = None,
    historyData: Option[HistoryData] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.AlarmHistoryItem = {
    import AlarmHistoryItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.AlarmHistoryItem
      .builder()
      .optionallyWith(alarmName.map(value => value: java.lang.String))(
        _.alarmName
      )
      .optionallyWith(alarmType.map(value => value.unwrap))(_.alarmType)
      .optionallyWith(timestamp.map(value => value: Instant))(_.timestamp)
      .optionallyWith(historyItemType.map(value => value.unwrap))(
        _.historyItemType
      )
      .optionallyWith(historySummary.map(value => value: java.lang.String))(
        _.historySummary
      )
      .optionallyWith(historyData.map(value => value: java.lang.String))(
        _.historyData
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.AlarmHistoryItem.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.AlarmHistoryItem
      .wrap(buildAwsValue())
}
object AlarmHistoryItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.AlarmHistoryItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.AlarmHistoryItem =
      io.github.vigoo.zioaws.cloudwatch.model.AlarmHistoryItem(
        alarmNameValue.map(value => value),
        alarmTypeValue.map(value => value),
        timestampValue.map(value => value),
        historyItemTypeValue.map(value => value),
        historySummaryValue.map(value => value),
        historyDataValue.map(value => value)
      )
    def alarmNameValue: Option[AlarmName]
    def alarmTypeValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.AlarmType]
    def timestampValue: Option[Timestamp]
    def historyItemTypeValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.HistoryItemType]
    def historySummaryValue: Option[HistorySummary]
    def historyDataValue: Option[HistoryData]
    def alarmName: ZIO[Any, AwsError, AlarmName] =
      AwsError.unwrapOptionField("alarmName", alarmNameValue)
    def alarmType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.AlarmType
    ] = AwsError.unwrapOptionField("alarmType", alarmTypeValue)
    def timestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestampValue)
    def historyItemType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.HistoryItemType
    ] = AwsError.unwrapOptionField("historyItemType", historyItemTypeValue)
    def historySummary: ZIO[Any, AwsError, HistorySummary] =
      AwsError.unwrapOptionField("historySummary", historySummaryValue)
    def historyData: ZIO[Any, AwsError, HistoryData] =
      AwsError.unwrapOptionField("historyData", historyDataValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.AlarmHistoryItem
  ) extends io.github.vigoo.zioaws.cloudwatch.model.AlarmHistoryItem.ReadOnly {
    override def alarmNameValue: Option[AlarmName] =
      scala.Option(impl.alarmName()).map(value => value: AlarmName)
    override def alarmTypeValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.AlarmType] = scala
      .Option(impl.alarmType())
      .map(value =>
        io.github.vigoo.zioaws.cloudwatch.model.AlarmType.wrap(value)
      )
    override def timestampValue: Option[Timestamp] =
      scala.Option(impl.timestamp()).map(value => value: Timestamp)
    override def historyItemTypeValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.HistoryItemType] =
      scala
        .Option(impl.historyItemType())
        .map(value =>
          io.github.vigoo.zioaws.cloudwatch.model.HistoryItemType.wrap(value)
        )
    override def historySummaryValue: Option[HistorySummary] =
      scala.Option(impl.historySummary()).map(value => value: HistorySummary)
    override def historyDataValue: Option[HistoryData] =
      scala.Option(impl.historyData()).map(value => value: HistoryData)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.AlarmHistoryItem
  ): io.github.vigoo.zioaws.cloudwatch.model.AlarmHistoryItem.ReadOnly =
    new Wrapper(impl)
}
