package io.github.vigoo.zioaws.cloudwatch.model
import scala.jdk.CollectionConverters._
sealed trait AlarmType {
  def unwrap: software.amazon.awssdk.services.cloudwatch.model.AlarmType
}
object AlarmType {
  def wrap(
      value: software.amazon.awssdk.services.cloudwatch.model.AlarmType
  ): io.github.vigoo.zioaws.cloudwatch.model.AlarmType = value match {
    case software.amazon.awssdk.services.cloudwatch.model.AlarmType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudwatch.model.AlarmType.COMPOSITE_ALARM =>
      val r = CompositeAlarm
      r
    case software.amazon.awssdk.services.cloudwatch.model.AlarmType.METRIC_ALARM =>
      val r = MetricAlarm
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.cloudwatch.model.AlarmType {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.AlarmType =
      software.amazon.awssdk.services.cloudwatch.model.AlarmType.UNKNOWN_TO_SDK_VERSION
  }
  case object CompositeAlarm
      extends io.github.vigoo.zioaws.cloudwatch.model.AlarmType {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.AlarmType =
      software.amazon.awssdk.services.cloudwatch.model.AlarmType.COMPOSITE_ALARM
  }
  case object MetricAlarm
      extends io.github.vigoo.zioaws.cloudwatch.model.AlarmType {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.AlarmType =
      software.amazon.awssdk.services.cloudwatch.model.AlarmType.METRIC_ALARM
  }
}
