package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  AnomalyDetectorMetricStat,
  MetricName,
  Namespace
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AnomalyDetector(
    namespace: Option[Namespace] = None,
    metricName: Option[MetricName] = None,
    dimensions: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.Dimension]
    ] = None,
    stat: Option[AnomalyDetectorMetricStat] = None,
    configuration: Option[
      io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetectorConfiguration
    ] = None,
    stateValue: Option[
      io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetectorStateValue
    ] = None,
    singleMetricAnomalyDetector: Option[
      io.github.vigoo.zioaws.cloudwatch.model.SingleMetricAnomalyDetector
    ] = None,
    metricMathAnomalyDetector: Option[
      io.github.vigoo.zioaws.cloudwatch.model.MetricMathAnomalyDetector
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.AnomalyDetector = {
    import AnomalyDetector.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.AnomalyDetector
      .builder()
      .optionallyWith(namespace.map(value => value: java.lang.String))(
        _.namespace
      )
      .optionallyWith(metricName.map(value => value: java.lang.String))(
        _.metricName
      )
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .optionallyWith(stat.map(value => value: java.lang.String))(_.stat)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(stateValue.map(value => value.unwrap))(_.stateValue)
      .optionallyWith(
        singleMetricAnomalyDetector.map(value => value.buildAwsValue())
      )(_.singleMetricAnomalyDetector)
      .optionallyWith(
        metricMathAnomalyDetector.map(value => value.buildAwsValue())
      )(_.metricMathAnomalyDetector)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetector.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetector
      .wrap(buildAwsValue())
}
object AnomalyDetector {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.AnomalyDetector
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetector =
      io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetector(
        namespaceValue.map(value => value),
        metricNameValue.map(value => value),
        dimensionsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        statValue.map(value => value),
        configurationValue.map(value => value.editable),
        stateValueValue.map(value => value),
        singleMetricAnomalyDetectorValue.map(value => value.editable),
        metricMathAnomalyDetectorValue.map(value => value.editable)
      )
    def namespaceValue: Option[Namespace]
    def metricNameValue: Option[MetricName]
    def dimensionsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly]
    ]
    def statValue: Option[AnomalyDetectorMetricStat]
    def configurationValue: Option[
      io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetectorConfiguration.ReadOnly
    ]
    def stateValueValue: Option[
      io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetectorStateValue
    ]
    def singleMetricAnomalyDetectorValue: Option[
      io.github.vigoo.zioaws.cloudwatch.model.SingleMetricAnomalyDetector.ReadOnly
    ]
    def metricMathAnomalyDetectorValue: Option[
      io.github.vigoo.zioaws.cloudwatch.model.MetricMathAnomalyDetector.ReadOnly
    ]
    def namespace: ZIO[Any, AwsError, Namespace] =
      AwsError.unwrapOptionField("namespace", namespaceValue)
    def metricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricNameValue)
    def dimensions: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensionsValue)
    def stat: ZIO[Any, AwsError, AnomalyDetectorMetricStat] =
      AwsError.unwrapOptionField("stat", statValue)
    def configuration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetectorConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configurationValue)
    def stateValue: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetectorStateValue
    ] = AwsError.unwrapOptionField("stateValue", stateValueValue)
    def singleMetricAnomalyDetector: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.SingleMetricAnomalyDetector.ReadOnly
    ] = AwsError.unwrapOptionField(
      "singleMetricAnomalyDetector",
      singleMetricAnomalyDetectorValue
    )
    def metricMathAnomalyDetector: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.MetricMathAnomalyDetector.ReadOnly
    ] = AwsError.unwrapOptionField(
      "metricMathAnomalyDetector",
      metricMathAnomalyDetectorValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.AnomalyDetector
  ) extends io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetector.ReadOnly {
    override def namespaceValue: Option[Namespace] =
      scala.Option(impl.namespace()).map(value => value: Namespace)
    override def metricNameValue: Option[MetricName] =
      scala.Option(impl.metricName()).map(value => value: MetricName)
    override def dimensionsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly]
    ] = scala
      .Option(impl.dimensions())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.Dimension.wrap(item)
        }.toList
      )
    override def statValue: Option[AnomalyDetectorMetricStat] =
      scala.Option(impl.stat()).map(value => value: AnomalyDetectorMetricStat)
    override def configurationValue: Option[
      io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetectorConfiguration.ReadOnly
    ] = scala
      .Option(impl.configuration())
      .map(value =>
        io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetectorConfiguration
          .wrap(value)
      )
    override def stateValueValue: Option[
      io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetectorStateValue
    ] = scala
      .Option(impl.stateValue())
      .map(value =>
        io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetectorStateValue
          .wrap(value)
      )
    override def singleMetricAnomalyDetectorValue: Option[
      io.github.vigoo.zioaws.cloudwatch.model.SingleMetricAnomalyDetector.ReadOnly
    ] = scala
      .Option(impl.singleMetricAnomalyDetector())
      .map(value =>
        io.github.vigoo.zioaws.cloudwatch.model.SingleMetricAnomalyDetector
          .wrap(value)
      )
    override def metricMathAnomalyDetectorValue: Option[
      io.github.vigoo.zioaws.cloudwatch.model.MetricMathAnomalyDetector.ReadOnly
    ] = scala
      .Option(impl.metricMathAnomalyDetector())
      .map(value =>
        io.github.vigoo.zioaws.cloudwatch.model.MetricMathAnomalyDetector
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.AnomalyDetector
  ): io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetector.ReadOnly =
    new Wrapper(impl)
}
