package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.AnomalyDetectorMetricTimezone
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AnomalyDetectorConfiguration(
    excludedTimeRanges: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.Range]
    ] = None,
    metricTimezone: Option[AnomalyDetectorMetricTimezone] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorConfiguration = {
    import AnomalyDetectorConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorConfiguration
      .builder()
      .optionallyWith(
        excludedTimeRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludedTimeRanges)
      .optionallyWith(metricTimezone.map(value => value: java.lang.String))(
        _.metricTimezone
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetectorConfiguration.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetectorConfiguration
      .wrap(buildAwsValue())
}
object AnomalyDetectorConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetectorConfiguration =
      io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetectorConfiguration(
        excludedTimeRangesValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        metricTimezoneValue.map(value => value)
      )
    def excludedTimeRangesValue
        : Option[List[io.github.vigoo.zioaws.cloudwatch.model.Range.ReadOnly]]
    def metricTimezoneValue: Option[AnomalyDetectorMetricTimezone]
    def excludedTimeRanges: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.Range.ReadOnly
    ]] =
      AwsError.unwrapOptionField("excludedTimeRanges", excludedTimeRangesValue)
    def metricTimezone: ZIO[Any, AwsError, AnomalyDetectorMetricTimezone] =
      AwsError.unwrapOptionField("metricTimezone", metricTimezoneValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorConfiguration
  ) extends io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetectorConfiguration.ReadOnly {
    override def excludedTimeRangesValue
        : Option[List[io.github.vigoo.zioaws.cloudwatch.model.Range.ReadOnly]] =
      scala
        .Option(impl.excludedTimeRanges())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.cloudwatch.model.Range.wrap(item)
          }.toList
        )
    override def metricTimezoneValue: Option[AnomalyDetectorMetricTimezone] =
      scala
        .Option(impl.metricTimezone())
        .map(value => value: AnomalyDetectorMetricTimezone)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorConfiguration
  ): io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetectorConfiguration.ReadOnly =
    new Wrapper(impl)
}
