package io.github.vigoo.zioaws.cloudwatch.model
import scala.jdk.CollectionConverters._
sealed trait AnomalyDetectorType {
  def unwrap
      : software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorType
}
object AnomalyDetectorType {
  def wrap(
      value: software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorType
  ): io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetectorType = value match {
    case software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorType.SINGLE_METRIC =>
      val r = SINGLE_METRIC
      r
    case software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorType.METRIC_MATH =>
      val r = METRIC_MATH
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetectorType {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorType =
      software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorType.UNKNOWN_TO_SDK_VERSION
  }
  case object SINGLE_METRIC
      extends io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetectorType {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorType =
      software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorType.SINGLE_METRIC
  }
  case object METRIC_MATH
      extends io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetectorType {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorType =
      software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorType.METRIC_MATH
  }
}
