package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.ZIO
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  ActionsSuppressedReason,
  StateReason,
  ActionsEnabled,
  AlarmName,
  Timestamp,
  AlarmArn,
  SuppressorPeriod,
  AlarmDescription,
  AlarmRule,
  StateReasonData,
  ResourceName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CompositeAlarm(
    actionsEnabled: Option[ActionsEnabled] = None,
    alarmActions: Option[Iterable[ResourceName]] = None,
    alarmArn: Option[AlarmArn] = None,
    alarmConfigurationUpdatedTimestamp: Option[Timestamp] = None,
    alarmDescription: Option[AlarmDescription] = None,
    alarmName: Option[AlarmName] = None,
    alarmRule: Option[AlarmRule] = None,
    insufficientDataActions: Option[Iterable[ResourceName]] = None,
    okActions: Option[Iterable[ResourceName]] = None,
    stateReason: Option[StateReason] = None,
    stateReasonData: Option[StateReasonData] = None,
    stateUpdatedTimestamp: Option[Timestamp] = None,
    stateValue: Option[io.github.vigoo.zioaws.cloudwatch.model.StateValue] =
      None,
    stateTransitionedTimestamp: Option[Timestamp] = None,
    actionsSuppressedBy: Option[
      io.github.vigoo.zioaws.cloudwatch.model.ActionsSuppressedBy
    ] = None,
    actionsSuppressedReason: Option[ActionsSuppressedReason] = None,
    actionsSuppressor: Option[AlarmArn] = None,
    actionsSuppressorWaitPeriod: Option[SuppressorPeriod] = None,
    actionsSuppressorExtensionPeriod: Option[SuppressorPeriod] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.CompositeAlarm = {
    import CompositeAlarm.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.CompositeAlarm
      .builder()
      .optionallyWith(actionsEnabled.map(value => value: java.lang.Boolean))(
        _.actionsEnabled
      )
      .optionallyWith(
        alarmActions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.alarmActions)
      .optionallyWith(alarmArn.map(value => value: java.lang.String))(
        _.alarmArn
      )
      .optionallyWith(
        alarmConfigurationUpdatedTimestamp.map(value => value: Instant)
      )(_.alarmConfigurationUpdatedTimestamp)
      .optionallyWith(alarmDescription.map(value => value: java.lang.String))(
        _.alarmDescription
      )
      .optionallyWith(alarmName.map(value => value: java.lang.String))(
        _.alarmName
      )
      .optionallyWith(alarmRule.map(value => value: java.lang.String))(
        _.alarmRule
      )
      .optionallyWith(
        insufficientDataActions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.insufficientDataActions)
      .optionallyWith(
        okActions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.okActions)
      .optionallyWith(stateReason.map(value => value: java.lang.String))(
        _.stateReason
      )
      .optionallyWith(stateReasonData.map(value => value: java.lang.String))(
        _.stateReasonData
      )
      .optionallyWith(stateUpdatedTimestamp.map(value => value: Instant))(
        _.stateUpdatedTimestamp
      )
      .optionallyWith(stateValue.map(value => value.unwrap))(_.stateValue)
      .optionallyWith(stateTransitionedTimestamp.map(value => value: Instant))(
        _.stateTransitionedTimestamp
      )
      .optionallyWith(actionsSuppressedBy.map(value => value.unwrap))(
        _.actionsSuppressedBy
      )
      .optionallyWith(
        actionsSuppressedReason.map(value => value: java.lang.String)
      )(_.actionsSuppressedReason)
      .optionallyWith(actionsSuppressor.map(value => value: java.lang.String))(
        _.actionsSuppressor
      )
      .optionallyWith(actionsSuppressorWaitPeriod.map(value => value: Integer))(
        _.actionsSuppressorWaitPeriod
      )
      .optionallyWith(
        actionsSuppressorExtensionPeriod.map(value => value: Integer)
      )(_.actionsSuppressorExtensionPeriod)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.CompositeAlarm.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.CompositeAlarm.wrap(buildAwsValue())
}
object CompositeAlarm {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.CompositeAlarm
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.CompositeAlarm =
      io.github.vigoo.zioaws.cloudwatch.model.CompositeAlarm(
        actionsEnabledValue.map(value => value),
        alarmActionsValue.map(value => value),
        alarmArnValue.map(value => value),
        alarmConfigurationUpdatedTimestampValue.map(value => value),
        alarmDescriptionValue.map(value => value),
        alarmNameValue.map(value => value),
        alarmRuleValue.map(value => value),
        insufficientDataActionsValue.map(value => value),
        okActionsValue.map(value => value),
        stateReasonValue.map(value => value),
        stateReasonDataValue.map(value => value),
        stateUpdatedTimestampValue.map(value => value),
        stateValueValue.map(value => value),
        stateTransitionedTimestampValue.map(value => value),
        actionsSuppressedByValue.map(value => value),
        actionsSuppressedReasonValue.map(value => value),
        actionsSuppressorValue.map(value => value),
        actionsSuppressorWaitPeriodValue.map(value => value),
        actionsSuppressorExtensionPeriodValue.map(value => value)
      )
    def actionsEnabledValue: Option[ActionsEnabled]
    def alarmActionsValue: Option[List[ResourceName]]
    def alarmArnValue: Option[AlarmArn]
    def alarmConfigurationUpdatedTimestampValue: Option[Timestamp]
    def alarmDescriptionValue: Option[AlarmDescription]
    def alarmNameValue: Option[AlarmName]
    def alarmRuleValue: Option[AlarmRule]
    def insufficientDataActionsValue: Option[List[ResourceName]]
    def okActionsValue: Option[List[ResourceName]]
    def stateReasonValue: Option[StateReason]
    def stateReasonDataValue: Option[StateReasonData]
    def stateUpdatedTimestampValue: Option[Timestamp]
    def stateValueValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.StateValue]
    def stateTransitionedTimestampValue: Option[Timestamp]
    def actionsSuppressedByValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.ActionsSuppressedBy]
    def actionsSuppressedReasonValue: Option[ActionsSuppressedReason]
    def actionsSuppressorValue: Option[AlarmArn]
    def actionsSuppressorWaitPeriodValue: Option[SuppressorPeriod]
    def actionsSuppressorExtensionPeriodValue: Option[SuppressorPeriod]
    def actionsEnabled: ZIO[Any, AwsError, ActionsEnabled] =
      AwsError.unwrapOptionField("actionsEnabled", actionsEnabledValue)
    def alarmActions: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField("alarmActions", alarmActionsValue)
    def alarmArn: ZIO[Any, AwsError, AlarmArn] =
      AwsError.unwrapOptionField("alarmArn", alarmArnValue)
    def alarmConfigurationUpdatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "alarmConfigurationUpdatedTimestamp",
        alarmConfigurationUpdatedTimestampValue
      )
    def alarmDescription: ZIO[Any, AwsError, AlarmDescription] =
      AwsError.unwrapOptionField("alarmDescription", alarmDescriptionValue)
    def alarmName: ZIO[Any, AwsError, AlarmName] =
      AwsError.unwrapOptionField("alarmName", alarmNameValue)
    def alarmRule: ZIO[Any, AwsError, AlarmRule] =
      AwsError.unwrapOptionField("alarmRule", alarmRuleValue)
    def insufficientDataActions: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField(
        "insufficientDataActions",
        insufficientDataActionsValue
      )
    def okActions: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField("okActions", okActionsValue)
    def stateReason: ZIO[Any, AwsError, StateReason] =
      AwsError.unwrapOptionField("stateReason", stateReasonValue)
    def stateReasonData: ZIO[Any, AwsError, StateReasonData] =
      AwsError.unwrapOptionField("stateReasonData", stateReasonDataValue)
    def stateUpdatedTimestamp: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("stateUpdatedTimestamp", stateUpdatedTimestampValue)
    def stateValue: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.StateValue
    ] = AwsError.unwrapOptionField("stateValue", stateValueValue)
    def stateTransitionedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "stateTransitionedTimestamp",
        stateTransitionedTimestampValue
      )
    def actionsSuppressedBy: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.ActionsSuppressedBy
    ] = AwsError.unwrapOptionField(
      "actionsSuppressedBy",
      actionsSuppressedByValue
    )
    def actionsSuppressedReason: ZIO[Any, AwsError, ActionsSuppressedReason] =
      AwsError.unwrapOptionField(
        "actionsSuppressedReason",
        actionsSuppressedReasonValue
      )
    def actionsSuppressor: ZIO[Any, AwsError, AlarmArn] =
      AwsError.unwrapOptionField("actionsSuppressor", actionsSuppressorValue)
    def actionsSuppressorWaitPeriod: ZIO[Any, AwsError, SuppressorPeriod] =
      AwsError.unwrapOptionField(
        "actionsSuppressorWaitPeriod",
        actionsSuppressorWaitPeriodValue
      )
    def actionsSuppressorExtensionPeriod: ZIO[Any, AwsError, SuppressorPeriod] =
      AwsError.unwrapOptionField(
        "actionsSuppressorExtensionPeriod",
        actionsSuppressorExtensionPeriodValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.CompositeAlarm
  ) extends io.github.vigoo.zioaws.cloudwatch.model.CompositeAlarm.ReadOnly {
    override def actionsEnabledValue: Option[ActionsEnabled] =
      scala.Option(impl.actionsEnabled()).map(value => value: ActionsEnabled)
    override def alarmActionsValue: Option[List[ResourceName]] = scala
      .Option(impl.alarmActions())
      .map(value =>
        value.asScala.map { item =>
          item: ResourceName
        }.toList
      )
    override def alarmArnValue: Option[AlarmArn] =
      scala.Option(impl.alarmArn()).map(value => value: AlarmArn)
    override def alarmConfigurationUpdatedTimestampValue: Option[Timestamp] =
      scala
        .Option(impl.alarmConfigurationUpdatedTimestamp())
        .map(value => value: Timestamp)
    override def alarmDescriptionValue: Option[AlarmDescription] = scala
      .Option(impl.alarmDescription())
      .map(value => value: AlarmDescription)
    override def alarmNameValue: Option[AlarmName] =
      scala.Option(impl.alarmName()).map(value => value: AlarmName)
    override def alarmRuleValue: Option[AlarmRule] =
      scala.Option(impl.alarmRule()).map(value => value: AlarmRule)
    override def insufficientDataActionsValue: Option[List[ResourceName]] =
      scala
        .Option(impl.insufficientDataActions())
        .map(value =>
          value.asScala.map { item =>
            item: ResourceName
          }.toList
        )
    override def okActionsValue: Option[List[ResourceName]] = scala
      .Option(impl.okActions())
      .map(value =>
        value.asScala.map { item =>
          item: ResourceName
        }.toList
      )
    override def stateReasonValue: Option[StateReason] =
      scala.Option(impl.stateReason()).map(value => value: StateReason)
    override def stateReasonDataValue: Option[StateReasonData] =
      scala.Option(impl.stateReasonData()).map(value => value: StateReasonData)
    override def stateUpdatedTimestampValue: Option[Timestamp] =
      scala.Option(impl.stateUpdatedTimestamp()).map(value => value: Timestamp)
    override def stateValueValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.StateValue] = scala
      .Option(impl.stateValue())
      .map(value =>
        io.github.vigoo.zioaws.cloudwatch.model.StateValue.wrap(value)
      )
    override def stateTransitionedTimestampValue: Option[Timestamp] = scala
      .Option(impl.stateTransitionedTimestamp())
      .map(value => value: Timestamp)
    override def actionsSuppressedByValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.ActionsSuppressedBy] =
      scala
        .Option(impl.actionsSuppressedBy())
        .map(value =>
          io.github.vigoo.zioaws.cloudwatch.model.ActionsSuppressedBy
            .wrap(value)
        )
    override def actionsSuppressedReasonValue: Option[ActionsSuppressedReason] =
      scala
        .Option(impl.actionsSuppressedReason())
        .map(value => value: ActionsSuppressedReason)
    override def actionsSuppressorValue: Option[AlarmArn] =
      scala.Option(impl.actionsSuppressor()).map(value => value: AlarmArn)
    override def actionsSuppressorWaitPeriodValue: Option[SuppressorPeriod] =
      scala
        .Option(impl.actionsSuppressorWaitPeriod())
        .map(value => value: SuppressorPeriod)
    override def actionsSuppressorExtensionPeriodValue
        : Option[SuppressorPeriod] = scala
      .Option(impl.actionsSuppressorExtensionPeriod())
      .map(value => value: SuppressorPeriod)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.CompositeAlarm
  ): io.github.vigoo.zioaws.cloudwatch.model.CompositeAlarm.ReadOnly =
    new Wrapper(impl)
}
